/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.neighbor_evaluator;

import cc.mallet.classify.Classifier;
import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.neighbor_evaluator.AgglomerativeNeighbor;
import cc.mallet.cluster.neighbor_evaluator.ClassifyingNeighborEvaluator;
import cc.mallet.cluster.neighbor_evaluator.Neighbor;
import cc.mallet.cluster.util.PairwiseMatrix;
import cc.mallet.types.MatrixOps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class PairwiseEvaluator
extends ClassifyingNeighborEvaluator {
    private static final long serialVersionUID = 1L;
    CombiningStrategy combiningStrategy;
    boolean mergeFirst;
    PairwiseMatrix scoreCache;

    public PairwiseEvaluator(Classifier classifier, String scoringLabel, CombiningStrategy combiningStrategy, boolean mergeFirst) {
        super(classifier, scoringLabel);
        this.combiningStrategy = combiningStrategy;
        this.mergeFirst = mergeFirst;
    }

    @Override
    public double[] evaluate(Neighbor[] neighbors) {
        double[] scores = new double[neighbors.length];
        int i = 0;
        while (i < neighbors.length) {
            scores[i] = this.evaluate(neighbors[i]);
            ++i;
        }
        return scores;
    }

    @Override
    public double evaluate(Neighbor neighbor) {
        AgglomerativeNeighbor pwneighbor;
        int j;
        if (!(neighbor instanceof AgglomerativeNeighbor)) {
            throw new IllegalArgumentException("Expect AgglomerativeNeighbor not " + neighbor.getClass().getName());
        }
        AgglomerativeNeighbor aneighbor = (AgglomerativeNeighbor)neighbor;
        Clustering original = neighbor.getOriginal();
        int[] cluster1 = aneighbor.getOldClusters()[0];
        int[] cluster2 = aneighbor.getOldClusters()[1];
        ArrayList<Double> scores = new ArrayList<Double>();
        int i = 0;
        while (i < cluster1.length) {
            j = 0;
            while (j < cluster2.length) {
                pwneighbor = new AgglomerativeNeighbor(original, original, cluster1[i], cluster2[j]);
                scores.add(new Double(this.getScore(pwneighbor)));
                ++j;
            }
            ++i;
        }
        if (this.mergeFirst) {
            i = 0;
            while (i < cluster1.length) {
                j = i + 1;
                while (j < cluster1.length) {
                    pwneighbor = new AgglomerativeNeighbor(original, original, cluster1[i], cluster1[j]);
                    scores.add(new Double(this.getScore(pwneighbor)));
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < cluster2.length) {
                j = i + 1;
                while (j < cluster2.length) {
                    pwneighbor = new AgglomerativeNeighbor(original, original, cluster2[i], cluster2[j]);
                    scores.add(new Double(this.getScore(pwneighbor)));
                    ++j;
                }
                ++i;
            }
        }
        if (scores.size() < 1) {
            throw new IllegalStateException("No pairs of Instances were scored.");
        }
        double[] vals = new double[scores.size()];
        int i2 = 0;
        while (i2 < vals.length) {
            vals[i2] = (Double)scores.get(i2);
            ++i2;
        }
        return this.combiningStrategy.combine(vals);
    }

    @Override
    public void reset() {
        this.scoreCache = null;
    }

    @Override
    public String toString() {
        return "class=" + this.getClass().getName() + " classifier=" + this.classifier.getClass().getName();
    }

    private double getScore(AgglomerativeNeighbor pwneighbor) {
        int[] indices;
        if (this.scoreCache == null) {
            this.scoreCache = new PairwiseMatrix(pwneighbor.getOriginal().getNumInstances());
        }
        if (this.scoreCache.get((indices = pwneighbor.getNewCluster())[0], indices[1]) == 0.0) {
            this.scoreCache.set(indices[0], indices[1], this.classifier.classify(pwneighbor).getLabelVector().value(this.scoringLabel));
        }
        return this.scoreCache.get(indices[0], indices[1]);
    }

    public static class Average
    implements CombiningStrategy,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 1;

        @Override
        public double combine(double[] scores) {
            return MatrixOps.mean(scores);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeInt(1);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int version = in.readInt();
        }
    }

    public static interface CombiningStrategy {
        public double combine(double[] var1);
    }

    public static class Maximum
    implements CombiningStrategy,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 1;

        @Override
        public double combine(double[] scores) {
            return MatrixOps.max(scores);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeInt(1);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int version = in.readInt();
        }
    }

    public static class Minimum
    implements CombiningStrategy,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 1;

        @Override
        public double combine(double[] scores) {
            return MatrixOps.min(scores);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeInt(1);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int version = in.readInt();
        }
    }
}

