/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.Segment;
import cc.mallet.fst.SumLattice;
import cc.mallet.fst.SumLatticeFactory;
import cc.mallet.fst.Transducer;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelVector;
import cc.mallet.types.MatrixOps;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SumLatticeBeam
implements SumLattice {
    boolean UseForwardBackwardBeam = false;
    protected static int beamWidth = 3;
    private double KLeps = 0.0;
    private double Rmin = 0.1;
    private double[] nstatesExpl;
    private int curIter = 0;
    int tctIter = 0;
    private double curAvgNstatesExpl;
    private static Logger logger = MalletLogger.getLogger(SumLatticeBeam.class.getName());
    Transducer t;
    double weight;
    Sequence input;
    Sequence output;
    LatticeNode[][] nodes;
    int latticeLength;
    int curBeamWidth;
    double[][] gammas;
    double[][][] xis;
    LabelVector[] labelings;

    public int getBeamWidth() {
        return beamWidth;
    }

    public void setBeamWidth(int beamWidth) {
        SumLatticeBeam.beamWidth = beamWidth;
    }

    public int getTctIter() {
        return this.tctIter;
    }

    public void setCurIter(int curIter) {
        this.curIter = curIter;
        this.tctIter = 0;
    }

    public void incIter() {
        ++this.tctIter;
    }

    public void setKLeps(double KLeps) {
        this.KLeps = KLeps;
    }

    public void setRmin(double Rmin) {
        this.Rmin = Rmin;
    }

    public double[] getNstatesExpl() {
        return this.nstatesExpl;
    }

    public boolean getUseForwardBackwardBeam() {
        return this.UseForwardBackwardBeam;
    }

    public void setUseForwardBackwardBeam(boolean state) {
        this.UseForwardBackwardBeam = state;
    }

    private LatticeNode getLatticeNode(int ip, int stateIndex) {
        if (this.nodes[ip][stateIndex] == null) {
            this.nodes[ip][stateIndex] = new LatticeNode(ip, this.t.getState(stateIndex));
        }
        return this.nodes[ip][stateIndex];
    }

    public SumLatticeBeam(Transducer t, Sequence input, Sequence output, Transducer.Incrementor incrementor) {
        this(t, input, output, incrementor, false, null);
    }

    public SumLatticeBeam(Transducer t, Sequence input, Sequence output, Transducer.Incrementor incrementor, boolean saveXis) {
        this(t, input, output, incrementor, saveXis, null);
    }

    public SumLatticeBeam(Transducer t, Sequence input, Sequence output, Transducer.Incrementor incrementor, boolean saveXis, LabelAlphabet outputAlphabet) {
        this.t = t;
        this.input = input;
        this.output = output;
        this.latticeLength = input.size() + 1;
        int numStates = t.numStates();
        this.nodes = new LatticeNode[this.latticeLength][numStates];
        this.gammas = new double[this.latticeLength][numStates];
        if (saveXis) {
            this.xis = new double[this.latticeLength][numStates][numStates];
        }
        double[][] outputCounts = null;
        if (outputAlphabet != null) {
            outputCounts = new double[this.latticeLength][outputAlphabet.size()];
        }
        int i = 0;
        while (i < numStates) {
            int ip = 0;
            while (ip < this.latticeLength) {
                this.gammas[ip][i] = Double.NEGATIVE_INFINITY;
                ++ip;
            }
            if (saveXis) {
                int j = 0;
                while (j < numStates) {
                    int ip2 = 0;
                    while (ip2 < this.latticeLength) {
                        this.xis[ip2][i][j] = Double.NEGATIVE_INFINITY;
                        ++ip2;
                    }
                    ++j;
                }
            }
            ++i;
        }
        logger.fine("Starting Foward pass");
        boolean atLeastOneInitialState = false;
        int i2 = 0;
        while (i2 < numStates) {
            double initialWeight = t.getState(i2).getInitialWeight();
            if (initialWeight < Double.NEGATIVE_INFINITY) {
                this.getLatticeNode((int)0, (int)i2).alpha = initialWeight;
                atLeastOneInitialState = true;
            }
            ++i2;
        }
        if (!atLeastOneInitialState) {
            logger.warning("There are no starting states!");
        }
        NBestSlist[] slists = new NBestSlist[this.latticeLength];
        this.nstatesExpl = new double[this.latticeLength];
        this.curBeamWidth = this.curIter == 0 ? numStates : (this.tctIter > 1 && this.curIter != 0 ? beamWidth : beamWidth);
        int ip = 0;
        while (ip < this.latticeLength - 1) {
            slists[ip] = new NBestSlist(numStates);
            slists[ip].setKLMinE(this.curBeamWidth);
            slists[ip].setKLeps(this.KLeps);
            slists[ip].setRmin(this.Rmin);
            int i3 = 0;
            while (i3 < numStates) {
                if (this.nodes[ip][i3] != null && this.nodes[ip][i3].alpha != Double.NEGATIVE_INFINITY) {
                    NBForBackNode cnode = new NBForBackNode(this.nodes[ip][i3].alpha, i3);
                    slists[ip].push(cnode);
                }
                ++i3;
            }
            int KLMaxPos = 1;
            int RminPos = 1;
            if (this.KLeps > 0.0) {
                KLMaxPos = slists[ip].getKLpos();
                this.nstatesExpl[ip] = KLMaxPos;
            } else if (this.KLeps == 0.0) {
                if (this.Rmin > 0.0) {
                    RminPos = slists[ip].getTHRpos();
                } else {
                    slists[ip].setRmin(-this.Rmin);
                    RminPos = slists[ip].getTHRposSTRAWMAN();
                }
                this.nstatesExpl[ip] = RminPos;
            } else {
                slists[ip].setKLeps(-this.KLeps);
                KLMaxPos = slists[ip].getKLpos();
                if (this.Rmin > 0.0) {
                    RminPos = slists[ip].getTHRpos();
                } else {
                    slists[ip].setRmin(-this.Rmin);
                    RminPos = slists[ip].getTHRposSTRAWMAN();
                }
                this.nstatesExpl[ip] = KLMaxPos > RminPos ? (double)KLMaxPos : (double)RminPos;
            }
            int i4 = (int)this.nstatesExpl[ip] + 1;
            while (i4 < slists[ip].size()) {
                int tmppos = slists[ip].getPosByIndex(i4);
                this.nodes[ip][tmppos].alpha = Double.NEGATIVE_INFINITY;
                this.nodes[ip][tmppos] = null;
                ++i4;
            }
            int jj = 0;
            while ((double)jj < this.nstatesExpl[ip]) {
                int i5 = slists[ip].getPosByIndex(jj);
                Transducer.State s = t.getState(i5);
                Transducer.TransitionIterator iter = s.transitionIterator(input, ip, output, ip);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" Starting Foward transition iteration from state " + s.getName() + " on input " + input.get(ip).toString() + " and output " + (output == null ? "(null)" : output.get(ip).toString()));
                }
                while (iter.hasNext()) {
                    Transducer.State destination = iter.nextState();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Forward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                    }
                    LatticeNode destinationNode = this.getLatticeNode(ip + 1, destination.getIndex());
                    destinationNode.output = iter.getOutput();
                    double transitionWeight = iter.getWeight();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("transitionWeight=" + transitionWeight + " nodes[" + ip + "][" + i5 + "].alpha=" + this.nodes[ip][i5].alpha + " destinationNode.alpha=" + destinationNode.alpha);
                    }
                    destinationNode.alpha = Transducer.sumLogProb(destinationNode.alpha, this.nodes[ip][i5].alpha + transitionWeight);
                }
                ++jj;
            }
            ++ip;
        }
        this.curAvgNstatesExpl = MatrixOps.mean(this.nstatesExpl);
        this.weight = Double.NEGATIVE_INFINITY;
        int i6 = 0;
        while (i6 < numStates) {
            if (this.nodes[this.latticeLength - 1][i6] != null) {
                this.weight = Transducer.sumLogProb(this.weight, this.nodes[this.latticeLength - 1][i6].alpha + t.getState(i6).getFinalWeight());
            }
            ++i6;
        }
        if (this.weight == Double.NEGATIVE_INFINITY) {
            return;
        }
        i6 = 0;
        while (i6 < numStates) {
            if (this.nodes[this.latticeLength - 1][i6] != null) {
                Transducer.State s = t.getState(i6);
                this.nodes[this.latticeLength - 1][i6].beta = s.getFinalWeight();
                this.gammas[this.latticeLength - 1][i6] = this.nodes[this.latticeLength - 1][i6].alpha + this.nodes[this.latticeLength - 1][i6].beta - this.weight;
                if (incrementor != null) {
                    double p = Math.exp(this.gammas[this.latticeLength - 1][i6]);
                    assert (p > Double.NEGATIVE_INFINITY && !Double.isNaN(p)) : "p=" + p + " gamma=" + this.gammas[this.latticeLength - 1][i6];
                    incrementor.incrementFinalState(s, p);
                }
            }
            ++i6;
        }
        ip = this.latticeLength - 2;
        while (ip >= 0) {
            int i7 = 0;
            while (i7 < numStates) {
                if (this.nodes[ip][i7] != null && this.nodes[ip][i7].alpha != Double.NEGATIVE_INFINITY) {
                    Transducer.State s = t.getState(i7);
                    Transducer.TransitionIterator iter = s.transitionIterator(input, ip, output, ip);
                    while (iter.hasNext()) {
                        int j;
                        LatticeNode destinationNode;
                        Transducer.State destination = iter.nextState();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Backward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                        }
                        if ((destinationNode = this.nodes[ip + 1][j = destination.getIndex()]) == null) continue;
                        double transitionWeight = iter.getWeight();
                        assert (!Double.isNaN(transitionWeight));
                        double oldBeta = this.nodes[ip][i7].beta;
                        assert (!Double.isNaN(this.nodes[ip][i7].beta));
                        this.nodes[ip][i7].beta = Transducer.sumLogProb(this.nodes[ip][i7].beta, destinationNode.beta + transitionWeight);
                        assert (!Double.isNaN(this.nodes[ip][i7].beta)) : "dest.beta=" + destinationNode.beta + " trans=" + transitionWeight + " sum=" + (destinationNode.beta + transitionWeight) + " oldBeta=" + oldBeta;
                        double xi = this.nodes[ip][i7].alpha + transitionWeight + this.nodes[ip + 1][j].beta - this.weight;
                        if (saveXis) {
                            this.xis[ip][i7][j] = xi;
                        }
                        assert (!Double.isNaN(this.nodes[ip][i7].alpha));
                        assert (!Double.isNaN(transitionWeight));
                        assert (!Double.isNaN(this.nodes[ip + 1][j].beta));
                        assert (!Double.isNaN(this.weight));
                        if (incrementor == null && outputAlphabet == null) continue;
                        double p = Math.exp(xi);
                        assert (p > Double.NEGATIVE_INFINITY && !Double.isNaN(p)) : "xis[" + ip + "][" + i7 + "][" + j + "]=" + xi;
                        if (incrementor != null) {
                            incrementor.incrementTransition(iter, p);
                        }
                        if (outputAlphabet == null) continue;
                        int outputIndex = outputAlphabet.lookupIndex(iter.getOutput(), false);
                        assert (outputIndex >= 0);
                        double[] dArray = outputCounts[ip];
                        int n = outputIndex;
                        dArray[n] = dArray[n] + p;
                    }
                    this.gammas[ip][i7] = this.nodes[ip][i7].alpha + this.nodes[ip][i7].beta - this.weight;
                }
                ++i7;
            }
            double checknorm = Double.NEGATIVE_INFINITY;
            int i8 = 0;
            while (i8 < numStates) {
                if (this.nodes[ip][i8] != null) {
                    checknorm = Transducer.sumLogProb(checknorm, this.gammas[ip][i8]);
                }
                ++i8;
            }
            i8 = 0;
            while (i8 < numStates) {
                if (this.nodes[ip][i8] != null) {
                    this.gammas[ip][i8] = this.gammas[ip][i8] - checknorm;
                }
                ++i8;
            }
            --ip;
        }
        if (incrementor != null) {
            i6 = 0;
            while (i6 < numStates) {
                double p = Math.exp(this.gammas[0][i6]);
                assert (p > Double.NEGATIVE_INFINITY && !Double.isNaN(p));
                incrementor.incrementInitialState(t.getState(i6), p);
                ++i6;
            }
        }
        if (outputAlphabet != null) {
            this.labelings = new LabelVector[this.latticeLength];
            ip = this.latticeLength - 2;
            while (ip >= 0) {
                assert (Math.abs(1.0 - MatrixOps.sum(outputCounts[ip])) < 1.0E-6);
                this.labelings[ip] = new LabelVector(outputAlphabet, outputCounts[ip]);
                --ip;
            }
        }
    }

    @Override
    public Sequence getInput() {
        return this.input;
    }

    SumLatticeBeam(Transducer t, Sequence inputSequence, Sequence outputSequence, Segment requiredSegment, Sequence constrainedSequence) {
        this(t, inputSequence, outputSequence, null, null, SumLatticeBeam.makeConstraints(t, inputSequence, outputSequence, requiredSegment, constrainedSequence));
    }

    private static int[] makeConstraints(Transducer t, Sequence inputSequence, Sequence outputSequence, Segment requiredSegment, Sequence constrainedSequence) {
        if (constrainedSequence.size() != inputSequence.size()) {
            throw new IllegalArgumentException("constrainedSequence.size [" + constrainedSequence.size() + "] != inputSequence.size [" + inputSequence.size() + "]");
        }
        int[] constraints = new int[constrainedSequence.size() + 1];
        int c = 0;
        while (c < constraints.length) {
            constraints[c] = 0;
            ++c;
        }
        int i = requiredSegment.getStart();
        while (i <= requiredSegment.getEnd()) {
            int si = t.stateIndexOfString((String)constrainedSequence.get(i));
            if (si == -1) {
                logger.warning("Could not find state " + constrainedSequence.get(i) + ". Check that state labels match startTages and inTags, and that all labels are seen in training data.");
            }
            constraints[i + 1] = si + 1;
            ++i;
        }
        if (requiredSegment.getEnd() + 2 < constraints.length) {
            String endTag = requiredSegment.getInTag().toString();
            int statei = t.stateIndexOfString(endTag);
            if (statei == -1) {
                throw new IllegalArgumentException("Could not find state " + endTag + ". Check that state labels match startTags and InTags.");
            }
            constraints[requiredSegment.getEnd() + 2] = -(statei + 1);
        }
        logger.fine("Segment:\n" + requiredSegment.sequenceToString() + "\nconstrainedSequence:\n" + constrainedSequence + "\nConstraints:\n");
        i = 0;
        while (i < constraints.length) {
            logger.fine(String.valueOf(constraints[i]) + "\t");
            ++i;
        }
        logger.fine("");
        return constraints;
    }

    /*
     * Unable to fully structure code
     */
    public SumLatticeBeam(Transducer t, Sequence input, Sequence output, Transducer.Incrementor incrementor, LabelAlphabet outputAlphabet, int[] constraints) {
        super();
        this.t = t;
        this.input = input;
        this.output = output;
        this.latticeLength = input.size() + 1;
        numStates = t.numStates();
        this.nodes = new LatticeNode[this.latticeLength][numStates];
        this.gammas = new double[this.latticeLength][numStates];
        outputCounts = null;
        if (outputAlphabet != null) {
            outputCounts = new double[this.latticeLength][outputAlphabet.size()];
        }
        i = 0;
        while (i < numStates) {
            ip = 0;
            while (ip < this.latticeLength) {
                this.gammas[ip][i] = -Infinity;
                ++ip;
            }
            ++i;
        }
        SumLatticeBeam.logger.fine("Starting Constrained Foward pass");
        atLeastOneInitialState = false;
        i = 0;
        while (i < numStates) {
            initialWeight = t.getState(i).getInitialWeight();
            if (initialWeight > -Infinity) {
                this.getLatticeNode((int)0, (int)i).alpha = initialWeight;
                atLeastOneInitialState = true;
            }
            ++i;
        }
        if (!atLeastOneInitialState) {
            SumLatticeBeam.logger.warning("There are no starting states!");
        }
        ip = 0;
        while (ip < this.latticeLength - 1) {
            i = 0;
            while (i < numStates) {
                block51: {
                    block50: {
                        SumLatticeBeam.logger.fine("ip=" + ip + ", i=" + i);
                        if (constraints[ip] <= 0) break block50;
                        if (constraints[ip] - 1 == i) ** GOTO lbl-1000
                        SumLatticeBeam.logger.fine("Current state does not match positive constraint. position=" + ip + ", constraint=" + (constraints[ip] - 1) + ", currState=" + i);
                        break block51;
                    }
                    if (constraints[ip] < 0 && constraints[ip] + 1 == -i) {
                        SumLatticeBeam.logger.fine("Current state does not match negative constraint. position=" + ip + ", constraint=" + (constraints[ip] + 1) + ", currState=" + i);
                    } else if (this.nodes[ip][i] == null || this.nodes[ip][i].alpha == -Infinity) {
                        if (this.nodes[ip][i] == null) {
                            SumLatticeBeam.logger.fine("nodes[ip][i] is NULL");
                        } else if (this.nodes[ip][i].alpha == -Infinity) {
                            SumLatticeBeam.logger.fine("nodes[ip][i].alpha is Inf");
                        }
                        SumLatticeBeam.logger.fine("-INFINITE weight or NULL...skipping");
                    } else {
                        s = t.getState(i);
                        iter = s.transitionIterator(input, ip, output, ip);
                        if (SumLatticeBeam.logger.isLoggable(Level.FINE)) {
                            SumLatticeBeam.logger.fine(" Starting Forward transition iteration from state " + s.getName() + " on input " + input.get(ip).toString() + " and output " + (output == null ? "(null)" : output.get(ip).toString()));
                        }
                        while (iter.hasNext()) {
                            destination = iter.nextState();
                            legalTransition = true;
                            if (ip + 1 < constraints.length && constraints[ip + 1] > 0 && constraints[ip + 1] - 1 != destination.getIndex()) {
                                SumLatticeBeam.logger.fine("Destination state does not match positive constraint. Assigning -infinite weight. position=" + (ip + 1) + ", constraint=" + (constraints[ip + 1] - 1) + ", source =" + i + ", destination=" + destination.getIndex());
                                legalTransition = false;
                            } else if (ip + 1 < constraints.length && constraints[ip + 1] < 0 && -(constraints[ip + 1] + 1) == destination.getIndex()) {
                                SumLatticeBeam.logger.fine("Destination state does not match negative constraint. Assigning -infinite weight. position=" + (ip + 1) + ", constraint=" + (constraints[ip + 1] + 1) + ", destination=" + destination.getIndex());
                                legalTransition = false;
                            }
                            if (SumLatticeBeam.logger.isLoggable(Level.FINE)) {
                                SumLatticeBeam.logger.fine("Forward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                            }
                            destinationNode = this.getLatticeNode(ip + 1, destination.getIndex());
                            destinationNode.output = iter.getOutput();
                            transitionWeight = iter.getWeight();
                            if (legalTransition) {
                                SumLatticeBeam.logger.fine("transitionWeight=" + transitionWeight + " nodes[" + ip + "][" + i + "].alpha=" + this.nodes[ip][i].alpha + " destinationNode.alpha=" + destinationNode.alpha);
                                destinationNode.alpha = Transducer.sumLogProb(destinationNode.alpha, this.nodes[ip][i].alpha + transitionWeight);
                                SumLatticeBeam.logger.fine("Set alpha of latticeNode at ip = " + (ip + 1) + " stateIndex = " + destination.getIndex() + ", destinationNode.alpha = " + destinationNode.alpha);
                                continue;
                            }
                            SumLatticeBeam.logger.fine("Illegal transition from state " + i + " to state " + destination.getIndex() + ". Setting alpha to Inf");
                        }
                    }
                }
                ++i;
            }
            ++ip;
        }
        this.weight = -Infinity;
        i = 0;
        while (i < numStates) {
            if (!(this.nodes[this.latticeLength - 1][i] == null || constraints[this.latticeLength - 1] > 0 && i != constraints[this.latticeLength - 1] - 1 || constraints[this.latticeLength - 1] < 0 && -i == constraints[this.latticeLength - 1] + 1)) {
                SumLatticeBeam.logger.fine("Summing final lattice weight. state=" + i + ", alpha=" + this.nodes[this.latticeLength - 1][i].alpha + ", final weight = " + t.getState(i).getFinalWeight());
                this.weight = Transducer.sumLogProb(this.weight, this.nodes[this.latticeLength - 1][i].alpha + t.getState(i).getFinalWeight());
            }
            ++i;
        }
        if (this.weight == -Infinity) {
            return;
        }
        i = 0;
        while (i < numStates) {
            if (this.nodes[this.latticeLength - 1][i] != null) {
                s = t.getState(i);
                this.nodes[this.latticeLength - 1][i].beta = s.getFinalWeight();
                this.gammas[this.latticeLength - 1][i] = this.nodes[this.latticeLength - 1][i].alpha + this.nodes[this.latticeLength - 1][i].beta - this.weight;
                if (incrementor != null) {
                    p = Math.exp(this.gammas[this.latticeLength - 1][i]);
                    if (!(SumLatticeBeam.$assertionsDisabled || p >= 0.0 && p <= 1.0 && !Double.isNaN(p))) {
                        throw new AssertionError((Object)("p=" + p + " gamma=" + this.gammas[this.latticeLength - 1][i]));
                    }
                    incrementor.incrementFinalState(s, p);
                }
            }
            ++i;
        }
        ip = this.latticeLength - 2;
        while (ip >= 0) {
            i = 0;
            while (i < numStates) {
                if (this.nodes[ip][i] != null && this.nodes[ip][i].alpha != -Infinity) {
                    s = t.getState(i);
                    iter = s.transitionIterator(input, ip, output, ip);
                    while (iter.hasNext()) {
                        destination = iter.nextState();
                        if (SumLatticeBeam.logger.isLoggable(Level.FINE)) {
                            SumLatticeBeam.logger.fine("Backward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                        }
                        if ((destinationNode = this.nodes[ip + 1][j = destination.getIndex()]) == null) continue;
                        transitionWeight = iter.getWeight();
                        if (!SumLatticeBeam.$assertionsDisabled && Double.isNaN(transitionWeight)) {
                            throw new AssertionError();
                        }
                        oldBeta = this.nodes[ip][i].beta;
                        if (!SumLatticeBeam.$assertionsDisabled && Double.isNaN(this.nodes[ip][i].beta)) {
                            throw new AssertionError();
                        }
                        this.nodes[ip][i].beta = Transducer.sumLogProb(this.nodes[ip][i].beta, destinationNode.beta + transitionWeight);
                        if (!SumLatticeBeam.$assertionsDisabled && Double.isNaN(this.nodes[ip][i].beta)) {
                            throw new AssertionError((Object)("dest.beta=" + destinationNode.beta + " trans=" + transitionWeight + " sum=" + (destinationNode.beta + transitionWeight) + " oldBeta=" + oldBeta));
                        }
                        if (!SumLatticeBeam.$assertionsDisabled && Double.isNaN(this.nodes[ip][i].alpha)) {
                            throw new AssertionError();
                        }
                        if (!SumLatticeBeam.$assertionsDisabled && Double.isNaN(transitionWeight)) {
                            throw new AssertionError();
                        }
                        if (!SumLatticeBeam.$assertionsDisabled && Double.isNaN(this.nodes[ip + 1][j].beta)) {
                            throw new AssertionError();
                        }
                        if (!SumLatticeBeam.$assertionsDisabled && Double.isNaN(this.weight)) {
                            throw new AssertionError();
                        }
                        if (incrementor == null && outputAlphabet == null) continue;
                        xi = this.nodes[ip][i].alpha + transitionWeight + this.nodes[ip + 1][j].beta - this.weight;
                        p = Math.exp(xi);
                        if (!(SumLatticeBeam.$assertionsDisabled || p >= 0.0 && p <= 1.0 && !Double.isNaN(p))) {
                            throw new AssertionError((Object)("xis[" + ip + "][" + i + "][" + j + "]=" + -xi));
                        }
                        if (incrementor != null) {
                            incrementor.incrementTransition(iter, p);
                        }
                        if (outputAlphabet == null) continue;
                        outputIndex = outputAlphabet.lookupIndex(iter.getOutput(), false);
                        if (!SumLatticeBeam.$assertionsDisabled && outputIndex < 0) {
                            throw new AssertionError();
                        }
                        v0 = outputCounts[ip];
                        v1 = outputIndex;
                        v0[v1] = v0[v1] + p;
                    }
                    this.gammas[ip][i] = this.nodes[ip][i].alpha + this.nodes[ip][i].beta - this.weight;
                }
                ++i;
            }
            --ip;
        }
        if (incrementor != null) {
            i = 0;
            while (i < numStates) {
                p = Math.exp(this.gammas[0][i]);
                if (!(SumLatticeBeam.$assertionsDisabled || p >= 0.0 && p <= 1.0 && !Double.isNaN(p))) {
                    throw new AssertionError();
                }
                incrementor.incrementInitialState(t.getState(i), p);
                ++i;
            }
        }
        if (outputAlphabet != null) {
            this.labelings = new LabelVector[this.latticeLength];
            ip = this.latticeLength - 2;
            while (ip >= 0) {
                if (!SumLatticeBeam.$assertionsDisabled && !(Math.abs(1.0 - MatrixOps.sum(outputCounts[ip])) < 1.0E-6)) {
                    throw new AssertionError();
                }
                this.labelings[ip] = new LabelVector(outputAlphabet, outputCounts[ip]);
                --ip;
            }
        }
    }

    @Override
    public double getTotalWeight() {
        assert (!Double.isNaN(this.weight));
        return this.weight;
    }

    @Override
    public double getGammaWeight(int inputPosition, Transducer.State s) {
        return this.gammas[inputPosition][s.getIndex()];
    }

    @Override
    public double getGammaProbability(int inputPosition, Transducer.State s) {
        return Math.exp(this.gammas[inputPosition][s.getIndex()]);
    }

    @Override
    public double[][][] getXis() {
        return this.xis;
    }

    @Override
    public double[][] getGammas() {
        return this.gammas;
    }

    @Override
    public double getXiProbability(int ip, Transducer.State s1, Transducer.State s2) {
        if (this.xis == null) {
            throw new IllegalStateException("xis were not saved.");
        }
        int i = s1.getIndex();
        int j = s2.getIndex();
        return Math.exp(this.xis[ip][i][j]);
    }

    @Override
    public double getXiWeight(int ip, Transducer.State s1, Transducer.State s2) {
        if (this.xis == null) {
            throw new IllegalStateException("xis were not saved.");
        }
        int i = s1.getIndex();
        int j = s2.getIndex();
        return this.xis[ip][i][j];
    }

    @Override
    public int length() {
        return this.latticeLength;
    }

    @Override
    public double getAlpha(int ip, Transducer.State s) {
        LatticeNode node = this.getLatticeNode(ip, s.getIndex());
        return node.alpha;
    }

    @Override
    public double getBeta(int ip, Transducer.State s) {
        LatticeNode node = this.getLatticeNode(ip, s.getIndex());
        return node.beta;
    }

    @Override
    public LabelVector getLabelingAtPosition(int outputPosition) {
        if (this.labelings != null) {
            return this.labelings[outputPosition];
        }
        return null;
    }

    @Override
    public Transducer getTransducer() {
        return this.t;
    }

    public static class Factory
    extends SumLatticeFactory {
        int bw;

        public Factory(int beamWidth) {
            this.bw = beamWidth;
        }

        @Override
        public SumLattice newSumLattice(Transducer trans, Sequence input, Sequence output, Transducer.Incrementor incrementor, boolean saveXis, LabelAlphabet outputAlphabet) {
            return new SumLatticeBeam(trans, input, output, incrementor, saveXis, outputAlphabet){
                {
                    beamWidth = Factory.this.bw;
                }
            };
        }
    }

    private class LatticeNode {
        int inputPosition;
        Transducer.State state;
        Object output;
        double alpha = Double.NEGATIVE_INFINITY;
        double beta = Double.NEGATIVE_INFINITY;

        LatticeNode(int inputPosition, Transducer.State state) {
            this.inputPosition = inputPosition;
            this.state = state;
            assert (this.alpha == Double.NEGATIVE_INFINITY);
        }
    }

    private class NBForBackNode {
        double weight;
        int pos;

        NBForBackNode(double weight, int pos) {
            this.weight = weight;
            this.pos = pos;
        }
    }

    private class NBestSlist {
        ArrayList list = new ArrayList();
        int MaxElements;
        int KLMinElements;
        int KLMaxPos;
        double KLeps;
        double Rmin;

        NBestSlist(int MaxElements) {
            this.MaxElements = MaxElements;
        }

        boolean setKLMinE(int KLMinElements) {
            this.KLMinElements = KLMinElements;
            return true;
        }

        int size() {
            return this.list.size();
        }

        boolean empty() {
            return this.list.isEmpty();
        }

        Object pop() {
            return this.list.remove(0);
        }

        int getPosByIndex(int ii) {
            NBForBackNode tn = (NBForBackNode)this.list.get(ii);
            return tn.pos;
        }

        double getWeightByIndex(int ii) {
            NBForBackNode tn = (NBForBackNode)this.list.get(ii);
            return tn.weight;
        }

        void setKLeps(double KLeps) {
            this.KLeps = KLeps;
        }

        void setRmin(double Rmin) {
            this.Rmin = Rmin;
        }

        int getTHRpos() {
            NBForBackNode tn = (NBForBackNode)this.list.get(0);
            double lc1 = tn.weight;
            tn = (NBForBackNode)this.list.get(this.list.size() - 1);
            double lc2 = tn.weight;
            double minc = lc1 - lc2;
            double mincTHR = minc - minc * this.Rmin;
            int i = 1;
            while (i < this.list.size()) {
                tn = (NBForBackNode)this.list.get(i);
                lc1 = tn.weight - lc2;
                if (lc1 > mincTHR) {
                    return i + 1;
                }
                ++i;
            }
            return this.list.size();
        }

        int getTHRposSTRAWMAN() {
            NBForBackNode tn = (NBForBackNode)this.list.get(0);
            double lc1 = tn.weight;
            double mincTHR = -lc1 * this.Rmin;
            int i = 1;
            while (i < this.list.size()) {
                tn = (NBForBackNode)this.list.get(i);
                lc1 = -tn.weight;
                if (lc1 < mincTHR) {
                    return i + 1;
                }
                ++i;
            }
            return this.list.size();
        }

        int getKLpos() {
            double[] CSNLP = new double[this.MaxElements];
            NBForBackNode tn = (NBForBackNode)this.list.get(this.list.size() - 1);
            double worstc = tn.weight;
            int i = 0;
            while (i < this.list.size()) {
                tn = (NBForBackNode)this.list.get(i);
                double lc = tn.weight;
                CSNLP[i] = i == 0 ? lc : Transducer.sumLogProb(CSNLP[i - 1], lc);
                ++i;
            }
            i = 0;
            while (i < this.list.size()) {
                CSNLP[i] = CSNLP[i] - CSNLP[this.list.size() - 1];
                if (CSNLP[i] < this.KLeps) {
                    this.KLMaxPos = i + 1;
                    if (this.KLMaxPos >= this.KLMinElements) {
                        return this.KLMaxPos;
                    }
                    if (this.list.size() >= this.KLMinElements) {
                        return this.KLMinElements;
                    }
                }
                ++i;
            }
            this.KLMaxPos = this.list.size();
            return this.KLMaxPos;
        }

        ArrayList push(NBForBackNode vn) {
            double tc = vn.weight;
            boolean atEnd = true;
            int i = 0;
            while (i < this.list.size()) {
                NBForBackNode tn = (NBForBackNode)this.list.get(i);
                double lc = tn.weight;
                if (tc < lc) {
                    this.list.add(i, vn);
                    atEnd = false;
                    break;
                }
                ++i;
            }
            if (atEnd) {
                this.list.add(vn);
            }
            if (this.list.size() > this.MaxElements) {
                this.list.remove(this.MaxElements);
            }
            return this.list;
        }
    }
}

