/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised;

import cc.mallet.types.InstanceList;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;

public class FSTConstraintUtil {
    public static HashMap<Integer, double[][]> loadGEConstraints(Reader fileReader, InstanceList data) {
        HashMap<Integer, double[][]> constraints = new HashMap<Integer, double[][]>();
        int li = 0;
        while (li < data.getTargetAlphabet().size()) {
            System.err.println(data.getTargetAlphabet().lookupObject(li));
            ++li;
        }
        try {
            BufferedReader reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            while (line != null) {
                String[] split = line.split("\\s+");
                String featureName = split[0];
                int featureIndex = data.getDataAlphabet().lookupIndex(featureName, false);
                if (featureIndex == -1) {
                    throw new RuntimeException("Feature " + featureName + " not found in the alphabet!");
                }
                double[][] probs = new double[data.getTargetAlphabet().size()][2];
                int i = 0;
                while (i < probs.length) {
                    Arrays.fill(probs[i], Double.NEGATIVE_INFINITY);
                    ++i;
                }
                int index = 1;
                while (index < split.length) {
                    String[] labelSplit = split[index].split(":");
                    int li2 = data.getTargetAlphabet().lookupIndex(labelSplit[0], false);
                    assert (li2 != -1) : labelSplit[0];
                    if (labelSplit[1].contains(",")) {
                        String[] rangeSplit = labelSplit[1].split(",");
                        double lower = Double.parseDouble(rangeSplit[0]);
                        double upper = Double.parseDouble(rangeSplit[1]);
                        probs[li2][0] = lower;
                        probs[li2][1] = upper;
                    } else {
                        double prob;
                        probs[li2][0] = prob = Double.parseDouble(labelSplit[1]);
                        probs[li2][1] = prob;
                    }
                    ++index;
                }
                constraints.put(featureIndex, probs);
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return constraints;
    }
}

