/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.constraints;

import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.fst.semi_supervised.constraints.OneLabelGEConstraints;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.Maths;
import gnu.trove.TIntObjectHashMap;

public class OneLabelKLGEConstraints
extends OneLabelGEConstraints {
    public OneLabelKLGEConstraints() {
    }

    private OneLabelKLGEConstraints(TIntObjectHashMap<OneLabelGEConstraints.OneLabelGEConstraint> constraints, StateLabelMap map) {
        super(constraints, map);
    }

    @Override
    public GEConstraint copy() {
        return new OneLabelKLGEConstraints(this.constraints, this.map);
    }

    @Override
    public void addConstraint(int fi, double[] target, double weight) {
        assert (Maths.almostEquals(MatrixOps.sum(target), 1.0));
        this.constraints.put(fi, new OneLabelGEKLConstraint(target, weight));
    }

    @Override
    public double getValue() {
        double value = 0.0;
        int[] nArray = this.constraints.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fi = nArray[n2];
            OneLabelGEConstraints.OneLabelGEConstraint constraint = (OneLabelGEConstraints.OneLabelGEConstraint)this.constraints.get(fi);
            if (constraint.count > 0.0) {
                double constraintValue = 0.0;
                int labelIndex = 0;
                while (labelIndex < this.map.getNumLabels()) {
                    if (constraint.target[labelIndex] > 0.0) {
                        if (constraint.expectation[labelIndex] == 0.0) {
                            return Double.NEGATIVE_INFINITY;
                        }
                        constraintValue += constraint.target[labelIndex] * (Math.log(constraint.expectation[labelIndex] / constraint.count) - Math.log(constraint.target[labelIndex]));
                    }
                    ++labelIndex;
                }
                assert (!Double.isNaN(constraintValue) && !Double.isInfinite(constraintValue));
                value += constraintValue * constraint.weight;
            }
            ++n2;
        }
        return value;
    }

    protected class OneLabelGEKLConstraint
    extends OneLabelGEConstraints.OneLabelGEConstraint {
        public OneLabelGEKLConstraint(double[] target, double weight) {
            super(target, weight);
        }

        @Override
        public double getValue(int li) {
            assert (this.count != 0.0);
            if (this.target[li] == 0.0 && this.expectation[li] == 0.0) {
                return 0.0;
            }
            return this.weight * (this.target[li] / this.expectation[li]);
        }
    }
}

