/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.constraints;

import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.fst.semi_supervised.constraints.TwoLabelGEConstraints;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;

public class TwoLabelL2GEConstraints
extends TwoLabelGEConstraints {
    public TwoLabelL2GEConstraints() {
    }

    private TwoLabelL2GEConstraints(ArrayList<TwoLabelGEConstraints.TwoLabelGEConstraint> constraintsList, TIntIntHashMap constraintsMap, StateLabelMap map) {
        super(constraintsList, constraintsMap, map);
    }

    @Override
    public GEConstraint copy() {
        return new TwoLabelL2GEConstraints(this.constraintsList, this.constraintsMap, this.map);
    }

    @Override
    public void addConstraint(int fi, double[][] target, double weight) {
        this.constraintsList.add(new TwoLabelL2GEConstraint(target, weight));
        this.constraintsMap.put(fi, this.constraintsList.size() - 1);
    }

    @Override
    public double getValue() {
        double value = 0.0;
        int[] nArray = this.constraintsMap.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fi = nArray[n2];
            TwoLabelGEConstraints.TwoLabelGEConstraint constraint = (TwoLabelGEConstraints.TwoLabelGEConstraint)this.constraintsList.get(this.constraintsMap.get(fi));
            if (constraint.count > 0.0) {
                double constraintValue = 0.0;
                int prevLi = 0;
                while (prevLi < this.map.getNumLabels()) {
                    int currLi = 0;
                    while (currLi < this.map.getNumLabels()) {
                        constraintValue -= Math.pow(constraint.target[prevLi][currLi] - constraint.expectation[prevLi][currLi] / constraint.count, 2.0);
                        ++currLi;
                    }
                    ++prevLi;
                }
                assert (!Double.isNaN(constraintValue) && !Double.isInfinite(constraintValue));
                value += constraintValue * constraint.weight;
            }
            ++n2;
        }
        return value;
    }

    protected class TwoLabelL2GEConstraint
    extends TwoLabelGEConstraints.TwoLabelGEConstraint {
        public TwoLabelL2GEConstraint(double[][] target, double weight) {
            super(TwoLabelL2GEConstraints.this, target, weight);
        }

        @Override
        public double getValue(int liPrev, int liCurr) {
            assert (this.count != 0.0);
            return 2.0 * this.weight * (this.target[liPrev][liCurr] / this.count - this.expectation[liPrev][liCurr] / (this.count * this.count));
        }
    }
}

