/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.examples;

import cc.mallet.grmm.inference.JunctionTreeInferencer;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.Variable;
import cc.mallet.grmm.util.ModelReader;
import cc.mallet.grmm.util.ModelWriter;
import java.io.BufferedReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;

public class ModelReaderExample {
    public static String mdlExample = "VAR var0 : 2\nVAR var1 : 2\nVAR var2 : 2\nVAR var3 : 2\n\nvar0 var1 ~ BinaryPair 1\nvar1 var2 ~ BinaryPair 1.1\nvar2 var3 ~ BinaryPair -1.3\nvar3 var0 ~ BinaryPair 0.9\nvar0 ~ Unary 1.0\nvar1 ~ Unary -0.5\nvar2 ~ Unary 0.75\nvar3 ~ Unary 0.1\n";

    public static void main(String[] args) throws Exception {
        BufferedReader r = new BufferedReader(new StringReader(mdlExample));
        FactorGraph fg = new ModelReader().readModel(r);
        fg.dump();
        JunctionTreeInferencer inf = new JunctionTreeInferencer();
        inf.computeMarginals(fg);
        int vi = 0;
        while (vi < 4) {
            Variable var = fg.getVariable(vi);
            System.out.println(inf.lookupMarginal(var).dumpToString());
            ++vi;
        }
        System.out.println("+++++++++");
        OutputStreamWriter osw = new OutputStreamWriter(System.out);
        ModelWriter.writeModel(fg, osw);
        osw.close();
    }
}

