/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.learning;

import cc.mallet.grmm.inference.AbstractBeliefPropagation;
import cc.mallet.grmm.inference.Inferencer;
import cc.mallet.grmm.inference.JunctionTreeInferencer;
import cc.mallet.grmm.inference.TRP;
import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.Factors;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.LogTableFactor;
import cc.mallet.grmm.types.UndirectedModel;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.grmm.util.LabelsAssignment;
import cc.mallet.grmm.util.Models;
import cc.mallet.optimize.Optimizable;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.HashedSparseVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelsSequence;
import cc.mallet.types.Matrix;
import cc.mallet.types.Matrixn;
import cc.mallet.types.SparseVector;
import cc.mallet.util.ArrayUtils;
import cc.mallet.util.MalletLogger;
import gnu.trove.TDoubleArrayList;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ACRF
implements Serializable {
    private static transient Logger logger = MalletLogger.getLogger(ACRF.class.getName());
    Template[] templates;
    List fixedPtls = new ArrayList(0);
    private GraphPostProcessor graphProcessor;
    Alphabet inputAlphabet;
    private Inferencer globalInferencer = new TRP();
    private Inferencer viterbi = TRP.createForMaxProduct();
    int defaultFeatureIndex;
    private Pipe inputPipe;
    private boolean cacheUnrolledGraphs = false;
    private transient Map graphCache = new THashMap();
    private double gaussianPriorVariance = 10.0;
    private static final double DEFAULT_GAUSSIAN_PRIOR_VARIANCE = 10.0;
    private boolean doSizeScale = false;
    private static final long serialVersionUID = 2865175696692468236L;
    private transient File verboseOutputDirectory = null;

    public ACRF(Pipe inputPipe, Template[] tmpls) throws IllegalArgumentException {
        this.inputPipe = inputPipe;
        this.templates = tmpls;
        this.inputAlphabet = inputPipe.getDataAlphabet();
        this.defaultFeatureIndex = this.inputAlphabet.size();
        int tidx = 0;
        while (tidx < this.templates.length) {
            this.templates[tidx].index = tidx;
            ++tidx;
        }
    }

    public Alphabet getInputAlphabet() {
        return this.inputAlphabet;
    }

    public int getDefaultFeatureIndex() {
        return this.defaultFeatureIndex;
    }

    public Inferencer getInferencer() {
        return this.globalInferencer;
    }

    public void setInferencer(Inferencer inf) {
        this.globalInferencer = inf;
    }

    public Inferencer getViterbiInferencer() {
        return this.viterbi;
    }

    public void setViterbiInferencer(Inferencer inf) {
        this.viterbi = inf;
    }

    public boolean isDoSizeScale() {
        return this.doSizeScale;
    }

    public void setDoSizeScale(boolean doSizeScale) {
        this.doSizeScale = doSizeScale;
    }

    public void setSupportedOnly(boolean b) {
        int i = 0;
        while (i < this.templates.length) {
            this.templates[i].setSupportedOnly(b);
            ++i;
        }
    }

    public boolean isCacheUnrolledGraphs() {
        return this.cacheUnrolledGraphs;
    }

    public void setCacheUnrolledGraphs(boolean cacheUnrolledGraphs) {
        this.cacheUnrolledGraphs = cacheUnrolledGraphs;
    }

    public void setFixedPotentials(Template[] fixed) {
        this.fixedPtls = Arrays.asList(fixed);
        int tidx = 0;
        while (tidx < fixed.length) {
            fixed[tidx].index = -1;
            ++tidx;
        }
    }

    public void addFixedPotentials(Template[] tmpls) {
        int i = 0;
        while (i < tmpls.length) {
            Template tmpl = tmpls[i];
            tmpl.setTrainable(false);
            this.fixedPtls.add(tmpl);
            tmpl.index = -1;
            ++i;
        }
    }

    public Template[] getTemplates() {
        return this.templates;
    }

    public Pipe getInputPipe() {
        return this.inputPipe;
    }

    public Template[] getFixedTemplates() {
        return this.fixedPtls.toArray(new Template[this.fixedPtls.size()]);
    }

    public void addFixedPotential(Template tmpl) {
        tmpl.setTrainable(false);
        this.fixedPtls.add(tmpl);
        tmpl.index = -1;
    }

    public double getGaussianPriorVariance() {
        return this.gaussianPriorVariance;
    }

    public void setGaussianPriorVariance(double gaussianPriorVariance) {
        this.gaussianPriorVariance = gaussianPriorVariance;
    }

    public void setGraphProcessor(GraphPostProcessor graphProcessor) {
        this.graphProcessor = graphProcessor;
    }

    public Optimizable.ByGradientValue getMaximizable(InstanceList ilst) {
        return new MaximizableACRF(ilst);
    }

    public List bestAssignment(InstanceList lst) {
        ArrayList<Assignment> ret = new ArrayList<Assignment>(lst.size());
        int i = 0;
        while (i < lst.size()) {
            ret.add(this.bestAssignment((Instance)lst.get(i)));
            ++i;
        }
        return ret;
    }

    public Assignment bestAssignment(Instance inst) {
        UnrolledGraph unrolled = this.unroll(inst);
        return Models.bestAssignment(unrolled, this.viterbi);
    }

    public List getBestLabels(InstanceList lst) {
        ArrayList<LabelsSequence> ret = new ArrayList<LabelsSequence>(lst.size());
        int i = 0;
        while (i < lst.size()) {
            ret.add(this.getBestLabels((Instance)lst.get(i)));
            ++i;
        }
        return ret;
    }

    public LabelsSequence getBestLabels(Instance inst) {
        Assignment assn = this.bestAssignment(inst);
        LabelsAssignment gold = (LabelsAssignment)inst.getTarget();
        return gold.toLabelsSequence(assn);
    }

    public UnrolledGraph unroll(Instance inst) {
        UnrolledGraph g;
        if (this.cacheUnrolledGraphs && this.graphCache.containsKey(inst)) {
            g = (UnrolledGraph)this.graphCache.get(inst);
            g.recomputeFactors();
        } else {
            g = new UnrolledGraph(inst, this.templates, this.fixedPtls);
            if (this.graphProcessor != null) {
                this.graphProcessor.process(g, inst);
            }
        }
        if (this.cacheUnrolledGraphs) {
            this.graphCache.put(inst, g);
        }
        return g;
    }

    public UnrolledGraph unrollStructureOnly(Instance inst) {
        UnrolledGraph g;
        if (this.cacheUnrolledGraphs && this.graphCache.containsKey(inst)) {
            g = (UnrolledGraph)this.graphCache.get(inst);
            g.recomputeFactors();
        } else {
            g = new UnrolledGraph(inst, this.templates, this.fixedPtls, false);
            if (this.graphProcessor != null) {
                this.graphProcessor.process(g, inst);
            }
        }
        if (this.cacheUnrolledGraphs) {
            this.graphCache.put(inst, g);
        }
        return g;
    }

    private void reportOnGraphCache() {
        logger.info("Number of cached graphs = " + this.graphCache.size());
    }

    public void print(OutputStream os) {
        PrintStream out = new PrintStream(os);
        out.println("ACRF. Number of templates: == " + this.templates.length);
        out.println("Weights");
        int tidx = 0;
        while (tidx < this.templates.length) {
            Template tmpl = this.templates[tidx];
            out.println("TEMPLATE " + tidx + " == " + tmpl);
            out.println("Default weights: ");
            SparseVector defaults = tmpl.getDefaultWeights();
            int loc = 0;
            while (loc < defaults.numLocations()) {
                out.println(" [" + defaults.indexAtLocation(loc) + "] = " + defaults.valueAtLocation(loc));
                ++loc;
            }
            SparseVector[] weights = tmpl.getWeights();
            int assn = 0;
            while (assn < weights.length) {
                out.println("Assignment " + assn);
                SparseVector w = weights[assn];
                int x = 0;
                while (x < w.numLocations()) {
                    int idx = w.indexAtLocation(x);
                    if (idx == this.defaultFeatureIndex) {
                        out.print("DEFAULT");
                    } else {
                        out.print(this.inputAlphabet.lookupObject(idx));
                    }
                    out.println("  " + w.valueAtLocation(x));
                    ++x;
                }
                ++assn;
            }
            ++tidx;
        }
    }

    private static void dumpValues(String title, SparseVector[][] values) {
        try {
            int cnum = 0;
            while (cnum < values.length) {
                System.out.println(String.valueOf(title) + " Clique: " + cnum);
                ACRF.writeCliqueValues(values[cnum]);
                ++cnum;
            }
        }
        catch (IOException e) {
            System.err.println("Error writing to file!");
            e.printStackTrace();
        }
    }

    private static void writeCliqueValues(SparseVector[] values) throws IOException {
        System.out.println("Num assignments = " + values.length);
        int assn = 0;
        while (assn < values.length) {
            System.out.println("Num locations = " + values[assn].numLocations());
            int j = 0;
            while (j < values[assn].numLocations()) {
                int idx = values[assn].indexAtLocation(j);
                System.out.print("sparse [" + assn + "][" + idx + "] = ");
                System.out.println(values[assn].valueAtLocation(j));
                ++j;
            }
            ++assn;
        }
    }

    private void dumpOneGraph(UnrolledGraph unrolled) {
        Assignment assn = unrolled.getAssignment();
        Iterator it = unrolled.unrolledVarSetIterator();
        while (it.hasNext()) {
            UnrolledVarSet clique = (UnrolledVarSet)it.next();
            System.out.println("Clique " + clique);
            Factor ptl = unrolled.factorOf(clique);
            if (ptl == null) continue;
            System.out.println(ptl);
        }
    }

    public void dumpUnrolledGraphs(InstanceList lst) {
        int i = 0;
        while (i < lst.size()) {
            Instance inst = (Instance)lst.get(i);
            System.out.println("INSTANCE " + i + " : " + inst.getName());
            UnrolledGraph unrolled = this.unroll(inst);
            this.dumpOneGraph(unrolled);
            ++i;
        }
    }

    public void readWeightsFromText(Reader reader) throws IOException {
        try {
            Document d = new SAXBuilder().build(reader);
            Element root = d.getRootElement();
            List tmpls = root.getChildren("TEMPLATE");
            for (Element tmplElt : tmpls) {
                String tmplName = tmplElt.getAttributeValue("NAME");
                int ti = Integer.parseInt(tmplElt.getAttributeValue("IDX"));
                Template tmpl = this.templates[ti];
                if (!tmpl.getClass().getName().equals(tmplName)) {
                    throw new RuntimeException("Expected template " + tmpl + "; got " + tmplName);
                }
                Element defWElt = tmplElt.getChild("DEFAULT_WEIGHTS");
                SparseVector defW = this.readSparseVector(defWElt.getText(), null);
                Element wVecElt = tmplElt.getChild("WEIGHTS");
                int nw = Integer.parseInt(wVecElt.getAttributeValue("SIZE"));
                SparseVector[] w = new SparseVector[nw];
                List wLst = wVecElt.getChildren("WEIGHT");
                for (Element wElt : wLst) {
                    int wi = Integer.parseInt(wElt.getAttributeValue("IDX"));
                    w[wi] = this.readSparseVector(wElt.getText(), this.getInputAlphabet());
                }
                tmpl.setDefaultWeights(defW);
                tmpl.weights = w;
            }
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
    }

    private SparseVector readSparseVector(String str, Alphabet dict) throws IOException {
        TIntArrayList idxs = new TIntArrayList();
        TDoubleArrayList vals = new TDoubleArrayList();
        String[] lines = str.split("\n");
        int li = 0;
        while (li < lines.length) {
            String line = lines[li];
            if (!Pattern.matches("^\\s*$", line)) {
                String[] fields = line.split("\t");
                int idx = dict != null ? dict.lookupIndex(fields[0]) : Integer.parseInt(fields[0]);
                double val = Double.parseDouble(fields[1]);
                idxs.add(idx);
                vals.add(val);
            }
            ++li;
        }
        return new SparseVector(idxs.toNativeArray(), vals.toNativeArray());
    }

    public void writeWeightsText(Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        out.println("<CRF>");
        int ti = 0;
        while (ti < this.templates.length) {
            Template tmpl = this.templates[ti];
            out.println("<TEMPLATE NAME=\"" + tmpl.getClass().getName() + "\" IDX=\"" + ti + "\" >");
            out.println("<DEFAULT_WEIGHTS>");
            SparseVector defW = tmpl.getDefaultWeights();
            int loc = 0;
            while (loc < defW.numLocations()) {
                out.print(defW.indexAtLocation(loc));
                out.print("\t");
                out.println(defW.valueAtLocation(loc));
                ++loc;
            }
            out.println("</DEFAULT_WEIGHTS>");
            out.println();
            SparseVector[] w = tmpl.getWeights();
            out.println("<WEIGHTS SIZE=\"" + w.length + "\">");
            int wi = 0;
            while (wi < w.length) {
                out.println("<WEIGHT IDX=\"" + wi + "\">");
                this.writeWeightVector(out, w[wi]);
                out.println();
                out.println("</WEIGHT>");
                ++wi;
            }
            out.println("</WEIGHTS>");
            out.println("</TEMPLATE>");
            ++ti;
        }
        out.println("</CRF>");
    }

    private void writeWeightVector(PrintWriter out, SparseVector sv) {
        out.println("<![CDATA[");
        Alphabet dict = this.getInputAlphabet();
        int loc = 0;
        while (loc < sv.numLocations()) {
            int idx = sv.indexAtLocation(loc);
            double val = sv.valueAtLocation(loc);
            if (idx < dict.size()) {
                out.print(dict.lookupObject(idx));
            } else {
                out.print("IDX" + idx);
            }
            out.print("\t");
            out.println(val);
            ++loc;
        }
        out.println("]]>");
    }

    public static ACRF makeFactorial(Pipe p, int numLevels) {
        ArrayList<SequenceTemplate> t = new ArrayList<SequenceTemplate>();
        int i = 0;
        while (i < numLevels) {
            t.add(new BigramTemplate(i));
            if (i + 1 < numLevels) {
                t.add(new PairwiseFactorTemplate(i, i + 1));
            }
            ++i;
        }
        Template[] tmpls = t.toArray(new Template[t.size()]);
        return new ACRF(p, tmpls);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.graphCache = new THashMap();
    }

    public void setVerboseOutputDirectory(File dir2) {
        this.verboseOutputDirectory = dir2;
    }

    public static class BigramTemplate
    extends SequenceTemplate {
        int factor;
        private static final long serialVersionUID = 8944142287103225874L;

        public BigramTemplate(int factor) {
            this.factor = factor;
        }

        @Override
        public void addInstantiatedCliques(UnrolledGraph graph, FeatureVectorSequence fvs, LabelsAssignment lblseq) {
            int i = 0;
            while (i < lblseq.maxTime() - 1) {
                Variable v1 = lblseq.varOfIndex(i, this.factor);
                Variable v2 = lblseq.varOfIndex(i + 1, this.factor);
                FeatureVector fv = fvs.getFeatureVector(i);
                Variable[] vars = new Variable[]{v1, v2};
                assert (v1 != null) : "Couldn't get label factor " + this.factor + " time " + i;
                assert (v2 != null) : "Couldn't get label factor " + this.factor + " time " + (i + 1);
                UnrolledVarSet clique = new UnrolledVarSet(graph, this, vars, fv);
                graph.addClique(clique);
                ++i;
            }
        }

        public String toString() {
            return "[BigramTemplate (" + this.factor + ")]";
        }

        public int getFactor() {
            return this.factor;
        }
    }

    public static abstract class FixedFactorTemplate
    extends Template {
        @Override
        public int initWeights(InstanceList training) {
            return 0;
        }

        @Override
        public SparseVector[] getWeights() {
            return new SparseVector[0];
        }

        @Override
        public SparseVector getDefaultWeights() {
            return new SparseVector();
        }

        @Override
        public boolean isTrainable() {
            return false;
        }

        @Override
        public void setTrainable(boolean tr) {
            if (tr) {
                throw new IllegalArgumentException("This template is never trainable.");
            }
        }

        @Override
        public abstract AbstractTableFactor computeFactor(UnrolledVarSet var1);
    }

    public static interface GraphPostProcessor
    extends Serializable {
        public void process(UnrolledGraph var1, Instance var2);
    }

    public class MaximizableACRF
    implements Optimizable.ByGradientValue,
    Serializable {
        InstanceList trainData;
        double cachedValue = -1.23456789E8;
        double[] cachedGradient;
        protected BitSet infiniteValues = null;
        boolean cachedValueStale;
        boolean cachedGradientStale;
        private int numParameters;
        private int totalNodes = 0;
        private static final boolean printGradient = false;
        private transient UnrolledGraph graph;
        protected Inferencer inferencer;
        SparseVector[][] constraints;
        SparseVector[][] expectations;
        SparseVector[] defaultConstraints;
        SparseVector[] defaultExpectations;
        private int gradCallNo;

        private void initWeights(InstanceList training) {
            int tidx = 0;
            while (tidx < ACRF.this.templates.length) {
                this.numParameters += ACRF.this.templates[tidx].initWeights(training);
                ++tidx;
            }
        }

        private void initConstraintsExpectations() {
            this.defaultConstraints = new SparseVector[ACRF.this.templates.length];
            this.defaultExpectations = new SparseVector[ACRF.this.templates.length];
            int tidx = 0;
            while (tidx < ACRF.this.templates.length) {
                SparseVector defaults = ACRF.this.templates[tidx].getDefaultWeights();
                this.defaultConstraints[tidx] = (SparseVector)defaults.cloneMatrixZeroed();
                this.defaultExpectations[tidx] = (SparseVector)defaults.cloneMatrixZeroed();
                ++tidx;
            }
            this.constraints = new SparseVector[ACRF.this.templates.length][];
            this.expectations = new SparseVector[ACRF.this.templates.length][];
            tidx = 0;
            while (tidx < ACRF.this.templates.length) {
                Template tmpl = ACRF.this.templates[tidx];
                SparseVector[] weights = tmpl.getWeights();
                this.constraints[tidx] = new SparseVector[weights.length];
                this.expectations[tidx] = new SparseVector[weights.length];
                int i = 0;
                while (i < weights.length) {
                    this.constraints[tidx][i] = (SparseVector)weights[i].cloneMatrixZeroed();
                    this.expectations[tidx][i] = (SparseVector)weights[i].cloneMatrixZeroed();
                    ++i;
                }
                ++tidx;
            }
        }

        void resetExpectations() {
            int tidx = 0;
            while (tidx < this.expectations.length) {
                this.defaultExpectations[tidx].setAll(0.0);
                int i = 0;
                while (i < this.expectations[tidx].length) {
                    this.expectations[tidx][i].setAll(0.0);
                    ++i;
                }
                ++tidx;
            }
        }

        protected MaximizableACRF(InstanceList ilist) {
            this.inferencer = ACRF.this.globalInferencer.duplicate();
            this.gradCallNo = 0;
            logger.finest("Initializing MaximizableACRF.");
            this.trainData = ilist;
            this.initWeights(this.trainData);
            this.initConstraintsExpectations();
            int numInstances = this.trainData.size();
            this.cachedGradient = new double[this.numParameters];
            this.cachedGradientStale = true;
            this.cachedValueStale = true;
            logger.info("Number of training instances = " + numInstances);
            logger.info("Number of parameters = " + this.numParameters);
            logger.info("Default feature index = " + ACRF.this.defaultFeatureIndex);
            this.describePrior();
            logger.fine("Computing constraints");
            this.collectConstraints(this.trainData);
        }

        private void describePrior() {
            logger.info("Using gaussian prior with variance " + ACRF.this.gaussianPriorVariance);
        }

        @Override
        public int getNumParameters() {
            return this.numParameters;
        }

        @Override
        public void getParameters(double[] buf) {
            Template tmpl;
            if (buf.length != this.numParameters) {
                throw new IllegalArgumentException("Argument is not of the  correct dimensions");
            }
            int idx = 0;
            int tidx = 0;
            while (tidx < ACRF.this.templates.length) {
                tmpl = ACRF.this.templates[tidx];
                SparseVector defaults = tmpl.getDefaultWeights();
                double[] values = defaults.getValues();
                System.arraycopy(values, 0, buf, idx, values.length);
                idx += values.length;
                ++tidx;
            }
            tidx = 0;
            while (tidx < ACRF.this.templates.length) {
                tmpl = ACRF.this.templates[tidx];
                SparseVector[] weights = tmpl.getWeights();
                int assn = 0;
                while (assn < weights.length) {
                    double[] values = weights[assn].getValues();
                    System.arraycopy(values, 0, buf, idx, values.length);
                    idx += values.length;
                    ++assn;
                }
                ++tidx;
            }
        }

        @Override
        public void setParameters(double[] params) {
            Template tmpl;
            if (params.length != this.numParameters) {
                throw new IllegalArgumentException("Argument is not of the  correct dimensions");
            }
            this.cachedGradientStale = true;
            this.cachedValueStale = true;
            int idx = 0;
            int tidx = 0;
            while (tidx < ACRF.this.templates.length) {
                tmpl = ACRF.this.templates[tidx];
                SparseVector defaults = tmpl.getDefaultWeights();
                double[] values = defaults.getValues();
                System.arraycopy(params, idx, values, 0, values.length);
                idx += values.length;
                ++tidx;
            }
            tidx = 0;
            while (tidx < ACRF.this.templates.length) {
                tmpl = ACRF.this.templates[tidx];
                SparseVector[] weights = tmpl.getWeights();
                int assn = 0;
                while (assn < weights.length) {
                    double[] values = weights[assn].getValues();
                    System.arraycopy(params, idx, values, 0, values.length);
                    idx += values.length;
                    ++assn;
                }
                ++tidx;
            }
        }

        public SparseVector[] getExpectations(int cnum) {
            return this.expectations[cnum];
        }

        public SparseVector[] getConstraints(int cnum) {
            return this.constraints[cnum];
        }

        private void printParameters() {
            double[] buf = new double[this.numParameters];
            this.getParameters(buf);
            int len = buf.length;
            int w = 0;
            while (w < len) {
                System.out.print(String.valueOf(buf[w]) + "\t");
                ++w;
            }
            System.out.println();
        }

        @Override
        public double getParameter(int index) {
            return 0.0;
        }

        @Override
        public void setParameter(int index, double value) {
        }

        @Override
        public double getValue() {
            if (this.cachedValueStale) {
                this.cachedValue = this.computeLogLikelihood();
                this.cachedValueStale = false;
                this.cachedGradientStale = true;
                logger.info("getValue() (loglikelihood) = " + this.cachedValue);
            }
            if (Double.isNaN(this.cachedValue)) {
                logger.warning("value is NaN");
                this.cachedValue = 0.0;
            }
            return this.cachedValue;
        }

        protected double computeLogLikelihood() {
            double retval = 0.0;
            int numInstances = this.trainData.size();
            long start = System.currentTimeMillis();
            long unrollTime = 0L;
            long marginalsTime = 0L;
            boolean initializingInfiniteValues = false;
            if (this.infiniteValues == null) {
                this.infiniteValues = new BitSet();
                initializingInfiniteValues = true;
            }
            this.resetExpectations();
            int i = 0;
            while (i < numInstances) {
                Instance instance = (Instance)this.trainData.get(i);
                long unrollStart = System.currentTimeMillis();
                UnrolledGraph unrolled = ACRF.this.unroll(instance);
                long unrollEnd = System.currentTimeMillis();
                unrollTime += unrollEnd - unrollStart;
                if (unrolled.numVariables() != 0) {
                    this.inferencer.computeMarginals(unrolled);
                    marginalsTime += System.currentTimeMillis() - unrollEnd;
                    this.collectExpectations(unrolled, this.inferencer);
                    Assignment jointAssn = unrolled.getAssignment();
                    double value = this.inferencer.lookupLogJoint(jointAssn);
                    if (Double.isInfinite(value)) {
                        if (initializingInfiniteValues) {
                            logger.warning("Instance " + instance.getName() + " has infinite value; skipping.");
                            this.infiniteValues.set(i);
                        } else if (!this.infiniteValues.get(i)) {
                            logger.warning("Infinite value on instance " + instance.getName() + "returning -infinity");
                            return Double.NEGATIVE_INFINITY;
                        }
                    } else {
                        if (Double.isNaN(value)) {
                            System.out.println("NaN on instance " + i + " : " + instance.getName());
                            this.printDebugInfo(unrolled);
                            logger.warning("Value is NaN in ACRF.getValue() Instance " + i + " : " + "returning -infinity... ");
                            return Double.NEGATIVE_INFINITY;
                        }
                        retval += value;
                    }
                }
                ++i;
            }
            if (ACRF.this.doSizeScale) {
                retval /= (double)this.trainData.size();
            }
            double priorDenom = 2.0 * ACRF.this.gaussianPriorVariance;
            int tidx = 0;
            while (tidx < ACRF.this.templates.length) {
                SparseVector[] weights = ACRF.this.templates[tidx].getWeights();
                int j = 0;
                while (j < weights.length) {
                    int fnum = 0;
                    while (fnum < weights[j].numLocations()) {
                        double w = weights[j].valueAtLocation(fnum);
                        if (this.weightValid(w, tidx, j)) {
                            retval += -w * w / priorDenom;
                        }
                        ++fnum;
                    }
                    ++j;
                }
                ++tidx;
            }
            if (ACRF.this.cacheUnrolledGraphs) {
                ACRF.this.reportOnGraphCache();
            }
            long end = System.currentTimeMillis();
            logger.info("ACRF Inference time (ms) = " + (end - start));
            logger.info("ACRF marginals time (ms) = " + marginalsTime);
            logger.info("ACRF unroll time (ms) = " + unrollTime);
            logger.info("getValue (loglikelihood) = " + retval);
            return retval;
        }

        @Override
        public void getValueGradient(double[] buf) {
            if (this.cachedGradientStale) {
                if (this.cachedValueStale) {
                    this.getValue();
                }
                this.computeGradient();
                this.cachedGradientStale = false;
            }
            if (buf.length != this.numParameters) {
                throw new IllegalArgumentException("Incorrect length buffer to getValueGradient(). Expected " + this.numParameters + ", received " + buf.length);
            }
            System.arraycopy(this.cachedGradient, 0, buf, 0, this.cachedGradient.length);
        }

        private void computeGradient() {
            int gidx = 0;
            int tidx = 0;
            while (tidx < ACRF.this.templates.length) {
                SparseVector theseWeights = ACRF.this.templates[tidx].getDefaultWeights();
                SparseVector theseConstraints = this.defaultConstraints[tidx];
                SparseVector theseExpectations = this.defaultExpectations[tidx];
                int j = 0;
                while (j < theseWeights.numLocations()) {
                    double weight = theseWeights.valueAtLocation(j);
                    double constraint = theseConstraints.valueAtLocation(j);
                    double expectation = theseExpectations.valueAtLocation(j);
                    double scale = ACRF.this.doSizeScale ? 1.0 / (double)this.trainData.size() : 1.0;
                    this.cachedGradient[gidx++] = scale * (constraint - expectation) - weight / ACRF.this.gaussianPriorVariance;
                    ++j;
                }
                ++tidx;
            }
            tidx = 0;
            while (tidx < ACRF.this.templates.length) {
                Template tmpl = ACRF.this.templates[tidx];
                SparseVector[] weights = tmpl.getWeights();
                int i = 0;
                while (i < weights.length) {
                    SparseVector thisWeightVec = weights[i];
                    SparseVector thisConstraintVec = this.constraints[tidx][i];
                    SparseVector thisExpectationVec = this.expectations[tidx][i];
                    int j = 0;
                    while (j < thisWeightVec.numLocations()) {
                        double gradient;
                        double w = thisWeightVec.valueAtLocation(j);
                        if (Double.isInfinite(w)) {
                            logger.warning("Infinite weight for node index " + i + " feature " + ACRF.this.inputAlphabet.lookupObject(j));
                            gradient = 0.0;
                        } else {
                            double constraint = thisConstraintVec.valueAtLocation(j);
                            double expectation = thisExpectationVec.valueAtLocation(j);
                            double scale = ACRF.this.doSizeScale ? 1.0 / (double)this.trainData.size() : 1.0;
                            gradient = scale * (constraint - expectation) - w / ACRF.this.gaussianPriorVariance;
                        }
                        this.cachedGradient[gidx++] = gradient;
                        ++j;
                    }
                    ++i;
                }
                ++tidx;
            }
        }

        private void reportGradient() {
            if (ACRF.this.verboseOutputDirectory != null) {
                ++this.gradCallNo;
                try {
                    File thisFile = new File(ACRF.this.verboseOutputDirectory, "acrf-grad-" + this.gradCallNo + ".txt");
                    PrintWriter writer = new PrintWriter(new FileWriter(thisFile));
                    writer.println(ArrayUtils.toString(this.cachedGradient));
                    writer.close();
                    thisFile = new File(ACRF.this.verboseOutputDirectory, "acrf-value-" + this.gradCallNo + ".txt");
                    writer = new PrintWriter(new FileWriter(thisFile));
                    writer.println(this.cachedValue);
                    writer.close();
                    double[] buf = new double[this.getNumParameters()];
                    this.getParameters(buf);
                    thisFile = new File(ACRF.this.verboseOutputDirectory, "acrf-weight-" + this.gradCallNo + ".txt");
                    writer = new PrintWriter(new FileWriter(thisFile));
                    writer.println(ArrayUtils.toString(buf));
                    writer.close();
                    thisFile = new File(ACRF.this.verboseOutputDirectory, "acrf-constraint-" + this.gradCallNo + ".txt");
                    this.printVecs(thisFile, this.defaultConstraints, this.constraints);
                    thisFile = new File(ACRF.this.verboseOutputDirectory, "acrf-exp-" + this.gradCallNo + ".txt");
                    this.printVecs(thisFile, this.defaultExpectations, this.expectations);
                    thisFile = new File(ACRF.this.verboseOutputDirectory, "acrf-dumps-" + this.gradCallNo + ".txt");
                    writer = new PrintWriter(new FileWriter(thisFile));
                    int ii = 0;
                    while (ii < this.trainData.size()) {
                        UnrolledGraph unrolled = ACRF.this.unroll((Instance)this.trainData.get(ii));
                        writer.println(unrolled);
                        ++ii;
                    }
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void printVecs(File thisFile, SparseVector[] defaultConstraints, SparseVector[][] constraints) throws IOException {
            PrintWriter writer = new PrintWriter(new FileWriter(thisFile));
            int ti = 0;
            while (ti < defaultConstraints.length) {
                writer.println(defaultConstraints[ti]);
                ++ti;
            }
            ti = 0;
            while (ti < constraints.length) {
                int i = 0;
                while (i < constraints[ti].length) {
                    writer.println(constraints[ti][i]);
                    ++i;
                }
                ++ti;
            }
            writer.close();
        }

        private void collectExpectations(UnrolledGraph unrolled, Inferencer inferencer) {
            Iterator it = unrolled.unrolledVarSetIterator();
            while (it.hasNext()) {
                UnrolledVarSet clique = (UnrolledVarSet)it.next();
                int tidx = clique.tmpl.index;
                if (tidx == -1) continue;
                Factor ptl = inferencer.lookupMarginal(clique);
                AssignmentIterator assnIt = ptl.assignmentIterator();
                while (assnIt.hasNext()) {
                    double marginal = ptl.value(assnIt);
                    int idx = assnIt.indexOfCurrentAssn();
                    this.expectations[tidx][idx].plusEqualsSparse(clique.fv, marginal);
                    if (this.defaultExpectations[tidx].location(idx) != -1) {
                        this.defaultExpectations[tidx].incrementValue(idx, marginal);
                    }
                    assnIt.advance();
                }
            }
        }

        public void collectConstraints(InstanceList ilist) {
            int inum = 0;
            while (inum < ilist.size()) {
                logger.finest("*** Collecting constraints for instance " + inum);
                Instance inst = (Instance)ilist.get(inum);
                UnrolledGraph unrolled = new UnrolledGraph(inst, ACRF.this.templates, null, false);
                this.totalNodes = unrolled.numVariables();
                Iterator it = unrolled.unrolledVarSetIterator();
                while (it.hasNext()) {
                    UnrolledVarSet clique = (UnrolledVarSet)it.next();
                    int tidx = clique.tmpl.index;
                    if (tidx == -1) continue;
                    int assn = clique.lookupAssignmentNumber();
                    this.constraints[tidx][assn].plusEqualsSparse(clique.fv);
                    if (this.defaultConstraints[tidx].location(assn) == -1) continue;
                    this.defaultConstraints[tidx].incrementValue(assn, 1.0);
                }
                ++inum;
            }
        }

        void dumpGradientToFile(String fileName) {
            try {
                PrintStream w = new PrintStream(new FileOutputStream(fileName));
                int i = 0;
                while (i < this.numParameters) {
                    w.println(this.cachedGradient[i]);
                    ++i;
                }
                w.close();
            }
            catch (IOException e) {
                System.err.println("Could not open output file.");
                e.printStackTrace();
            }
        }

        void dumpDefaults() {
            System.out.println("Default constraints");
            int i = 0;
            while (i < this.defaultConstraints.length) {
                System.out.println("Template " + i);
                this.defaultConstraints[i].print();
                ++i;
            }
            System.out.println("Default expectations");
            i = 0;
            while (i < this.defaultExpectations.length) {
                System.out.println("Template " + i);
                this.defaultExpectations[i].print();
                ++i;
            }
        }

        void printDebugInfo(UnrolledGraph unrolled) {
            ACRF.this.print(System.err);
            Assignment assn = unrolled.getAssignment();
            Iterator it = unrolled.unrolledVarSetIterator();
            while (it.hasNext()) {
                UnrolledVarSet clique = (UnrolledVarSet)it.next();
                System.out.println("Clique " + clique);
                this.dumpAssnForClique(assn, clique);
                Factor ptl = unrolled.factorOf(clique);
                System.out.println("Value = " + ptl.value(assn));
                System.out.println(ptl);
            }
        }

        void dumpAssnForClique(Assignment assn, UnrolledVarSet clique) {
            for (Variable var : clique) {
                System.out.println(var + " ==> " + assn.getObject(var) + "  (" + assn.get(var) + ")");
            }
        }

        private boolean weightValid(double w, int cnum, int j) {
            if (Double.isInfinite(w)) {
                logger.warning("Weight is infinite for clique " + cnum + "assignment " + j);
                return false;
            }
            if (Double.isNaN(w)) {
                logger.warning("Weight is Nan for clique " + cnum + "assignment " + j);
                return false;
            }
            return true;
        }

        public void report() {
            int nmsg = -1;
            if (this.inferencer instanceof AbstractBeliefPropagation) {
                AbstractBeliefPropagation cfr_ignored_0 = (AbstractBeliefPropagation)this.inferencer;
                nmsg = AbstractBeliefPropagation.getTotalMessagesSent();
            } else if (this.inferencer instanceof JunctionTreeInferencer) {
                nmsg = ((JunctionTreeInferencer)this.inferencer).getTotalMessagesSent();
            }
            if (nmsg != -1) {
                logger.info("Total messages sent = " + nmsg);
            }
        }

        public void forceStale() {
            this.cachedGradientStale = true;
            this.cachedValueStale = true;
        }

        public int getTotalNodes() {
            return this.totalNodes;
        }
    }

    public static class PairwiseFactorTemplate
    extends SequenceTemplate {
        int factor0;
        int factor1;
        private static final long serialVersionUID = 1L;

        public PairwiseFactorTemplate(int factor0, int factor1) {
            this.factor0 = factor0;
            this.factor1 = factor1;
        }

        @Override
        public void addInstantiatedCliques(UnrolledGraph graph, FeatureVectorSequence fvs, LabelsAssignment lblseq) {
            int i = 0;
            while (i < lblseq.maxTime()) {
                Variable v1 = lblseq.varOfIndex(i, this.factor0);
                Variable v2 = lblseq.varOfIndex(i, this.factor1);
                FeatureVector fv = fvs.getFeatureVector(i);
                Variable[] vars = new Variable[]{v1, v2};
                assert (v1 != null) : "Couldn't get label factor " + this.factor0 + " time " + i;
                assert (v2 != null) : "Couldn't get label factor " + this.factor1 + " time " + i;
                UnrolledVarSet clique = new UnrolledVarSet(graph, this, vars, fv);
                graph.addClique(clique);
                ++i;
            }
        }

        public String toString() {
            return "[PairwiseFactorTemplate (" + this.factor0 + ", " + this.factor1 + ")]";
        }
    }

    public static abstract class SequenceTemplate
    extends Template {
        protected abstract void addInstantiatedCliques(UnrolledGraph var1, FeatureVectorSequence var2, LabelsAssignment var3);

        @Override
        public void addInstantiatedCliques(UnrolledGraph graph, Instance instance) {
            FeatureVectorSequence fvs = (FeatureVectorSequence)instance.getData();
            LabelsAssignment lblseq = (LabelsAssignment)instance.getTarget();
            this.addInstantiatedCliques(graph, fvs, lblseq);
        }
    }

    public static abstract class Template
    implements Serializable {
        private static final double SOME_UNSUPPORTED_THRESHOLD = 0.1;
        private boolean unsupportedWeightsAdded = false;
        protected SparseVector[] weights;
        private BitSet assignmentsPresent;
        private boolean supportedOnly = true;
        public int index;
        private SparseVector defaultWeights;
        private boolean trainable = true;
        private static final long serialVersionUID = -727618747254644076L;

        public abstract void addInstantiatedCliques(UnrolledGraph var1, Instance var2);

        protected void modifyPotential(UnrolledGraph unrolledGraph, UnrolledVarSet clique, AbstractTableFactor ptl) {
        }

        protected boolean isSupportedOnly() {
            return this.supportedOnly;
        }

        void setSupportedOnly(boolean supportedOnly) {
            this.supportedOnly = supportedOnly;
        }

        public boolean isUnsupportedWeightsAdded() {
            return this.unsupportedWeightsAdded;
        }

        protected BitSet getAssignmentsPresent() {
            return this.assignmentsPresent;
        }

        public SparseVector[] getWeights() {
            return this.weights;
        }

        public void setWeights(SparseVector[] w) {
            if (this.weights != null && w.length != this.weights.length) {
                throw new IllegalArgumentException("Weights length changed; was " + this.weights.length + " now is " + w.length);
            }
            this.weights = w;
        }

        public int initWeights(InstanceList training) {
            logger.info("Template " + this + " : weights " + (this.supportedOnly ? "with NO" : "with ALL") + " unsupported features...");
            if (this.supportedOnly) {
                return this.initSparseWeights(training);
            }
            return this.initDenseWeights(training);
        }

        private int initDenseWeights(InstanceList training) {
            int numf = training.getDataAlphabet().size();
            int total = 0;
            int size = this.cliqueSizeFromInstance(training);
            total += this.allocateDefaultWeights(size);
            SparseVector[] newWeights = new SparseVector[size];
            int i = 0;
            while (i < size) {
                newWeights[i] = new SparseVector(new double[numf], false);
                if (this.weights != null) {
                    newWeights[i].plusEqualsSparse(this.weights[i]);
                }
                total += numf;
                logger.info("ACRF template " + this + " weights [" + i + "] num features " + numf);
                ++i;
            }
            logger.info("ACRF template " + this + " total num weights = " + total);
            this.weights = newWeights;
            return total;
        }

        private int initSparseWeights(InstanceList training) {
            int total = 0;
            int size = this.cliqueSizeFromInstance(training);
            BitSet[] weightsPresent = new BitSet[size];
            int i = 0;
            while (i < size) {
                weightsPresent[i] = new BitSet();
                ++i;
            }
            this.assignmentsPresent = new BitSet(size);
            this.collectWeightsPresent(training, weightsPresent);
            if (this.weights != null) {
                this.addInCurrentWeights(weightsPresent);
            }
            total += this.allocateDefaultWeights(size);
            SparseVector[] newWeights = new SparseVector[size];
            logger.info("ACRF template " + this + " total num weights = " + (total += this.allocateNewWeights(weightsPresent, newWeights)));
            this.weights = newWeights;
            return total;
        }

        private int allocateNewWeights(BitSet[] weightsPresent, SparseVector[] newWeights) {
            int total = 0;
            int i = 0;
            while (i < weightsPresent.length) {
                int numLocations = weightsPresent[i].cardinality();
                int[] indices = new int[numLocations];
                int j = 0;
                while (j < numLocations) {
                    indices[j] = weightsPresent[i].nextSetBit(j == 0 ? 0 : indices[j - 1] + 1);
                    ++j;
                }
                newWeights[i] = new HashedSparseVector(indices, new double[numLocations], numLocations, numLocations, false, false, false);
                if (this.weights != null) {
                    newWeights[i].plusEqualsSparse(this.weights[i]);
                }
                total += numLocations;
                if (numLocations != 0) {
                    logger.info("ACRF template " + this + " weights [" + i + "] num features " + numLocations);
                }
                ++i;
            }
            return total;
        }

        public int addSomeUnsupportedWeights(InstanceList training) {
            this.unsupportedWeightsAdded = true;
            int size = this.weights.length;
            BitSet[] weightsPresent = new BitSet[size];
            int i = 0;
            while (i < size) {
                weightsPresent[i] = new BitSet();
                ++i;
            }
            this.collectSomeUnsupportedWeights(training, weightsPresent);
            this.addInCurrentWeights(weightsPresent);
            SparseVector[] newWeights = new SparseVector[size];
            int numAdded = this.allocateNewWeights(weightsPresent, newWeights);
            logger.info(this + " some supported weights added = " + numAdded);
            this.weights = newWeights;
            return numAdded;
        }

        private void collectSomeUnsupportedWeights(InstanceList training, BitSet[] weightsPresent) {
            int ii = 0;
            while (ii < training.size()) {
                Instance inst = (Instance)training.get(ii);
                UnrolledGraph unrolled = new UnrolledGraph(inst, new Template[]{this}, new ArrayList(), true);
                Iterator it = unrolled.unrolledVarSetIterator();
                while (it.hasNext()) {
                    UnrolledVarSet vs = (UnrolledVarSet)it.next();
                    Factor f = vs.getFactor();
                    Factor nrmed = f.normalize();
                    AssignmentIterator assnIt = nrmed.assignmentIterator();
                    while (assnIt.hasNext()) {
                        if (nrmed.value(assnIt) > 0.1) {
                            this.addPresentFeatures(weightsPresent[assnIt.indexOfCurrentAssn()], vs.fv);
                        }
                        assnIt.advance();
                    }
                }
                ++ii;
            }
        }

        private int allocateDefaultWeights(int size) {
            SparseVector newdefaultWeights = new SparseVector(new double[size], false);
            if (this.defaultWeights != null) {
                newdefaultWeights.plusEqualsSparse(this.defaultWeights);
            }
            this.defaultWeights = newdefaultWeights;
            return size;
        }

        private int cliqueSizeFromInstance(InstanceList training) {
            int maxWeight = 0;
            int i = 0;
            while (i < training.size()) {
                Instance instance = (Instance)training.get(i);
                UnrolledGraph unrolled = new UnrolledGraph(instance, new Template[]{this}, null, false);
                Iterator it = unrolled.unrolledVarSetIterator();
                while (it.hasNext()) {
                    int thisWeight;
                    UnrolledVarSet clique = (UnrolledVarSet)it.next();
                    if (clique.tmpl != this || (thisWeight = clique.weight()) <= maxWeight) continue;
                    maxWeight = thisWeight;
                }
                ++i;
            }
            if (maxWeight == 0) {
                logger.warning("***ACRF: Don't know size of " + this + ". Never needed in training data.");
            }
            return maxWeight;
        }

        private void checkCliqueSizeConsistent(InstanceList training) {
            int weight = -1;
            int i = 0;
            while (i < training.size()) {
                Instance instance = (Instance)training.get(i);
                UnrolledGraph unrolled = new UnrolledGraph(instance, new Template[]{this}, null, false);
                Iterator it = unrolled.unrolledVarSetIterator();
                while (it.hasNext()) {
                    UnrolledVarSet clique = (UnrolledVarSet)it.next();
                    if (clique.tmpl != this || weight == clique.weight()) continue;
                    System.err.println("Weight change for clique " + clique + " template " + this + " old = " + weight + " new " + clique.weight());
                    int vi = 0;
                    while (vi < clique.size()) {
                        Variable var = clique.get(vi);
                        System.err.println(var + "\t" + var.getNumOutcomes());
                        ++vi;
                    }
                    if (weight == -1) {
                        weight = clique.weight();
                        continue;
                    }
                    throw new IllegalStateException("Error on instance " + instance + ": Template " + this + " clique " + clique + " error.  Strange weight: was " + weight + " now is " + clique.weight());
                }
                ++i;
            }
        }

        private void addInCurrentWeights(BitSet[] weightsPresent) {
            int assn = 0;
            while (assn < this.weights.length) {
                int j = 0;
                while (j < this.weights[assn].numLocations()) {
                    weightsPresent[assn].set(this.weights[assn].indexAtLocation(j));
                    ++j;
                }
                ++assn;
            }
        }

        private void collectWeightsPresent(InstanceList ilist, BitSet[] weightsPresent) {
            int inum = 0;
            while (inum < ilist.size()) {
                Instance inst = (Instance)ilist.get(inum);
                UnrolledGraph unrolled = new UnrolledGraph(inst, new Template[]{this}, null, false);
                this.collectTransitionsPresentForGraph(unrolled);
                this.collectWeightsPresentForGraph(unrolled, weightsPresent);
                ++inum;
            }
        }

        private void collectTransitionsPresentForGraph(UnrolledGraph unrolled) {
            Iterator it = unrolled.unrolledVarSetIterator();
            while (it.hasNext()) {
                UnrolledVarSet clique = (UnrolledVarSet)it.next();
                if (clique.tmpl != this) continue;
                int assnNo = clique.lookupAssignmentNumber();
                this.assignmentsPresent.set(assnNo);
            }
        }

        private void collectWeightsPresentForGraph(UnrolledGraph unrolled, BitSet[] weightsPresent) {
            Iterator it = unrolled.unrolledVarSetIterator();
            while (it.hasNext()) {
                UnrolledVarSet clique = (UnrolledVarSet)it.next();
                if (clique.tmpl != this) continue;
                int assn = clique.lookupAssignmentNumber();
                this.addPresentFeatures(weightsPresent[assn], clique.fv);
            }
        }

        private void addPresentFeatures(BitSet wp, FeatureVector fv) {
            int i = 0;
            while (i < fv.numLocations()) {
                int index = fv.indexAtLocation(i);
                wp.set(index);
                ++i;
            }
        }

        public AbstractTableFactor computeFactor(UnrolledVarSet clique) {
            Matrix phi = this.createFactorMatrix(clique);
            SparseVector[] weights = this.getWeights();
            int loc = 0;
            while (loc < phi.numLocations()) {
                int idx = phi.indexAtLocation(loc);
                assert (idx < weights.length) : "Error: Instantiating " + this + " on " + clique + " : Clique has too many " + "assignments.\n  # of weights = " + weights.length + " clique weight = " + clique.weight();
                SparseVector w = weights[idx];
                double dp = w.dotProduct(clique.fv);
                phi.setValueAtLocation(loc, dp += this.getDefaultWeight(idx));
                ++loc;
            }
            LogTableFactor ptl = new LogTableFactor(clique);
            ptl.setValues(phi);
            return ptl;
        }

        protected Matrix createFactorMatrix(UnrolledVarSet clique) {
            int[] szs = clique.varDimensions();
            return new Matrixn(szs);
        }

        public double getDefaultWeight(int i) {
            return this.defaultWeights.value(i);
        }

        public SparseVector getDefaultWeights() {
            return this.defaultWeights;
        }

        public void setDefaultWeights(SparseVector w) {
            this.defaultWeights = w;
        }

        public void setDefaultWeight(int i, double w) {
            this.defaultWeights.setValue(i, w);
        }

        public boolean isTrainable() {
            return this.trainable;
        }

        public void setTrainable(boolean tr) {
            this.trainable = tr;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.assignmentsPresent == null) {
                this.assignmentsPresent = new BitSet(this.weights.length);
                this.assignmentsPresent.flip(0, this.assignmentsPresent.size());
            }
        }

        protected Assignment computeAssignment(Assignment graphAssn, VarSet vs) {
            return (Assignment)graphAssn.marginalize(vs);
        }
    }

    public static class UnigramTemplate
    extends SequenceTemplate {
        int factor;
        private static final long serialVersionUID = 1L;

        public UnigramTemplate(int factor) {
            this.factor = factor;
        }

        @Override
        public void addInstantiatedCliques(UnrolledGraph graph, FeatureVectorSequence fvs, LabelsAssignment lblseq) {
            int i = 0;
            while (i < lblseq.maxTime()) {
                Variable v = lblseq.varOfIndex(i, this.factor);
                FeatureVector fv = fvs.getFeatureVector(i);
                Variable[] vars = new Variable[]{v};
                assert (v != null) : "Couldn't get label factor " + this.factor + " time " + i;
                UnrolledVarSet clique = new UnrolledVarSet(graph, this, vars, fv);
                graph.addClique(clique);
                ++i;
            }
        }

        public String toString() {
            return "[UnigramTemplate (" + this.factor + ")]";
        }
    }

    public static class UnrolledGraph
    extends UndirectedModel {
        List allVars = new ArrayList();
        List cliques = new ArrayList();
        int numSlices;
        boolean isCached = false;
        Instance instance;
        FeatureVectorSequence fvs;
        private Assignment assignment;
        LabelAlphabet[] outputAlphabets;
        ACRF acrf;
        List allTemplates;
        private boolean isFactorsAdded = false;
        private THashMap uvsMap = new THashMap();
        private double[] lastResids;
        TObjectIntHashMap observedVars = new TObjectIntHashMap();

        public UnrolledGraph(Instance inst, Template[] templates, Template[] fixed) {
            this(inst, templates, Arrays.asList(fixed));
        }

        UnrolledGraph(Instance inst, Template[] templates, List fixed) {
            this(inst, templates, fixed, true);
        }

        public UnrolledGraph(Instance inst, Template[] templates, List fixed, boolean setupPotentials) {
            super(UnrolledGraph.initialCapacity(inst));
            this.instance = inst;
            this.fvs = (FeatureVectorSequence)inst.getData();
            this.assignment = (Assignment)inst.getTarget();
            this.allTemplates = new ArrayList();
            if (fixed != null) {
                this.allTemplates.addAll(fixed);
            }
            this.allTemplates.addAll(Arrays.asList(templates));
            this.setupGraph();
            if (setupPotentials) {
                this.computeCPFs();
            }
        }

        private static int initialCapacity(Instance inst) {
            if (inst.getData() == null) {
                return 8;
            }
            FeatureVectorSequence fvs = (FeatureVectorSequence)inst.getData();
            int T = fvs.size();
            return 3 * T;
        }

        private void setupGraph() {
            for (Template tmpl : this.allTemplates) {
                tmpl.addInstantiatedCliques(this, this.instance);
            }
        }

        public void addClique(UnrolledVarSet clique) {
            this.cliques.add(clique);
        }

        private void computeCPFs() {
            this.isFactorsAdded = true;
            TDoubleArrayList residTmp = new TDoubleArrayList();
            for (UnrolledVarSet clique : this.cliques) {
                AbstractTableFactor ptl = clique.tmpl.computeFactor(clique);
                this.addFactorInternal(clique, ptl);
                clique.tmpl.modifyPotential(this, clique, ptl);
                this.uvsMap.put(ptl, clique);
                LogTableFactor unif = new LogTableFactor(clique);
                residTmp.add(Factors.distLinf(unif, ptl));
            }
            this.lastResids = residTmp.toNativeArray();
        }

        private void addFactorInternal(UnrolledVarSet clique, Factor factor) {
            clique.setFactor(factor);
            Factor prevFactor = this.factorOf(factor.varSet());
            if (prevFactor == null) {
                this.addFactor(factor);
            } else if (prevFactor instanceof FactorGraph) {
                prevFactor.multiplyBy(factor);
            } else {
                this.divideBy(prevFactor);
                this.addFactor(new FactorGraph(new Factor[]{factor, prevFactor}));
            }
        }

        private void recomputeFactors() {
            this.lastResids = new double[this.factors().size()];
            for (UnrolledVarSet clique : this.cliques) {
                double dist;
                AbstractTableFactor oldF = (AbstractTableFactor)clique.getFactor();
                AbstractTableFactor newF = clique.tmpl.computeFactor(clique);
                this.lastResids[this.getIndex((Factor)oldF)] = dist = Factors.distLinf((AbstractTableFactor)oldF.duplicate().normalize(), (AbstractTableFactor)newF.duplicate().normalize());
                oldF.setValues(newF.getLogValueMatrix());
                clique.tmpl.modifyPotential(this, clique, oldF);
            }
        }

        public double[] getLastResids() {
            return this.lastResids;
        }

        int getMaxTime() {
            return this.fvs.size();
        }

        int getNumFactors() {
            return this.outputAlphabets.length;
        }

        public Assignment getAssignment() {
            return this.assignment;
        }

        private boolean isObserved(Variable var) {
            return this.observedVars.contains(var);
        }

        public void setObserved(Variable var, int outcome) {
            this.observedVars.put(var, outcome);
        }

        public int observedValue(Variable var) {
            return this.observedVars.get(var);
        }

        public Iterator unrolledVarSetIterator() {
            return this.cliques.iterator();
        }

        public UnrolledVarSet getUnrolledVarSet(int cnum) {
            return (UnrolledVarSet)this.cliques.get(cnum);
        }

        public int getIndex(VarSet vs) {
            return this.cliques.indexOf(vs);
        }

        @Override
        public Variable get(int idx) {
            if (this.isFactorsAdded) {
                return super.get(idx);
            }
            return (Variable)this.allVars.get(idx);
        }

        @Override
        public int getIndex(Variable var) {
            if (this.isFactorsAdded) {
                return super.getIndex(var);
            }
            return this.allVars.indexOf(var);
        }

        public double getLogNumAssignments() {
            double total = 0.0;
            int i = 0;
            while (i < this.numVariables()) {
                Variable var = this.get(i);
                total += Math.log(var.getNumOutcomes());
                ++i;
            }
            return total;
        }

        public Variable varOfIndex(int t, int j) {
            LabelsAssignment lblseq = (LabelsAssignment)this.instance.getTarget();
            return lblseq.varOfIndex(t, j);
        }

        public int numSlices() {
            LabelsAssignment lblseq = (LabelsAssignment)this.instance.getTarget();
            return lblseq.numSlices();
        }

        public double[] computeCurrentResids() {
            this.lastResids = new double[this.factors().size()];
            for (UnrolledVarSet clique : this.cliques) {
                double dist;
                AbstractTableFactor oldF = (AbstractTableFactor)clique.getFactor();
                AbstractTableFactor newF = clique.tmpl.computeFactor(clique);
                this.lastResids[this.getIndex((Factor)oldF)] = dist = Factors.distLinf(oldF, newF);
            }
            return this.lastResids;
        }

        public UnrolledVarSet getUnrolledVarSet(Factor f) {
            return (UnrolledVarSet)this.uvsMap.get(f);
        }
    }

    public static class UnrolledVarSet
    extends HashVarSet {
        Template tmpl;
        FeatureVector fv;
        Variable[] vars;
        Factor factor;
        UnrolledGraph graph;
        double lastChange;

        public int[] varDimensions() {
            int[] dims = new int[this.size()];
            int i = 0;
            while (i < this.size()) {
                dims[i] = this.get(i).getNumOutcomes();
                ++i;
            }
            return dims;
        }

        public UnrolledVarSet(UnrolledGraph graph, Template tmpl, Variable[] vars, FeatureVector fv) {
            super(vars);
            this.graph = graph;
            this.vars = vars;
            this.tmpl = tmpl;
            this.fv = fv;
        }

        Assignment getAssignmentByNumber(int assn) {
            int[] sizes = this.varDimensions();
            int[] indices = new int[sizes.length];
            Matrixn.singleToIndices(assn, indices, sizes);
            return new Assignment(this.vars, indices);
        }

        public final int lookupAssignmentNumber() {
            Assignment mine = this.lookupAssignment();
            return mine.singleIndex();
        }

        public final Assignment lookupAssignment() {
            return this.tmpl.computeAssignment(this.graph.getAssignment(), this);
        }

        public int lookupNumberOfAssignment(Assignment assn) {
            int[] sizes = this.varDimensions();
            int[] indices = new int[sizes.length];
            int i = 0;
            while (i < indices.length) {
                indices[i] = assn.get(this.vars[i]);
                ++i;
            }
            return Matrixn.singleIndex(sizes, indices);
        }

        public Template getTemplate() {
            return this.tmpl;
        }

        public FeatureVector getFv() {
            return this.fv;
        }

        public Factor getFactor() {
            return this.factor;
        }

        private void setFactor(Factor newF) {
            if (this.factor != null) {
                this.lastChange = Factors.distLinf((AbstractTableFactor)newF, (AbstractTableFactor)this.factor);
            }
            this.factor = newF;
        }

        public double getLastChange() {
            return this.lastChange;
        }
    }
}

