/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.util;

import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.Variable;
import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Labels;
import cc.mallet.types.LabelsSequence;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Map;

public class LabelsAssignment
extends Assignment
implements AlphabetCarrying {
    private static int NEXT_ID = 0;
    private int id = NEXT_ID++;
    private Variable[][] idx2var;
    private LabelsSequence lblseq;
    private Map var2label;

    public LabelsAssignment(LabelsSequence lbls) {
        this.lblseq = lbls;
        this.setupLabel2Var();
        this.addRow(this.toVariableArray(), this.toValueArray());
    }

    private Variable[] toVariableArray() {
        ArrayList<Variable> vars = new ArrayList<Variable>(this.maxTime() * this.numSlices());
        int t = 0;
        while (t < this.idx2var.length) {
            int j = 0;
            while (j < this.idx2var[t].length) {
                vars.add(this.idx2var[t][j]);
                ++j;
            }
            ++t;
        }
        return vars.toArray(new Variable[vars.size()]);
    }

    private int[] toValueArray() {
        TIntArrayList vals = new TIntArrayList(this.maxTime() * this.numSlices());
        int t = 0;
        while (t < this.lblseq.size()) {
            Labels lbls = this.lblseq.getLabels(t);
            int j = 0;
            while (j < lbls.size()) {
                Label lbl = lbls.get(j);
                vals.add(lbl.getIndex());
                ++j;
            }
            ++t;
        }
        return vals.toNativeArray();
    }

    private void setupLabel2Var() {
        this.idx2var = new Variable[this.lblseq.size()][];
        this.var2label = new THashMap();
        int t = 0;
        while (t < this.lblseq.size()) {
            Labels lbls = this.lblseq.getLabels(t);
            this.idx2var[t] = new Variable[lbls.size()];
            int j = 0;
            while (j < lbls.size()) {
                Label lbl = lbls.get(j);
                Variable var = new Variable(lbl.getLabelAlphabet());
                var.setLabel("I" + this.id + "_VAR[f=" + j + "][tm=" + t + "]");
                this.idx2var[t][j] = var;
                this.var2label.put(var, lbl);
                ++j;
            }
            ++t;
        }
    }

    public Variable varOfIndex(int t, int j) {
        return this.idx2var[t][j];
    }

    public Label labelOfVar(Variable var) {
        return (Label)this.var2label.get(var);
    }

    public int maxTime() {
        return this.lblseq.size();
    }

    public int numSlices() {
        return this.idx2var[0].length;
    }

    public LabelsSequence getLabelsSequence() {
        return this.lblseq;
    }

    public LabelsSequence toLabelsSequence(Assignment assn) {
        int numFactors = this.numSlices();
        int maxTime = this.maxTime();
        Labels[] lbls = new Labels[maxTime];
        int t = 0;
        while (t < maxTime) {
            Label[] theseLabels = new Label[numFactors];
            int i = 0;
            while (i < numFactors) {
                Variable var = this.varOfIndex(t, i);
                int maxidx = var != null ? assn.get(var) : 0;
                LabelAlphabet dict = this.labelOfVar(var).getLabelAlphabet();
                theseLabels[i] = dict.lookupLabel(maxidx);
                ++i;
            }
            lbls[t] = new Labels(theseLabels);
            ++t;
        }
        return new LabelsSequence(lbls);
    }

    public LabelAlphabet getOutputAlphabet(int lvl) {
        return this.idx2var[0][lvl].getLabelAlphabet();
    }

    @Override
    public Alphabet getAlphabet() {
        return this.getOutputAlphabet(0);
    }

    @Override
    public Alphabet[] getAlphabets() {
        return new Alphabet[]{this.getAlphabet()};
    }
}

