/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.types.Instance;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public class UnlabeledFileIterator
implements Iterator<Instance> {
    FileFilter fileFilter;
    ArrayList<File> fileArray;
    Iterator<File> subIterator;
    File[] startingDirectories;
    int[] minFileIndex;
    int fileCount;
    public static final Pattern STARTING_DIRECTORIES = Pattern.compile("_STARTING_DIRECTORIES_");
    public static final Pattern FIRST_DIRECTORY = Pattern.compile("/?([^/]*)/.+");
    public static final Pattern LAST_DIRECTORY = Pattern.compile(".*/([^/]+)/[^/]+");
    public static final Pattern ALL_DIRECTORIES = Pattern.compile("^(.*)/[^/]+");

    public ArrayList<File> getFileArray() {
        return this.fileArray;
    }

    protected UnlabeledFileIterator(File[] directories, FileFilter fileFilter) {
        this.startingDirectories = directories;
        this.fileFilter = fileFilter;
        this.minFileIndex = new int[directories.length];
        this.fileArray = new ArrayList();
        int i = 0;
        while (i < directories.length) {
            if (!directories[i].isDirectory()) {
                throw new IllegalArgumentException(String.valueOf(directories[i].getAbsolutePath()) + " is not a directory.");
            }
            this.minFileIndex[i] = this.fileArray.size();
            this.fillFileArray(directories[i], fileFilter, this.fileArray);
            ++i;
        }
        this.subIterator = this.fileArray.iterator();
        this.fileCount = 0;
        String[] dirStrings = new String[directories.length];
        int i2 = 0;
        while (i2 < directories.length) {
            dirStrings[i2] = directories[i2].toString();
            ++i2;
        }
    }

    public static File[] stringArray2FileArray(String[] sa) {
        File[] ret = new File[sa.length];
        int i = 0;
        while (i < sa.length) {
            ret[i] = new File(sa[i]);
            ++i;
        }
        return ret;
    }

    public UnlabeledFileIterator(String[] directories, FileFilter ff) {
        this(UnlabeledFileIterator.stringArray2FileArray(directories), ff);
    }

    public UnlabeledFileIterator(File directory, FileFilter fileFilter) {
        this(new File[]{directory}, fileFilter);
    }

    public UnlabeledFileIterator(File directory) {
        this(new File[]{directory}, null);
    }

    public UnlabeledFileIterator(File[] directories) {
        this(directories, null);
    }

    public UnlabeledFileIterator(String directory) {
        this(new File[]{new File(directory)}, null);
    }

    public UnlabeledFileIterator(String directory, FileFilter filter) {
        this(new File[]{new File(directory)}, filter);
    }

    private int fillFileArray(File directory, FileFilter filter, ArrayList<File> files) {
        int count = 0;
        File[] directoryContents = directory.listFiles();
        int i = 0;
        while (i < directoryContents.length) {
            if (directoryContents[i].isDirectory()) {
                count += this.fillFileArray(directoryContents[i], filter, files);
            } else if (filter == null || filter.accept(directoryContents[i])) {
                files.add(directoryContents[i]);
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public Instance next() {
        File nextFile = this.subIterator.next();
        ++this.fileCount;
        return new Instance(nextFile, null, nextFile.toURI(), null);
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }

    public File nextFile() {
        return this.subIterator.next();
    }

    @Override
    public boolean hasNext() {
        return this.subIterator.hasNext();
    }
}

