/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility.index;

import de.julielab.jcore.utility.index.IndexTermGenerator;
import de.julielab.jcore.utility.index.JCoReMapAnnotationIndex;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class JCoReTreeMapAnnotationIndex<K extends Comparable<K>, T extends Annotation>
extends JCoReMapAnnotationIndex<K, T> {
    public JCoReTreeMapAnnotationIndex(IndexTermGenerator<K> indexTermGenerator, IndexTermGenerator<K> searchTermGenerator) {
        super(TreeMap::new, indexTermGenerator, searchTermGenerator);
    }

    public JCoReTreeMapAnnotationIndex(IndexTermGenerator<K> indexTermGenerator, IndexTermGenerator<K> searchTermGenerator, JCas jCas, Type type) {
        super(TreeMap::new, indexTermGenerator, searchTermGenerator, jCas, type);
    }

    public JCoReTreeMapAnnotationIndex(IndexTermGenerator<K> indexTermGenerator, IndexTermGenerator<K> searchTermGenerator, JCas jCas, int type) {
        super(TreeMap::new, indexTermGenerator, searchTermGenerator, jCas, type);
    }

    public JCoReTreeMapAnnotationIndex(Comparator<K> comparator, IndexTermGenerator<K> indexTermGenerator, IndexTermGenerator<K> searchTermGenerator) {
        super(() -> new TreeMap(comparator), indexTermGenerator, searchTermGenerator);
    }

    public JCoReTreeMapAnnotationIndex(Comparator<K> comparator, IndexTermGenerator<K> indexTermGenerator, IndexTermGenerator<K> searchTermGenerator, JCas jCas, Type type) {
        super(() -> new TreeMap(comparator), indexTermGenerator, searchTermGenerator, jCas, type);
    }

    public JCoReTreeMapAnnotationIndex(Comparator<K> comparator, IndexTermGenerator<K> indexTermGenerator, IndexTermGenerator<K> searchTermGenerator, JCas jCas, int type) {
        super(() -> new TreeMap(comparator), indexTermGenerator, searchTermGenerator, jCas, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<T> searchFuzzy(Annotation a) {
        Object o = this.searchTermGenerator.generateIndexTerms(a);
        if (o instanceof Stream) {
            try (Stream searchTerms = (Stream)o;){
                Stream<T> stream = this.searchFuzzy((K)searchTerms);
                return stream;
            }
        }
        return this.searchFuzzy((Comparable)o);
    }

    public Stream<T> searchFuzzy(Stream<K> searchTerms) {
        Stream<T> result = null;
        Iterator it = searchTerms.iterator();
        while (it.hasNext()) {
            Comparable t = (Comparable)it.next();
            if (result == null) {
                result = this.searchFuzzy(t);
                continue;
            }
            Stream.concat(result, this.searchFuzzy(t));
        }
        return result;
    }

    public Stream<T> searchFuzzy(K key) {
        Comparable higher;
        if (this.index.isEmpty()) {
            return Stream.empty();
        }
        TreeMap index = (TreeMap)this.index;
        boolean firstInclusive = false;
        boolean lastInclusive = false;
        Comparable lower = (Comparable)index.lowerKey(key);
        if (lower == null) {
            lower = (Comparable)index.firstKey();
            firstInclusive = true;
        }
        if ((higher = (Comparable)index.higherKey(key)) == null) {
            higher = (Comparable)index.lastKey();
            lastInclusive = true;
        }
        return index.subMap(lower, firstInclusive, higher, lastInclusive).values().stream().flatMap(c -> c.stream());
    }
}

