/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.DocumentExtraction;
import cc.mallet.extract.Extractor;
import cc.mallet.extract.Field;
import cc.mallet.extract.FieldCleaner;
import cc.mallet.extract.Record;
import cc.mallet.extract.Tokenization;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Sequence;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Extraction {
    private Extractor extractor;
    private List byDocs = new ArrayList();
    private List records = new ArrayList();
    List trueRecords = new ArrayList();
    private LabelAlphabet dict;

    public Extraction(Extractor extractor, LabelAlphabet dict) {
        this.extractor = extractor;
        this.dict = dict;
    }

    public Extraction(Extractor extractor, LabelAlphabet dict, String name, Tokenization input, Sequence output, String background) {
        this.extractor = extractor;
        this.dict = dict;
        DocumentExtraction docseq = new DocumentExtraction(name, dict, input, output, background);
        this.addDocumentExtraction(docseq);
    }

    public void addDocumentExtraction(DocumentExtraction docseq) {
        this.byDocs.add(docseq);
        this.records.add(new Record(docseq.getName(), docseq.getExtractedSpans()));
        if (docseq.getTargetSpans() != null) {
            this.trueRecords.add(new Record("TRUE:" + docseq.getName(), docseq.getTargetSpans()));
        }
    }

    public Record getRecord(int idx) {
        return (Record)this.records.get(idx);
    }

    public int getNumRecords() {
        return this.records.size();
    }

    public DocumentExtraction getDocumentExtraction(int idx) {
        return (DocumentExtraction)this.byDocs.get(idx);
    }

    public int getNumDocuments() {
        return this.byDocs.size();
    }

    public Extractor getExtractor() {
        return this.extractor;
    }

    public Record getTargetRecord(int docnum) {
        return (Record)this.trueRecords.get(docnum);
    }

    public LabelAlphabet getLabelAlphabet() {
        return this.dict;
    }

    public void cleanFields(FieldCleaner cleaner) {
        Iterator it = this.records.iterator();
        while (it.hasNext()) {
            this.cleanRecord((Record)it.next(), cleaner);
        }
        it = this.trueRecords.iterator();
        while (it.hasNext()) {
            this.cleanRecord((Record)it.next(), cleaner);
        }
    }

    private void cleanRecord(Record record, FieldCleaner cleaner) {
        Iterator it = record.fieldsIterator();
        while (it.hasNext()) {
            Field field = (Field)it.next();
            field.cleanField(cleaner);
        }
    }

    public void print(PrintWriter writer) {
        Iterator it = this.records.iterator();
        writer.println("***EXTRACTION***");
        while (it.hasNext()) {
            Record record = (Record)it.next();
            writer.println("**RECORD " + record.getName());
            Iterator fit = record.fieldsIterator();
            while (fit.hasNext()) {
                Field field = (Field)fit.next();
                writer.println(field.getName());
                for (int fidx = 0; fidx < field.numValues(); ++fidx) {
                    String val = field.value(fidx).replaceAll("\n", " ");
                    writer.print("      ==> " + val + "\n");
                }
                writer.println();
            }
        }
        writer.println("***END EXTRACTION***");
    }
}

