/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities;

import java.io.File;
import java.io.IOException;
import org.rauschig.jarchivelib.ArchiveEntry;
import org.rauschig.jarchivelib.ArchiveStream;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionUtilities {
    private static final Logger log = LoggerFactory.getLogger(CompressionUtilities.class);

    public static File extract(File from, File to, boolean deleteArchive) throws IOException {
        ArchiveEntry entry;
        Archiver archiver = ArchiverFactory.createArchiver((File)from);
        log.debug("Extracting archive {} to {}", (Object)from, (Object)to);
        archiver.extract(from, to);
        ArchiveStream archiveStream = archiver.stream(from);
        String firstEntryName = null;
        while ((entry = archiveStream.getNextEntry()) != null && firstEntryName == null) {
            if (!entry.isDirectory()) continue;
            firstEntryName = entry.getName();
        }
        File firstEntryFile = new File(to.getAbsolutePath() + File.separator + firstEntryName);
        if (deleteArchive) {
            log.debug("Deleting archive file {}", (Object)from);
            if (!from.delete()) {
                throw new IOException("Could not delete the archive at " + from.getAbsolutePath());
            }
        }
        return firstEntryFile;
    }
}

