/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jnet.utils;

import java.util.ArrayList;
import java.util.HashMap;

public class IOEvaluation {
    public String getType() {
        return "IO tags";
    }

    public static double[] evaluate(ArrayList<?> gold_tok, ArrayList<?> eval_tok) {
        if (gold_tok.size() != eval_tok.size()) {
            System.err.println("gold size different from predicted");
        }
        ArrayList<String> gold = new ArrayList<String>();
        ArrayList<String> eval = new ArrayList<String>();
        for (int i = 0; i < gold_tok.size(); ++i) {
            String[] gTok = ((String)gold_tok.get(i)).replaceAll("[\\s]+", "\t").split("\t");
            String[] eTok = ((String)eval_tok.get(i)).replaceAll("[\\s]+", "\t").split("\t");
            if (gTok.length != 2) {
                System.err.println("ERR: format error in gold file. IOB format must be: token<tab>label");
                System.exit(-1);
            } else if (eTok.length != 2) {
                System.err.println("ERR: format error in eval file. IOB format must be: token<tab>label");
                System.exit(-1);
            }
            gold.add(gTok[1]);
            eval.add(eTok[1]);
        }
        return IOEvaluation.getValuesIO(gold, eval);
    }

    private static double[] getValuesIO(ArrayList<String> gold, ArrayList<String> eval) {
        if (gold.size() != eval.size()) {
            System.err.println("error!, gold.size!=eval.size -> I quit!");
            System.exit(0);
        }
        HashMap<String, String> gold_chunks = IOEvaluation.getChunksIO(gold);
        HashMap<String, String> eval_chunks = IOEvaluation.getChunksIO(eval);
        int numcorr = 0;
        int numans = eval_chunks.size();
        int numref = gold_chunks.size();
        for (String offset : eval_chunks.keySet()) {
            String tags_gold;
            String tags_eval;
            if (!gold_chunks.containsKey(offset) || !(tags_eval = eval_chunks.get(offset)).equals(tags_gold = gold_chunks.get(offset))) continue;
            ++numcorr;
        }
        double precision = 0.0;
        double recall = 0.0;
        double fscore = 0.0;
        if (numans > 0) {
            precision = (double)numcorr / (double)numans;
        }
        if (numref > 0) {
            recall = (double)numcorr / (double)numref;
        }
        if (precision + recall > 0.0) {
            fscore = 2.0 * precision * recall / (precision + recall);
        }
        double[] values = new double[]{recall, precision, fscore};
        return values;
    }

    public static HashMap<String, String> getChunksIO(ArrayList<String> taglist) {
        int begin = -1;
        int end = -1;
        HashMap<String, String> blocks = new HashMap<String, String>();
        String old_tag = "O";
        String curr_tag = "";
        for (int i = 0; i < taglist.size(); ++i) {
            curr_tag = taglist.get(i);
            if (!curr_tag.equals(old_tag)) {
                if (begin > -1) {
                    end = i - 1;
                    Object info = "";
                    for (int j = begin; j < end + 1; ++j) {
                        if (((String)info).length() > 0) {
                            info = (String)info + "#";
                        }
                        info = (String)info + taglist.get(j);
                    }
                    blocks.put(begin + "," + end, (String)info);
                }
                begin = !curr_tag.equals("O") ? i : -1;
                end = -1;
            }
            old_tag = curr_tag;
        }
        return blocks;
    }
}

