/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.morph;

import java.util.List;
import java.util.Map;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.dictionary.POSKey;
import net.didion.jwnl.dictionary.morph.BaseFormSet;
import net.didion.jwnl.dictionary.morph.Operation;
import net.didion.jwnl.util.cache.Cache;
import net.didion.jwnl.util.cache.LRUCache;
import net.didion.jwnl.util.factory.Param;
import net.didion.jwnl.util.factory.ParamList;

public class DefaultMorphologicalProcessor
implements MorphologicalProcessor {
    public static final String CACHE_CAPACITY = "cache_capacity";
    public static final String OPERATIONS = "operations";
    private static final int DEFAULT_CACHE_CAPACITY = 1000;
    private Cache _lookupCache;
    private Operation[] _operations;

    public DefaultMorphologicalProcessor() {
    }

    public DefaultMorphologicalProcessor(Operation[] operations) {
        this(operations, 1000);
    }

    public DefaultMorphologicalProcessor(Operation[] operations, int cacheCapacity) {
        this._lookupCache = new LRUCache(cacheCapacity);
        this._operations = operations;
    }

    @Override
    public Object create(Map params) throws JWNLException {
        ParamList operationParams = (ParamList)params.get(OPERATIONS);
        if (operationParams == null) {
            throw new JWNLException("DICTIONARY_EXCEPTION_026");
        }
        List operations = (List)operationParams.create();
        Operation[] operationArray = operations.toArray(new Operation[operations.size()]);
        Param param = (Param)params.get(CACHE_CAPACITY);
        int capacity = param == null ? 1000 : new Integer(param.getValue());
        return new DefaultMorphologicalProcessor(operationArray, capacity);
    }

    @Override
    public IndexWord lookupBaseForm(POS pos, String derivation) throws JWNLException {
        LookupInfo info = this.getCachedLookupInfo(new POSKey(pos, derivation));
        if (info != null && info.getBaseForms().isCurrentFormAvailable()) {
            return Dictionary.getInstance().getIndexWord(pos, info.getBaseForms().getCurrentForm());
        }
        return this.lookupNextBaseForm(pos, derivation, info);
    }

    private void cacheLookupInfo(POSKey key, LookupInfo info) {
        this._lookupCache.put(key, info);
    }

    private LookupInfo getCachedLookupInfo(POSKey key) {
        return (LookupInfo)this._lookupCache.get(key);
    }

    private IndexWord lookupNextBaseForm(POS pos, String derivation, LookupInfo info) throws JWNLException {
        POSKey key;
        if (derivation.equals("") || derivation == null) {
            return null;
        }
        String str = null;
        if (info == null && (info = this.getCachedLookupInfo(key = new POSKey(pos, derivation))) == null) {
            info = new LookupInfo(pos, derivation, this._operations);
            this.cacheLookupInfo(key, info);
        }
        if (info.getBaseForms().isMoreFormsAvailable()) {
            str = info.getBaseForms().getNextForm();
        } else {
            while (str == null && info.isNextOperationAvailable() && !info.executeNextOperation()) {
            }
            if (info.getBaseForms().isMoreFormsAvailable()) {
                str = info.getBaseForms().getNextForm();
            }
        }
        return str == null ? null : Dictionary.getInstance().getIndexWord(pos, str);
    }

    @Override
    public List lookupAllBaseForms(POS pos, String derivation) throws JWNLException {
        LookupInfo info = this.getCachedLookupInfo(new POSKey(pos, derivation));
        if (info == null) {
            info = new LookupInfo(pos, derivation, this._operations);
            this.cacheLookupInfo(new POSKey(pos, derivation), info);
        }
        int index = info.getBaseForms().getIndex();
        while (info.isNextOperationAvailable()) {
            this.lookupNextBaseForm(pos, derivation, info);
        }
        info.getBaseForms().setIndex(index);
        return info.getBaseForms().getForms();
    }

    private class LookupInfo {
        private POS _pos;
        private String _derivation;
        private BaseFormSet _baseForms;
        private Operation[] _operations;
        private int _currentOperation;

        public LookupInfo(POS pos, String derivation, Operation[] operations) {
            this._pos = pos;
            this._derivation = derivation;
            this._operations = operations;
            this._baseForms = new BaseFormSet();
            this._currentOperation = -1;
        }

        public boolean isNextOperationAvailable() {
            return this._currentOperation + 1 < this._operations.length;
        }

        public boolean executeNextOperation() throws JWNLException {
            if (!this.isNextOperationAvailable()) {
                throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_027");
            }
            Operation oper = this._operations[++this._currentOperation];
            return oper.execute(this._pos, this._derivation, this._baseForms);
        }

        public BaseFormSet getBaseForms() {
            return this._baseForms;
        }
    }
}

