/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.util;

import java.lang.reflect.Field;
import java.util.Locale;

public final class LocaleUtil {
    private LocaleUtil() {
    }

    public static Locale getLocaleConstant(String localeConstant) {
        try {
            Field field = Locale.class.getField(localeConstant);
            if (field != null && field.getType().equals(Locale.class)) {
                return (Locale)field.get(null);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static Locale createLocale(String localeString) {
        String[] parts = localeString.split("[_-]", 3);
        switch (parts.length) {
            case 3: {
                return new Locale(parts[0], parts[1], parts[2]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
            case 1: {
                return new Locale(parts[0]);
            }
        }
        throw new IllegalArgumentException("Invalid locale: " + localeString);
    }

    public static Locale getLocale(String localeString) {
        Locale locale = LocaleUtil.getLocaleConstant(localeString);
        if (locale != null) {
            return locale;
        }
        return LocaleUtil.createLocale(localeString);
    }
}

