/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.rauschig.jarchivelib.ArchiveEntry;
import org.rauschig.jarchivelib.ArchiveStream;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionUtilities {
    private static final Logger log = LoggerFactory.getLogger(CompressionUtilities.class);

    public static File extract(File from, File to, boolean deleteArchive) throws IOException {
        ArchiveEntry entry;
        Archiver archiver = ArchiverFactory.createArchiver((File)from);
        log.debug("Extracting archive {} to {}", (Object)from, (Object)to);
        archiver.extract(from, to);
        ArchiveStream archiveStream = archiver.stream(from);
        String firstEntryName = null;
        while ((entry = archiveStream.getNextEntry()) != null && firstEntryName == null) {
            if (!entry.isDirectory()) continue;
            firstEntryName = entry.getName();
        }
        File firstEntryFile = new File(to.getAbsolutePath() + File.separator + firstEntryName);
        if (deleteArchive) {
            log.debug("Deleting archive file {}", (Object)from);
            if (!from.delete()) {
                throw new IOException("Could not delete the archive at " + from.getAbsolutePath());
            }
        }
        return firstEntryFile;
    }

    public static Iterator<InputStream> getArchiveEntryInputStreams(File archive) throws IOException {
        Archiver archiver = ArchiverFactory.createArchiver((File)archive);
        final ArchiveStream stream = archiver.stream(archive);
        return new Iterator<InputStream>(){
            private ArchiveEntry currentEntry;
            boolean exhausted = false;

            @Override
            public boolean hasNext() {
                if (this.currentEntry == null && !this.exhausted) {
                    try {
                        this.currentEntry = stream.getNextEntry();
                        while (this.currentEntry != null && this.currentEntry.isDirectory()) {
                            this.currentEntry = stream.getNextEntry();
                        }
                        if (this.currentEntry == null) {
                            this.exhausted = true;
                        }
                    }
                    catch (IOException e) {
                        log.error("Could not get next archive entry", e);
                    }
                }
                return !this.exhausted;
            }

            @Override
            public InputStream next() {
                if (this.hasNext()) {
                    this.currentEntry = null;
                    return stream;
                }
                return null;
            }
        };
    }
}

