/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;

public class ConfigurationUtilities {
    public static final String LS = System.getProperty("line.separator");

    public static <T> T requirePresent(String key, Function<String, T> f) throws ConfigurationException {
        T value = f.apply(key);
        if (value == null) {
            throw new ConfigurationException("The passed configuration does not have a value for key " + key + ".");
        }
        return value;
    }

    public static void checkParameters(HierarchicalConfiguration<ImmutableNode> configuration, String ... parameters) throws ConfigurationException {
        ArrayList<String> parameterNotFound = new ArrayList<String>();
        for (String parameter : parameters) {
            if (configuration.getProperty(parameter) != null) continue;
            parameterNotFound.add(parameter);
        }
        if (!parameterNotFound.isEmpty()) {
            throw new ConfigurationException("The following required parameters are not set in the configuration:" + LS + parameterNotFound.stream().collect(Collectors.joining(LS)));
        }
    }

    public static void checkFilesExist(HierarchicalConfiguration<ImmutableNode> configuration, String ... parameters) throws ConfigurationException {
        ConfigurationUtilities.checkParameters(configuration, parameters);
        ArrayList<String> parameterNotFound = new ArrayList<String>();
        for (String parameter : parameters) {
            if (new File(configuration.getString(parameter)).exists()) continue;
            parameterNotFound.add(parameter);
        }
        if (!parameterNotFound.isEmpty()) {
            throw new ConfigurationException("The following required files given by the configuration do not exist: " + LS + parameterNotFound.stream().collect(Collectors.joining(LS)));
        }
    }

    public static XMLConfiguration loadXmlConfiguration(File configurationFile) throws ConfigurationException {
        try {
            Parameters params = new Parameters();
            FileBasedConfigurationBuilder configBuilder = new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)params.xml().setExpressionEngine((ExpressionEngine)new XPathExpressionEngine())).setEncoding(StandardCharsets.UTF_8.name())).setFile(configurationFile)});
            return (XMLConfiguration)configBuilder.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public static HierarchicalConfiguration<ImmutableNode> createEmptyConfiguration() throws ConfigurationException {
        XMLConfiguration c;
        Parameters params = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((XMLBuilderParameters)params.xml().setExpressionEngine((ExpressionEngine)new XPathExpressionEngine())).setEncoding(StandardCharsets.UTF_8.name())});
        try {
            c = (XMLConfiguration)builder.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException();
        }
        return c;
    }

    public static void writeConfiguration(HierarchicalConfiguration<ImmutableNode> configuration, File destination) throws ConfigurationException {
        try {
            if (!(configuration instanceof FileBased)) {
                throw new ConfigurationException("The created configuration cannot be stored to file because the chosen configuration implementation " + configuration.getClass().getCanonicalName() + " does not implement the " + FileBased.class.getCanonicalName() + " interface");
            }
            FileHandler fh = new FileHandler((FileBased)configuration);
            fh.save(destination);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException();
        }
    }

    public static String dot(String ... keys) {
        return Stream.of(keys).collect(Collectors.joining("."));
    }

    public static String slash(String ... keys) {
        return Stream.of(keys).collect(Collectors.joining("/"));
    }

    public static String ws(String baseElement, String newElement) {
        return baseElement + " " + newElement;
    }

    public static String last(String path) {
        return path + "[last()]";
    }

    public static String attrEqPred(String attribute, String value) {
        return ConfigurationUtilities.attrEqMultiPred("", attribute, value);
    }

    public static String attrEqMultiPred(String operator, String ... attributesAndValues) {
        if (attributesAndValues.length % 2 == 1) {
            throw new IllegalStateException("There is an uneven number of arguments.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < attributesAndValues.length; ++i) {
            String attributesAndValue = attributesAndValues[i];
            if (i % 2 != 0) continue;
            sb.append(ConfigurationUtilities.attrEq(attributesAndValue, attributesAndValues[i + 1]));
            if (i + 2 >= attributesAndValues.length) continue;
            sb.append(" ").append(operator).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String attrEq(String attribute, String value) {
        return attribute + "='" + value + "'";
    }
}

