/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities;

import de.julielab.java.utilities.UriUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtilities {
    private static final Logger log = LoggerFactory.getLogger(FileUtilities.class);

    public static BufferedInputStream getInputStreamFromFile(File file) throws IOException {
        InputStream is = new FileInputStream(file);
        String lcfn = file.getName().toLowerCase();
        if (lcfn.contains(".gz") || lcfn.contains(".gzip")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedInputStream(is);
    }

    public static BufferedOutputStream getOutputStreamToFile(File file) throws IOException {
        OutputStream os = new FileOutputStream(file);
        String lcfn = file.getName().toLowerCase();
        if (lcfn.contains(".gz") || lcfn.contains(".gzip")) {
            os = new GZIPOutputStream(os);
        }
        return new BufferedOutputStream(os);
    }

    public static BufferedReader getReaderFromFile(File file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)FileUtilities.getInputStreamFromFile(file), StandardCharsets.UTF_8));
    }

    public static BufferedWriter getWriterToFile(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)FileUtilities.getOutputStreamToFile(file), StandardCharsets.UTF_8));
    }

    public static void createJarFile(File outputFile, File ... files) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        try (JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(outputFile), manifest);){
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                FileUtilities.addFileToJarOutputStream(file, new StringBuilder(), target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFileToJarOutputStream(File source, StringBuilder rootPath, JarOutputStream target) throws IOException {
        try (BufferedInputStream in = null;){
            int count;
            String name;
            String string = name = rootPath.length() > 0 ? rootPath + source.getName() : source.getName();
            if (source.isDirectory()) {
                if (!name.isEmpty()) {
                    if (!name.endsWith("/")) {
                        name = name + "/";
                    }
                    JarEntry entry = new JarEntry(name);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                rootPath.append(name);
                for (File nestedFile : source.listFiles()) {
                    FileUtilities.addFileToJarOutputStream(nestedFile, rootPath, target);
                }
                return;
            }
            JarEntry entry = new JarEntry(name);
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            in = new BufferedInputStream(new FileInputStream(source));
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
    }

    public static InputStream findResource(String name) throws IOException {
        InputStream is = null;
        if (is == null) {
            log.trace("Trying to find resource '{}' as a file", (Object)name);
            File file = new File(name);
            if (file.exists()) {
                log.trace("Found file '{}'", (Object)file);
                is = FileUtilities.getInputStreamFromFile(file);
            }
        }
        if (is == null) {
            log.trace("No file at path '{}' was found. Trying to parse as an URI.", (Object)new File(name).getAbsolutePath());
            try {
                URI uri = new URI(name);
                if (uri.isAbsolute()) {
                    is = UriUtilities.getInputStreamFromUri(uri);
                    if (log.isDebugEnabled() && is != null) {
                        log.debug("Found resources at URI '{}'", (Object)uri.toString());
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (is == null) {
            log.trace("Did not find a resource at file or URI '{}', trying as resource on the classpath.", (Object)name);
            is = FileUtilities.class.getResourceAsStream(name.startsWith("/") ? name : "/" + name);
            if (log.isTraceEnabled() && is != null) {
                log.trace("Found classpath resource at '{}'", (Object)name);
            }
            if (is != null && (name.toLowerCase().contains(".gz") || name.toLowerCase().contains(".gzip"))) {
                log.trace("Classpath resource '{}' ending indicates a GZIP resource, ungzipping is added", (Object)name);
                is = new GZIPInputStream(is);
            }
        }
        if (log.isTraceEnabled() && is == null) {
            log.trace("The resource '{}' could not be found as a file, URI or on the classpath. Returning null.", (Object)name);
        }
        return is;
    }
}

