/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.cache;

import de.julielab.java.utilities.cache.CacheAccess;
import de.julielab.java.utilities.cache.CacheConfiguration;
import de.julielab.java.utilities.cache.CacheMapSettings;
import de.julielab.java.utilities.cache.LocalFileCacheAccess;
import de.julielab.java.utilities.cache.NoOpCacheAccess;
import de.julielab.java.utilities.cache.RemoteCacheAccess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.serializer.GroupSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheService {
    public static final String CACHING_ENABLED_PROP = "de.julielab.java.utilities.cache.enabled";
    private static final Logger log = LoggerFactory.getLogger(CacheService.class);
    private static CacheService service;
    private Map<String, DB> dbs = new HashMap<String, DB>();
    private Set<String> readOnly = new HashSet<String>();
    private CacheConfiguration configuration;
    private List<CacheAccess<?, ?>> cacheAccesses = new ArrayList();

    private CacheService(CacheConfiguration configuration) {
        this.configuration = configuration;
    }

    public static synchronized CacheService getInstance() {
        boolean cachingEnabled;
        String propertyValue = System.getProperty(CACHING_ENABLED_PROP);
        boolean bl = cachingEnabled = propertyValue == null || Boolean.parseBoolean(propertyValue);
        if (cachingEnabled && service == null) {
            throw new IllegalStateException("Call 'initialize' before acquiring an instance of the CacheService.");
        }
        if (!cachingEnabled) {
            service = new CacheService(null);
            return service;
        }
        return service;
    }

    public static synchronized void initialize(CacheConfiguration configuration) {
        if (service == null) {
            service = new CacheService(configuration);
        }
    }

    public <K, V> CacheAccess<K, V> getCacheAccess(String cacheId, String cacheRegion, String keySerializerName, String valueSerializerName) {
        return this.getCacheAccess(cacheId, cacheRegion, keySerializerName, valueSerializerName, 100L);
    }

    public <K, V> CacheAccess<K, V> getCacheAccess(String cacheId, String cacheRegion, String keySerializerName, String valueSerializerName, long memCacheSize) {
        CacheAccess ret;
        String propertyValue = System.getProperty(CACHING_ENABLED_PROP);
        if (propertyValue != null && !Boolean.parseBoolean(propertyValue)) {
            return new NoOpCacheAccess(cacheId, cacheRegion);
        }
        switch (this.configuration.getCacheType()) {
            case LOCAL: {
                ret = new LocalFileCacheAccess(cacheId, cacheRegion, keySerializerName, valueSerializerName, this.configuration.getLocalCacheDir(), memCacheSize);
                break;
            }
            case REMOTE: {
                ret = new RemoteCacheAccess(cacheId, cacheRegion, keySerializerName, valueSerializerName, this.configuration.getRemoteCacheHost(), this.configuration.getRemoteCachePort(), memCacheSize);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown cache type '" + (Object)((Object)this.configuration.getCacheType()) + "' in the configuration.");
            }
        }
        this.cacheAccesses.add(ret);
        return ret;
    }

    public <K, V> CacheAccess<K, V> getCacheAccess(String cacheId, String cacheRegion, String keySerializerName, String valueSerializerName, CacheMapSettings mapSettings) {
        CacheAccess ret;
        String propertyValue = System.getProperty(CACHING_ENABLED_PROP);
        if (propertyValue != null && !Boolean.parseBoolean(propertyValue)) {
            return new NoOpCacheAccess(cacheId, cacheRegion);
        }
        switch (this.configuration.getCacheType()) {
            case LOCAL: {
                ret = new LocalFileCacheAccess(cacheId, cacheRegion, keySerializerName, valueSerializerName, this.configuration.getLocalCacheDir(), mapSettings);
                break;
            }
            case REMOTE: {
                ret = new RemoteCacheAccess(cacheId, cacheRegion, keySerializerName, valueSerializerName, this.configuration.getRemoteCacheHost(), this.configuration.getRemoteCachePort(), (Long)mapSettings.get("memCacheSize"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown cache type '" + (Object)((Object)this.configuration.getCacheType()) + "' in the configuration.");
            }
        }
        this.cacheAccesses.add(ret);
        return ret;
    }

    boolean isDbReadOnly(File file) {
        try {
            return this.readOnly.contains(file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    synchronized void commitCache(File dbFile) {
        if (!this.isDbReadOnly(dbFile)) {
            try {
                if (this.dbs.containsKey(dbFile.getCanonicalPath())) {
                    this.dbs.get(dbFile.getCanonicalPath()).commit();
                }
            }
            catch (IOException e) {
                log.error("Could not commit db at {}.", (Object)dbFile, (Object)e);
            }
        } else {
            log.debug("Cannot commit cache {} because it is read-only.", (Object)dbFile);
        }
    }

    <K, V> BTreeMap<K, V> getBTreeCache(File dbFile, String regionName, GroupSerializer<K> keySerializer, GroupSerializer<V> valueSerializer, Map<String, Object> mapSettings) {
        DB db = mapSettings.get("persistenceType") == CachePersistenceType.MEM ? this.getMemdb(dbFile.getName()) : this.getFiledb(dbFile, true);
        DB.TreeMapMaker dbmaker = db.treeMap(regionName).keySerializer(keySerializer).valueSerializer(valueSerializer);
        Iterator<String> iterator = mapSettings.keySet().iterator();
        while (iterator.hasNext()) {
            String setting;
            switch (setting = iterator.next()) {
                case "enableSizeCount": {
                    if (!((Boolean)mapSettings.get("enableSizeCount")).booleanValue()) break;
                    dbmaker.counterEnable();
                    break;
                }
                case "maxNodeSize": {
                    dbmaker.maxNodeSize(((Integer)mapSettings.get("maxNodeSize")).intValue());
                }
            }
        }
        if (this.isDbReadOnly(dbFile)) {
            return dbmaker.open();
        }
        return dbmaker.createOrOpen();
    }

    <K, V> HTreeMap<K, V> getHTreeCache(File dbFile, String regionName, GroupSerializer<K> keySerializer, GroupSerializer<V> valueSerializer, Map<String, Object> mapSettings) {
        boolean transactionsSupported = mapSettings.get("maxStoreSize") == null;
        DB db = mapSettings.get("persistenceType") == CachePersistenceType.MEM ? this.getMemdb(dbFile.getName()) : this.getFiledb(dbFile, transactionsSupported);
        DB.HashMapMaker dbmaker = db.hashMap(regionName).keySerializer(keySerializer).valueSerializer(valueSerializer);
        Iterator<String> iterator = mapSettings.keySet().iterator();
        while (iterator.hasNext()) {
            String setting;
            switch (setting = iterator.next()) {
                case "maxSize": {
                    if (mapSettings.get("expireAfterCreate") == null && mapSettings.get("expireAfterGet") == null && mapSettings.get("expireAfterUpdate") == null) {
                        log.warn("A maximum cache size is given but no trigger (after create, get or update) that would enqueue elements for eviction has been specified. Eviction will not happen.");
                    }
                    dbmaker.expireMaxSize(((Long)mapSettings.get("maxSize")).longValue());
                    break;
                }
                case "overflowDb": {
                    if (mapSettings.get("expireAfterCreate") == null && mapSettings.get("expireAfterGet") == null && mapSettings.get("expireAfterUpdate") == null) {
                        log.warn("An expiration overflow map is given but no trigger (after create, get or update) that would enqueue elements for eviction has been specified. Overflow will not happen.");
                    }
                    dbmaker.expireOverflow((Map)mapSettings.get("overflowDb"));
                    break;
                }
                case "expireExecutor": {
                    dbmaker.expireExecutor((ScheduledExecutorService)mapSettings.get("expireExecutor"));
                    break;
                }
                case "expireExecutorPeriod": {
                    dbmaker.expireExecutorPeriod(((Long)mapSettings.get("expireExecutorPeriod")).longValue());
                    break;
                }
                case "expireAfterCreate": {
                    if (Boolean.parseBoolean(String.valueOf(mapSettings.get("expireAfterCreate")))) {
                        dbmaker.expireAfterCreate();
                        break;
                    }
                    dbmaker.expireAfterCreate(((Long)mapSettings.get("expireAfterCreate")).longValue());
                    break;
                }
                case "expireAfterGet": {
                    if (Boolean.parseBoolean(String.valueOf(mapSettings.get("expireAfterGet")))) {
                        dbmaker.expireAfterGet();
                        break;
                    }
                    dbmaker.expireAfterGet(((Long)mapSettings.get("expireAfterGet")).longValue());
                    break;
                }
                case "expireAfterUpdate": {
                    if (Boolean.parseBoolean(String.valueOf(mapSettings.get("expireAfterUpdate")))) {
                        dbmaker.expireAfterUpdate();
                        break;
                    }
                    dbmaker.expireAfterUpdate(((Long)mapSettings.get("expireAfterUpdate")).longValue());
                    break;
                }
                case "maxStoreSize": {
                    if (mapSettings.get("expireAfterCreate") == null && mapSettings.get("expireAfterGet") == null && mapSettings.get("expireAfterUpdate") == null) {
                        log.warn("A maximum cache store size is given but no trigger (after create, get or update) that would enqueue elements for eviction has been specified. Overflow will not happen.");
                    }
                    dbmaker.expireStoreSize(((Long)mapSettings.get("maxStoreSize")).longValue());
                }
            }
        }
        if (this.isDbReadOnly(dbFile)) {
            return dbmaker.open();
        }
        return dbmaker.createOrOpen();
    }

    <K, V> HTreeMap<K, V> getHTreeCache(File dbFile, String regionName, GroupSerializer<K> keySerializer, GroupSerializer<V> valueSerializer) {
        return this.getHTreeCache(dbFile, regionName, keySerializer, valueSerializer, Collections.emptyMap());
    }

    <K, V> HTreeMap<K, V> getCache(File dbFile, String regionName, GroupSerializer<K> keySerializer, GroupSerializer<V> valueSerializer) {
        return this.getHTreeCache(dbFile, regionName, keySerializer, valueSerializer);
    }

    public void commitAllCaches() {
        this.cacheAccesses.stream().filter(ca -> !ca.isClosed()).forEach(CacheAccess::commit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DB getFiledb(File cacheDir, boolean transactionsSupported) {
        try {
            DB db = this.dbs.get(cacheDir.getCanonicalPath());
            if (db == null || db.isClosed() || db.getStore().isClosed()) {
                CacheService cacheService = this;
                synchronized (cacheService) {
                    if (!this.dbs.containsKey(cacheDir.getCanonicalPath()) || db.isClosed() || db.getStore().isClosed()) {
                        DBMaker.Maker dbmaker = DBMaker.fileDB((String)cacheDir.getAbsolutePath()).fileMmapEnable().closeOnJvmShutdown();
                        if (transactionsSupported) {
                            dbmaker.transactionEnable();
                        }
                        if (this.configuration.getCacheType() == CacheType.LOCAL && this.configuration.isReadOnly() && cacheDir.exists()) {
                            dbmaker.readOnly();
                            this.readOnly.add(cacheDir.getCanonicalPath());
                        }
                        db = dbmaker.make();
                        this.dbs.put(cacheDir.getCanonicalPath(), db);
                    } else {
                        db = this.dbs.get(cacheDir.getCanonicalPath());
                    }
                }
            }
            return db;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DB getMemdb(String name) {
        DB db = this.dbs.get(name);
        if (db == null || db.isClosed()) {
            CacheService cacheService = this;
            synchronized (cacheService) {
                if (!this.dbs.containsKey(name) || db.isClosed()) {
                    DBMaker.Maker dbmaker = DBMaker.memoryDB().closeOnJvmShutdown();
                    db = dbmaker.make();
                    this.dbs.put(name, db);
                } else {
                    db = this.dbs.get(name);
                }
            }
        }
        return db;
    }

    public static enum CachePersistenceType {
        MEM,
        DISC;

    }

    public static enum CacheMapDataType {
        HTREE,
        BTREE;

    }

    public static enum CacheType {
        LOCAL,
        REMOTE;

    }
}

