/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.cache;

import de.julielab.java.utilities.cache.CacheAccess;
import de.julielab.java.utilities.cache.CacheMapSettings;
import de.julielab.java.utilities.cache.CacheService;
import java.io.File;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.mapdb.BTreeMap;
import org.mapdb.HTreeMap;
import org.mapdb.serializer.GroupSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileCacheAccess<K, V>
extends CacheAccess<K, V> {
    private static final Logger log = LoggerFactory.getLogger(LocalFileCacheAccess.class);
    private final CacheService cacheService;
    private final File cacheFile;
    private final File cacheDir;
    private Map<K, V> cache;
    private final Map<K, V> persistentCache;
    private boolean hasMemCache;

    public LocalFileCacheAccess(String cacheId, String cacheRegion, String keySerializer, String valueSerializer, File cacheDir) {
        this(cacheId, cacheRegion, keySerializer, valueSerializer, cacheDir, 100L);
    }

    public LocalFileCacheAccess(String cacheId, String cacheRegion, String keySerializer, String valueSerializer, File cacheDir, CacheMapSettings mapSettings) {
        super(cacheId, cacheRegion);
        GroupSerializer keySerializer1 = LocalFileCacheAccess.getSerializerByName(keySerializer);
        GroupSerializer valueSerializer1 = LocalFileCacheAccess.getSerializerByName(valueSerializer);
        this.cacheDir = cacheDir;
        this.cacheService = CacheService.getInstance();
        this.cacheFile = new File(this.getCacheDir(), cacheId);
        boolean usePersistentCache = mapSettings.getOrDefault("usePersistentCache", true);
        Long memCacheSize = (Long)((Object)mapSettings.getOrDefault("memCacheSize", 0));
        if (!usePersistentCache && memCacheSize == 0L) {
            log.warn("Cache {}:{}: The cache settings do not specify the usage of a persistent cache and the in-memory cache is set to size 0 which deactivates it. There is no caching.", (Object)cacheId, (Object)cacheRegion);
            this.cache = new AbstractMap<K, V>(){

                @Override
                @NotNull
                public Set<Map.Entry<K, V>> entrySet() {
                    return null;
                }

                @Override
                public V put(K key, V value) {
                    return null;
                }

                @Override
                public void putAll(Map<? extends K, ? extends V> m) {
                }

                @Override
                public V get(Object key) {
                    return null;
                }
            };
        }
        if (usePersistentCache) {
            this.cache = mapSettings.get("mapType") == CacheService.CacheMapDataType.HTREE ? this.cacheService.getHTreeCache(this.cacheFile, cacheRegion, keySerializer1, valueSerializer1, mapSettings) : this.cacheService.getBTreeCache(this.cacheFile, cacheRegion, keySerializer1, valueSerializer1, mapSettings);
        }
        this.persistentCache = this.cache;
        if (memCacheSize > 0L) {
            File memCacheName = new File(cacheId + ".mem");
            CacheMapSettings memCacheSettings = new CacheMapSettings(new Object[]{"persistenceType", CacheService.CachePersistenceType.MEM, "expireAfterCreate", true, "maxSize", memCacheSize});
            if (this.persistentCache != null) {
                memCacheSettings.put("overflowDb", this.cache);
            }
            this.cache = this.cacheService.getHTreeCache(memCacheName, cacheRegion + ".mem", keySerializer1, valueSerializer1, memCacheSettings);
            this.hasMemCache = true;
        }
    }

    public LocalFileCacheAccess(String cacheId, String cacheRegion, String keySerializer, String valueSerializer, File cacheDir, long memCacheSize) {
        this(cacheId, cacheRegion, keySerializer, valueSerializer, cacheDir, new CacheMapSettings("memCacheSize", memCacheSize));
    }

    public Map<K, V> getCache() {
        return this.cache;
    }

    private File getCacheDir() {
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
        return this.cacheDir;
    }

    @Override
    public V get(K key) {
        V value = null;
        if (value == null) {
            value = this.cache.get(key);
        }
        return value;
    }

    @Override
    public void commit() {
        if (this.hasMemCache && this.persistentCache != null) {
            for (K key : this.cache.keySet()) {
                if (this.persistentCache.containsKey(key)) continue;
                this.persistentCache.put(key, this.cache.get(key));
            }
        }
        this.cacheService.commitCache(this.cacheFile);
    }

    @Override
    public boolean put(K key, V value) {
        if (!this.cacheService.isDbReadOnly(this.cacheFile)) {
            this.cache.put(key, value);
            return true;
        }
        log.debug("Could not write value to cache {} because it is read-only.", (Object)this.cacheFile);
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.cacheService.isDbReadOnly(this.cacheFile);
    }

    @Override
    public boolean isClosed() {
        if (this.cache instanceof HTreeMap) {
            return ((HTreeMap)this.cache).isClosed();
        }
        if (this.cache instanceof BTreeMap) {
            return ((BTreeMap)this.cache).isClosed();
        }
        log.error("Unhandled cache map class {}", (Object)this.cache.getClass());
        return false;
    }

    public void close() {
        if (this.cache instanceof HTreeMap) {
            ((HTreeMap)this.cache).close();
        } else if (this.cache instanceof BTreeMap) {
            ((BTreeMap)this.cache).close();
        }
        if (this.persistentCache != null) {
            if (this.persistentCache instanceof HTreeMap) {
                ((HTreeMap)this.persistentCache).close();
            } else if (this.persistentCache instanceof BTreeMap) {
                ((BTreeMap)this.persistentCache).close();
            }
        }
    }
}

