/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.spanutils;

import de.julielab.java.utilities.spanutils.OffsetRangeComparator;
import de.julielab.java.utilities.spanutils.Span;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.Range;

public class OffsetMap<V>
extends TreeMap<Range<Integer>, V> {
    private static final OffsetMap<?> EMPTY_OFFSET_MAP = new OffsetMap();
    private static final long serialVersionUID = 8336911838492274123L;

    public OffsetMap() {
        super(new OffsetRangeComparator());
    }

    public OffsetMap(SortedMap<Range<Integer>, ? extends V> other) {
        super(other);
    }

    public OffsetMap(Iterable<? extends Span> items) {
        this();
        items.forEach(this::put);
    }

    public NavigableMap<Range<Integer>, V> restrictTo(Range<Integer> range) {
        Range<Integer> begin = Range.between(range.getMinimum(), range.getMinimum());
        Range<Integer> end = Range.between(range.getMaximum(), range.getMaximum());
        return this.subMap(begin, true, end, true);
    }

    public NavigableMap<Range<Integer>, V> restrictTo(Span range) {
        return this.restrictTo(range.getOffsets());
    }

    public NavigableMap<Range<Integer>, V> getOverlapping(Span range) {
        return this.getOverlapping(range.getOffsets());
    }

    public NavigableMap<Range<Integer>, V> getOverlapping(Range<Integer> range) {
        if (this.isEmpty()) {
            return OffsetMap.emptyOffsetMap();
        }
        Range<Integer> begin = Range.between(range.getMinimum(), range.getMinimum());
        Range<Integer> end = Range.between(range.getMaximum(), range.getMaximum());
        Map.Entry floor = this.floorEntry(begin);
        Map.Entry ceiling = this.ceilingEntry(end);
        if (floor == null) {
            floor = this.firstEntry();
        }
        if (ceiling == null) {
            ceiling = this.lastEntry();
        }
        TreeMap subMap = new TreeMap(this.subMap(floor.getKey(), true, ceiling.getKey(), true));
        Range firstKey = (Range)subMap.firstKey();
        Range lastKey = (Range)subMap.lastKey();
        if ((Integer)firstKey.getMaximum() <= range.getMinimum()) {
            subMap.remove(firstKey);
        }
        if (subMap.isEmpty()) {
            return OffsetMap.emptyOffsetMap();
        }
        if ((Integer)lastKey.getMinimum() >= range.getMaximum()) {
            subMap.remove(lastKey);
        }
        return subMap;
    }

    public static <V> OffsetMap<V> emptyOffsetMap() {
        return EMPTY_OFFSET_MAP;
    }

    public V put(Span span) {
        return (V)this.put(span.getOffsets(), span);
    }

    public V getFirstLargestIntersectionValue(Range<Integer> range) {
        NavigableMap<Range<Integer>, V> overlapping = this.getOverlapping(range);
        Range largestOverlap = null;
        int largestLength = 0;
        for (Range key : overlapping.keySet()) {
            Range<Integer> intersection = key.intersectionWith(range);
            int length = intersection.getMaximum() - intersection.getMinimum();
            if (largestOverlap != null && largestLength >= length) continue;
            largestOverlap = key;
            largestLength = length;
        }
        return largestOverlap != null ? (V)overlapping.get(largestOverlap) : null;
    }

    public V getFirstLargestOverlappingValue(Range<Integer> range) {
        NavigableMap<Range<Integer>, V> overlapping = this.getOverlapping(range);
        Range largestOverlap = null;
        int largestLength = 0;
        for (Range key : overlapping.keySet()) {
            int length = (Integer)key.getMaximum() - (Integer)key.getMinimum();
            if (largestOverlap != null && largestLength >= length) continue;
            largestOverlap = key;
            largestLength = length;
        }
        return largestOverlap != null ? (V)overlapping.get(largestOverlap) : null;
    }
}

