/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised;

import cc.mallet.fst.CRF;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.semi_supervised.EntropyLattice;
import cc.mallet.optimize.Optimizable;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.io.Serializable;
import java.util.logging.Logger;

public class CRFOptimizableByEntropyRegularization
implements Optimizable.ByGradientValue,
Serializable {
    private static Logger logger = MalletLogger.getLogger(CRFOptimizableByEntropyRegularization.class.getName());
    private int cachedValueWeightsStamp = -1;
    private int cachedGradientWeightsStamp = -1;
    protected CRF.Factors expectations;
    protected Transducer.Incrementor incrementor;
    protected InstanceList data;
    protected CRF crf;
    protected double scalingFactor;
    protected double cachedValue;
    protected double[] cachedGradient;
    private static final long serialVersionUID = 1L;

    public CRFOptimizableByEntropyRegularization(CRF crf, InstanceList ilist, double scalingFactor) {
        this.data = ilist;
        this.crf = crf;
        this.scalingFactor = scalingFactor;
        this.expectations = new CRF.Factors(crf);
        this.incrementor = new CRF.Factors.Incrementor(this.expectations);
        this.cachedValue = 0.0;
        this.cachedGradient = new double[crf.getParameters().getNumFactors()];
    }

    public CRFOptimizableByEntropyRegularization(CRF crf, InstanceList ilist) {
        this(crf, ilist, 1.0);
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(double scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public void computeExpectations() {
        this.expectations.zero();
        for (int ii = 0; ii < this.data.size(); ++ii) {
            FeatureVectorSequence input = (FeatureVectorSequence)((Instance)this.data.get(ii)).getData();
            SumLatticeDefault lattice = new SumLatticeDefault((Transducer)this.crf, (Sequence)input, true);
            EntropyLattice entropyLattice = new EntropyLattice(input, lattice.getGammas(), lattice.getXis(), this.crf, this.incrementor, this.scalingFactor);
            this.cachedValue += entropyLattice.getEntropy();
        }
    }

    @Override
    public double getValue() {
        if (this.crf.getWeightsValueChangeStamp() != this.cachedValueWeightsStamp) {
            this.cachedValueWeightsStamp = this.crf.getWeightsValueChangeStamp();
            this.cachedValue = 0.0;
            this.computeExpectations();
            this.cachedValue = this.scalingFactor * this.cachedValue;
            assert (!Double.isNaN(this.cachedValue) && !Double.isInfinite(this.cachedValue)) : "Likelihood due to Entropy Regularization is NaN/Infinite";
            logger.info("getValue() (entropy regularization) = " + this.cachedValue);
        }
        return this.cachedValue;
    }

    @Override
    public void getValueGradient(double[] buffer) {
        if (this.cachedGradientWeightsStamp != this.crf.getWeightsValueChangeStamp()) {
            this.cachedGradientWeightsStamp = this.crf.getWeightsValueChangeStamp();
            this.getValue();
            this.expectations.assertNotNaNOrInfinite();
            this.expectations.getParameters(this.cachedGradient);
        }
        System.arraycopy(this.cachedGradient, 0, buffer, 0, this.cachedGradient.length);
    }

    @Override
    public int getNumParameters() {
        return this.crf.getParameters().getNumFactors();
    }

    @Override
    public void getParameters(double[] buffer) {
        this.crf.getParameters().getParameters(buffer);
    }

    @Override
    public void setParameters(double[] buffer) {
        this.crf.getParameters().setParameters(buffer);
        this.crf.weightsValueChanged();
    }

    @Override
    public double getParameter(int index) {
        return this.crf.getParameters().getParameter(index);
    }

    @Override
    public void setParameter(int index, double value) {
        this.crf.getParameters().setParameter(index, value);
        this.crf.weightsValueChanged();
    }
}

