/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics;

import cc.mallet.topics.WordEmbeddings;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.util.Random;

public class WordEmbeddingRunnable
implements Runnable {
    public WordEmbeddings model;
    public InstanceList instances;
    public int numSamples;
    public boolean shouldRun = true;
    double residual = 0.0;
    int numUpdates = 0;
    int numThreads;
    int threadID;
    int stride;
    public int docID;
    public Random random;
    int numColumns;
    public int wordsSoFar = 0;

    public WordEmbeddingRunnable(WordEmbeddings model, InstanceList instances, int numSamples, int numThreads, int threadID) {
        this.model = model;
        this.stride = model.stride;
        this.instances = instances;
        this.numSamples = numSamples;
        this.numThreads = numThreads;
        this.threadID = threadID;
        this.random = new Random();
        this.numColumns = model.numColumns;
    }

    public double getMeanError() {
        if (this.numUpdates == 0) {
            return this.docID;
        }
        double result = this.residual / (double)this.numUpdates;
        this.residual = 0.0;
        this.numUpdates = 0;
        return result;
    }

    @Override
    public void run() {
        int numDocuments = this.instances.size();
        double sampleNormalizer = 1.0f / (float)this.numSamples;
        double[] gradient = new double[this.numColumns];
        int queryID = this.model.vocabulary.lookupIndex(this.model.queryWord);
        int outputOffset = this.model.numColumns;
        this.docID = this.threadID * (numDocuments / this.numThreads);
        int maxDocID = (this.threadID + 1) * (numDocuments / this.numThreads);
        if (maxDocID > numDocuments) {
            maxDocID = numDocuments;
        }
        double cacheScale = 1.0 / (this.model.maxExpValue - this.model.minExpValue);
        int[] tokenBuffer = new int[100000];
        while (this.shouldRun) {
            int inputType;
            int inputPosition;
            Instance instance = (Instance)this.instances.get(this.docID);
            ++this.docID;
            if (this.docID == maxDocID) {
                this.docID = this.threadID * (numDocuments / this.numThreads);
            }
            double learningRate = Math.max(1.0E-4, 0.025 * (1.0 - (double)this.numThreads * (double)this.wordsSoFar / (double)this.model.totalWords));
            FeatureSequence tokens = (FeatureSequence)instance.getData();
            int originalLength = tokens.getLength();
            int length = 0;
            for (inputPosition = 0; inputPosition < originalLength; ++inputPosition) {
                inputType = tokens.getIndexAtPosition(inputPosition);
                ++this.wordsSoFar;
                double frequencyScore = (double)this.model.wordCounts[inputType] / (1.0E-4 * (double)this.model.totalWords);
                if (!(this.random.nextDouble() < (Math.sqrt(frequencyScore) + 1.0) / frequencyScore)) continue;
                tokenBuffer[length] = inputType;
                ++length;
            }
            if (length < 10) continue;
            for (inputPosition = 0; inputPosition < length; ++inputPosition) {
                inputType = tokenBuffer[inputPosition];
                int subWindow = this.model.windowSize;
                int start = Math.max(0, inputPosition - subWindow);
                int end = Math.min(length - 1, inputPosition + subWindow);
                for (int outputPosition = start; outputPosition <= end; ++outputPosition) {
                    int outputType;
                    if (inputPosition == outputPosition || inputType == (outputType = tokenBuffer[outputPosition])) continue;
                    double innerProduct = this.model.weights[inputType * this.stride + 0] + this.model.weights[inputType * this.stride + outputOffset];
                    for (int col = 1; col < this.numColumns; ++col) {
                        innerProduct += this.model.weights[inputType * this.stride + col] * this.model.weights[outputType * this.stride + outputOffset + col];
                    }
                    double prediction = innerProduct < this.model.minExpValue ? 0.0 : (innerProduct > this.model.maxExpValue ? 1.0 : this.model.sigmoidCache[(int)Math.floor((double)this.model.sigmoidCacheSize * (innerProduct - this.model.minExpValue) * cacheScale)]);
                    gradient[0] = 1.0 - prediction;
                    int n = outputType * this.stride + outputOffset;
                    this.model.weights[n] = this.model.weights[n] + learningRate * (1.0 - prediction);
                    for (int col = 1; col < this.numColumns; ++col) {
                        gradient[col] = (1.0 - prediction) * this.model.weights[outputType * this.stride + outputOffset + col];
                        int n2 = outputType * this.stride + outputOffset + col;
                        this.model.weights[n2] = this.model.weights[n2] + learningRate * ((1.0 - prediction) * this.model.weights[inputType * this.stride + col]);
                    }
                    double meanNegativePrediction = 0.0;
                    for (int sample = 0; sample < this.numSamples; ++sample) {
                        int sampledType = this.model.samplingTable[this.random.nextInt(this.model.samplingTableSize)];
                        int sampledTypeOffset = sampledType * this.stride;
                        innerProduct = this.model.weights[inputType * this.stride + 0] + this.model.weights[sampledTypeOffset + outputOffset];
                        for (int col = 0; col < this.numColumns; ++col) {
                            innerProduct += this.model.weights[inputType * this.stride + col] * this.model.weights[sampledTypeOffset + outputOffset + col];
                        }
                        double negativePrediction = 0.0;
                        negativePrediction = innerProduct < this.model.minExpValue ? 0.0 : (innerProduct > this.model.maxExpValue ? 1.0 : this.model.sigmoidCache[(int)Math.floor((double)this.model.sigmoidCacheSize * (innerProduct - this.model.minExpValue) * cacheScale)]);
                        meanNegativePrediction += negativePrediction;
                        gradient[0] = gradient[0] + sampleNormalizer * -negativePrediction;
                        int n3 = sampledTypeOffset + outputOffset;
                        this.model.weights[n3] = this.model.weights[n3] + learningRate * sampleNormalizer * -negativePrediction;
                        for (int col = 1; col < this.numColumns; ++col) {
                            int n4 = col;
                            gradient[n4] = gradient[n4] + sampleNormalizer * (-negativePrediction * this.model.weights[sampledType * this.stride + outputOffset + col]);
                            int n5 = sampledTypeOffset + outputOffset + col;
                            this.model.weights[n5] = this.model.weights[n5] + learningRate * sampleNormalizer * (-negativePrediction * this.model.weights[inputType * this.stride + col]);
                        }
                    }
                    this.residual += prediction - meanNegativePrediction * sampleNormalizer;
                    ++this.numUpdates;
                    for (int col = 0; col < this.numColumns; ++col) {
                        int n6 = inputType * this.stride + col;
                        this.model.weights[n6] = this.model.weights[n6] + learningRate * gradient[col];
                    }
                }
            }
        }
    }
}

