/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.cache;

import de.julielab.java.utilities.cache.CacheAccess;
import de.julielab.java.utilities.cache.CacheConfiguration;
import de.julielab.java.utilities.cache.CacheService;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mapdb.HTreeMap;
import org.mapdb.serializer.GroupSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheServer {
    public static final String METHOD_GET = "get";
    public static final String METHOD_PUT = "put";
    public static final String RESPONSE_OK = "OK";
    public static final String RESPONSE_FAILURE = "FAILURE";
    private static final Logger log = LoggerFactory.getLogger(CacheServer.class);
    private final File cacheDir;
    private final String host;
    private final int port;
    private final ExecutorService executorService;
    private Thread backgroundThread;

    public CacheServer(File cacheDir, String host, int port) {
        this.cacheDir = cacheDir;
        this.host = host;
        this.port = port;
        CacheService.initialize(new CacheConfiguration(CacheService.CacheType.REMOTE, null, host, port, false));
        this.executorService = Executors.newCachedThreadPool();
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
    }

    public static void main(String[] args) throws IOException {
        File cacheDir = new File(args[0]);
        String host = args[1];
        int port = Integer.valueOf(args[2]);
        log.info("Starting logger with cacheDir {}, host {} and port {}", cacheDir, host, port);
        CacheServer cacheServer = new CacheServer(cacheDir, host, port);
        cacheServer.run();
    }

    public void run() throws IOException {
        ServerSocket serverSocket = new ServerSocket(this.port, 1000, InetAddress.getByName(this.host));
        try {
            log.info("CacheServer ready for requests.");
            while (true) {
                Socket socket = serverSocket.accept();
                log.debug("Handling new incoming connection");
                this.executorService.submit(new RequestServer(socket));
            }
        }
        catch (Throwable throwable) {
            try {
                serverSocket.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void runInBackground() {
        if (this.backgroundThread != null) {
            throw new IllegalStateException("Background thread for caching server is already running.");
        }
        this.backgroundThread = new Thread(){

            @Override
            public void interrupt() {
                super.interrupt();
                log.trace("Terminating background cache server thread.");
            }

            @Override
            public void run() {
                try {
                    CacheServer.this.run();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        log.debug("Starting background thread for caching server");
        this.backgroundThread.start();
    }

    public void shutdown() {
        log.info("Shutting down cache server.");
        CacheService.shutdown();
        if (this.backgroundThread != null) {
            this.backgroundThread.interrupt();
        }
        this.executorService.shutdown();
    }

    private class RequestServer
    extends Thread {
        private final Socket socket;

        public RequestServer(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CacheService cacheService = CacheService.getInstance();
            log.trace("Establishing connection to requesting client");
            try (ObjectInputStream ois = new ObjectInputStream(this.socket.getInputStream());){
                ObjectOutputStream oos = new ObjectOutputStream(this.socket.getOutputStream());
                try {
                    while (true) {
                        try {
                            while (true) {
                                log.trace("Reading request data.");
                                String method = ois.readUTF();
                                String cacheName = ois.readUTF();
                                String cacheRegion = ois.readUTF();
                                String keySerializerName = ois.readUTF();
                                String valueSerializerName = ois.readUTF();
                                Object key = ois.readObject();
                                if (key != null) {
                                    Object value = null;
                                    if (method.equalsIgnoreCase(CacheServer.METHOD_PUT)) {
                                        value = ois.readObject();
                                    }
                                    GroupSerializer keySerializer = CacheAccess.getSerializerByName(keySerializerName);
                                    GroupSerializer valueSerializer = CacheAccess.getSerializerByName(valueSerializerName);
                                    File cacheFile = new File(CacheServer.this.cacheDir.getAbsolutePath(), cacheName);
                                    HTreeMap cache = cacheService.getCache(cacheFile, cacheRegion, keySerializer, valueSerializer);
                                    if (method.equalsIgnoreCase(CacheServer.METHOD_GET)) {
                                        Object o = cache.get(key);
                                        if (o != null) {
                                            log.trace("Returning data for key '{}' from cache {}, {}.", key, cacheName, cacheRegion);
                                        } else {
                                            log.trace("No cached data available for key '{}' in cache {}, {}.", key, cacheName, cacheRegion);
                                        }
                                        oos.writeObject(o);
                                        oos.flush();
                                        continue;
                                    }
                                    if (!method.equalsIgnoreCase(CacheServer.METHOD_PUT)) continue;
                                    if (log.isTraceEnabled()) {
                                        String valueString;
                                        String string = valueString = value == null ? null : value.toString();
                                        if (valueString != null) {
                                            valueString = valueString.substring(0, Math.min(valueString.length(), 79));
                                        }
                                        log.trace("Putting data '{}' for key '{}' into the cache {}, {}.", valueString, key, cacheName, cacheRegion);
                                    }
                                    cache.put(key, value);
                                    log.trace("Sending OK response");
                                    oos.writeUTF(CacheServer.RESPONSE_OK);
                                    oos.flush();
                                    continue;
                                }
                                CacheService.getInstance().commitAllCaches();
                            }
                        }
                        catch (SocketException e) {
                            if (e.getMessage().contains("Broken pipe")) {
                                log.debug("Client disconnected (Broken pipe).");
                                continue;
                            }
                            log.error("Connection error", e);
                            continue;
                        }
                        catch (Throwable e) {
                            log.error("Exception occurred. Sending an error message to the client and terminating the connection.", e);
                            try {
                                oos.writeUTF(CacheServer.RESPONSE_FAILURE);
                                oos.writeObject(e);
                                oos.flush();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            oos.close();
                            ois.close();
                            oos.close();
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        oos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    cacheService.commitAllCaches();
                    this.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

