/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility.index;

import de.julielab.jcore.utility.JCoReTools;
import de.julielab.jcore.utility.index.Comparators;
import de.julielab.jcore.utility.index.JCoReAnnotationIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class JCoReOverlapAnnotationIndex<E extends Annotation>
implements JCoReAnnotationIndex<E> {
    private List<E> beginIndex = new ArrayList();
    private List<E> endIndex = new ArrayList();
    private boolean frozen;

    public JCoReOverlapAnnotationIndex() {
    }

    public JCoReOverlapAnnotationIndex(JCas jcas, int type) {
        this(jcas, jcas.getCasType(type));
    }

    public JCoReOverlapAnnotationIndex(JCas jcas, Type type) {
        this();
        this.index(jcas, type);
        this.freeze();
    }

    @Override
    public void index(JCas jCas, int type) {
        this.index(jCas, jCas.getCasType(type));
    }

    @Override
    public void index(JCas jCas, Type type) {
        for (Annotation annotation : jCas.getAnnotationIndex(type)) {
            this.index((E)annotation);
        }
    }

    @Override
    public void index(E annotation) {
        if (this.frozen) {
            throw new IllegalStateException("This index is frozen and cannot accept further items.");
        }
        this.beginIndex.add(annotation);
        this.endIndex.add(annotation);
    }

    public void freeze() {
        this.frozen = true;
        Collections.sort(this.beginIndex, Comparators.beginOffsetComparator());
        Collections.sort(this.endIndex, Comparators.endOffsetComparator());
    }

    public <T extends Annotation> List<E> search(T a) {
        if (!this.frozen) {
            throw new IllegalStateException("This index is not frozen and cannot be used yet. Freeze the index before searching.");
        }
        if (this.beginIndex.isEmpty()) {
            return Collections.emptyList();
        }
        int begin = a.getBegin();
        int end = a.getEnd();
        int indexBeginAfterEnd = this.insertionPoint(JCoReTools.binarySearch(this.beginIndex, an -> an.getBegin(), end));
        int indexEndBeforeBegin = this.insertionPoint(JCoReTools.binarySearch(this.endIndex, an -> an.getEnd(), begin));
        if (indexBeginAfterEnd < this.endIndex.size() - indexEndBeforeBegin) {
            ArrayList<E> beginBeforeEnd = new ArrayList<E>(this.beginIndex.subList(0, indexBeginAfterEnd));
            ArrayList<Annotation> result = new ArrayList<Annotation>();
            for (Annotation e : beginBeforeEnd) {
                if (e.getEnd() <= begin) continue;
                result.add(e);
            }
            return result;
        }
        ArrayList<E> endAfterBegin = new ArrayList<E>(this.endIndex.subList(indexEndBeforeBegin, this.endIndex.size()));
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation e : endAfterBegin) {
            if (e.getBegin() >= end) continue;
            result.add(e);
        }
        return result;
    }

    private int insertionPoint(int i) {
        return i < 0 ? -(i + 1) : i;
    }

    public void melt() {
        this.frozen = false;
    }

    @Override
    public void add(E a) {
        this.index(a);
    }

    public List<E> getBeginIndex() {
        return this.beginIndex;
    }

    public List<E> getEndIndex() {
        return this.endIndex;
    }

    public boolean isFrozen() {
        return this.frozen;
    }
}

