/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatIterator;
import gnu.trove.TFloatProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class TFloatHashSet
extends TFloatHash
implements Externalizable {
    static final long serialVersionUID = 1L;

    public TFloatHashSet() {
    }

    public TFloatHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatHashSet(float[] array) {
        this(array.length);
        this.addAll(array);
    }

    public TFloatHashSet(TFloatHashingStrategy strategy) {
        super(strategy);
    }

    public TFloatHashSet(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TFloatHashSet(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TFloatHashSet(float[] array, TFloatHashingStrategy strategy) {
        this(array.length, strategy);
        this.addAll(array);
    }

    public TFloatIterator iterator() {
        return new TFloatIterator(this);
    }

    public boolean add(float val) {
        int index = this.insertionIndex(val);
        if (index < 0) {
            return false;
        }
        byte previousState = this._states[index];
        this._set[index] = val;
        this._states[index] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        float[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            float o = oldSet[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._states[index] = 1;
        }
    }

    public float[] toArray() {
        float[] result = new float[this.size()];
        float[] set = this._set;
        byte[] states = this._states;
        int i = states.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            result[j++] = set[i];
        }
        return result;
    }

    public void clear() {
        super.clear();
        float[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            set[i] = 0.0f;
            states[i] = 0;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatHashSet)) {
            return false;
        }
        final TFloatHashSet that = (TFloatHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TFloatProcedure(){

            public final boolean execute(float value) {
                return that.contains(value);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean remove(float val) {
        int index = this.index(val);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsAll(float[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(float[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(float[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.remove(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(float[] array) {
        boolean changed = false;
        Arrays.sort(array);
        float[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || Arrays.binarySearch(array, set[i]) >= 0) continue;
            this.remove(set[i]);
            changed = true;
        }
        return changed;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(out);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            float val = in.readFloat();
            this.add(val);
        }
    }

    private final class HashProcedure
    implements TFloatProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float key) {
            this.h += TFloatHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

