/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.tui;

import cc.mallet.classify.Classifier;
import cc.mallet.pipe.iterator.CsvIterator;
import cc.mallet.types.Instance;
import cc.mallet.types.Labeling;
import cc.mallet.util.CommandOption;
import cc.mallet.util.MalletLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Csv2Classify {
    private static Logger logger = MalletLogger.getLogger(Csv2Classify.class.getName());
    static CommandOption.File inputFile = new CommandOption.File(Csv2Classify.class, "input", "FILE", true, null, "The file containing data to be classified, one instance per line", null);
    static CommandOption.File outputFile = new CommandOption.File(Csv2Classify.class, "output", "FILE", true, new File("output"), "Write predictions to this file; Using - indicates stdout.", null);
    static CommandOption.String lineRegex = new CommandOption.String(Csv2Classify.class, "line-regex", "REGEX", true, "^(\\S*)[\\s,]*(.*)$", "Regular expression containing regex-groups for label, name and data.", null);
    static CommandOption.Integer nameOption = new CommandOption.Integer(Csv2Classify.class, "name", "INTEGER", true, 1, "The index of the group containing the instance name.\n   Use 0 to indicate that the name field is not used.", null);
    static CommandOption.Integer dataOption = new CommandOption.Integer(Csv2Classify.class, "data", "INTEGER", true, 2, "The index of the group containing the data.", null);
    static CommandOption.File classifierFile = new CommandOption.File(Csv2Classify.class, "classifier", "FILE", true, new File("classifier"), "Use the pipe and alphabets from a previously created vectors file.\n   Allows the creation, for example, of a test set of vectors that are\n   compatible with a previously created set of training vectors", null);
    static CommandOption.String encoding = new CommandOption.String(Csv2Classify.class, "encoding", "STRING", true, Charset.defaultCharset().displayName(), "Character encoding for input file", null);

    public static void main(String[] args) throws FileNotFoundException, IOException {
        CommandOption.setSummary(Csv2Classify.class, "A tool for classifying a stream of unlabeled instances");
        CommandOption.process(Csv2Classify.class, args);
        if (args.length == 0) {
            CommandOption.getList(Csv2Classify.class).printUsage(false);
            System.exit(-1);
        }
        if (inputFile == null) {
            throw new IllegalArgumentException("You must include `--input FILE ...' in order to specify afile containing the instances, one per line.");
        }
        Classifier classifier = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(Csv2Classify.classifierFile.value)));
            classifier = (Classifier)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Problem loading classifier from file " + Csv2Classify.classifierFile.value + ": " + e.getMessage());
        }
        InputStreamReader fileReader = Csv2Classify.inputFile.value.toString().equals("-") ? new InputStreamReader(System.in) : new InputStreamReader((InputStream)new FileInputStream(Csv2Classify.inputFile.value), Csv2Classify.encoding.value);
        CsvIterator csvIterator = new CsvIterator((Reader)fileReader, Pattern.compile(Csv2Classify.lineRegex.value), Csv2Classify.dataOption.value, 0, Csv2Classify.nameOption.value);
        Iterator<Instance> iterator = classifier.getInstancePipe().newIteratorFrom(csvIterator);
        PrintStream out = null;
        out = Csv2Classify.outputFile.value.toString().equals("-") ? System.out : new PrintStream(Csv2Classify.outputFile.value, Csv2Classify.encoding.value);
        classifier.getInstancePipe().getDataAlphabet().stopGrowth();
        classifier.getInstancePipe().getTargetAlphabet().stopGrowth();
        while (iterator.hasNext()) {
            Instance instance = iterator.next();
            Labeling labeling = classifier.classify(instance).getLabeling();
            StringBuilder output = new StringBuilder();
            output.append(instance.getName());
            int location = 0;
            while (location < labeling.numLocations()) {
                output.append("\t" + labeling.labelAtLocation(location));
                output.append("\t" + labeling.valueAtLocation(location));
                ++location;
            }
            out.println(output);
        }
        if (!Csv2Classify.outputFile.value.toString().equals("-")) {
            out.close();
        }
    }
}

