/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.Transducer;
import cc.mallet.fst.TransducerEvaluator;
import cc.mallet.fst.TransducerTrainer;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.util.HashMap;
import java.util.logging.Logger;

public class TokenAccuracyEvaluator
extends TransducerEvaluator {
    private static Logger logger = MalletLogger.getLogger(TokenAccuracyEvaluator.class.getName());
    private HashMap<String, Double> accuracy = new HashMap();

    public TokenAccuracyEvaluator(InstanceList[] instanceLists, String[] descriptions) {
        super(instanceLists, descriptions);
    }

    public TokenAccuracyEvaluator(InstanceList instanceList1, String description1) {
        this(new InstanceList[]{instanceList1}, new String[]{description1});
    }

    public TokenAccuracyEvaluator(InstanceList instanceList1, String description1, InstanceList instanceList2, String description2) {
        this(new InstanceList[]{instanceList1, instanceList2}, new String[]{description1, description2});
    }

    public TokenAccuracyEvaluator(InstanceList instanceList1, String description1, InstanceList instanceList2, String description2, InstanceList instanceList3, String description3) {
        this(new InstanceList[]{instanceList1, instanceList2, instanceList3}, new String[]{description1, description2, description3});
    }

    @Override
    public void evaluateInstanceList(TransducerTrainer trainer, InstanceList instances, String description) {
        Transducer transducer = trainer.getTransducer();
        int numCorrectTokens = 0;
        int totalTokens = 0;
        int i = 0;
        while (i < instances.size()) {
            Instance instance = (Instance)instances.get(i);
            Sequence input = (Sequence)instance.getData();
            Sequence trueOutput = (Sequence)instance.getTarget();
            assert (input.size() == trueOutput.size());
            Sequence predOutput = transducer.transduce(input);
            assert (predOutput.size() == trueOutput.size());
            int j = 0;
            while (j < trueOutput.size()) {
                ++totalTokens;
                if (trueOutput.get(j).equals(predOutput.get(j))) {
                    ++numCorrectTokens;
                }
                ++j;
            }
            ++i;
        }
        double acc = (double)numCorrectTokens / (double)totalTokens;
        this.accuracy.put(description, acc);
        logger.info(String.valueOf(description) + " accuracy=" + acc);
    }

    public double getAccuracy(String description) {
        Double ret = this.accuracy.get(description);
        if (ret != null) {
            return ret;
        }
        throw new IllegalArgumentException("No accuracy available for instance list \"" + description + "\"");
    }
}

