/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.optimize;

import cc.mallet.optimize.InvalidOptimizableException;
import cc.mallet.optimize.LineOptimizer;
import cc.mallet.optimize.Optimizable;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public class GradientBracketLineOptimizer
implements LineOptimizer {
    private static Logger logger = MalletLogger.getLogger(GradientBracketLineOptimizer.class.getName());
    int maxIterations = 50;
    Optimizable.ByGradientValue optimizable;

    public GradientBracketLineOptimizer(Optimizable.ByGradientValue function) {
        this.optimizable = function;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double optimize(double[] line, double initialStep) {
        if (!GradientBracketLineOptimizer.$assertionsDisabled && !(initialStep > 0.0)) {
            throw new AssertionError();
        }
        parameters = new double[this.optimizable.getNumParameters()];
        gradient = new double[this.optimizable.getNumParameters()];
        this.optimizable.getParameters(parameters);
        this.optimizable.getValueGradient(gradient);
        ox = 0.0;
        cx = 0.0;
        bx = 0.0;
        ax = 0.0;
        tx = 0.0;
        cy = origY = this.optimizable.getValue();
        by = origY;
        ay = origY;
        ty = origY;
        ag = bg = MatrixOps.dotProduct(gradient, line);
        tg = bg;
        if (ag <= 0.0) {
            throw new InvalidOptimizableException("The search direction \"line\" does not point down uphill.  gradient.dotProduct(line)=" + ag + ", but should be positive");
        }
        iterations = 0;
        do {
            if (iterations++ > this.maxIterations) {
                throw new IllegalStateException("Exceeded maximum number allowed iterations searching for gradient cross-over.");
            }
            ax = bx;
            ay = by;
            ag = bg;
            bx = tx;
            by = ty;
            bg = tg;
            tx = tx == 0.0 ? (initialStep < 1.0 ? initialStep : 1.0) : (tx *= 3.0);
            MatrixOps.plusEquals(parameters, line, tx - ox);
            this.optimizable.setParameters(parameters);
            ty = this.optimizable.getValue();
            this.optimizable.getValueGradient(gradient);
            tg = MatrixOps.dotProduct(gradient, line);
            ox = tx;
        } while (tg > 0.0);
        cx = tx;
        cy = ty;
        cg = tg;
        if (GradientBracketLineOptimizer.$assertionsDisabled || !Double.isNaN(by)) ** GOTO lbl69
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            if (iterations++ > this.maxIterations) {
                throw new IllegalStateException("Exceeded maximum number allowed iterations searching for bracketed minimum, iteratation count = " + iterations);
            }
            if ((Math.abs(bg) < 100.0 || Math.abs(ay - by) < 10.0 || Math.abs(by - cy) < 10.0) && bx != ax) break;
            if (!GradientBracketLineOptimizer.$assertionsDisabled && Double.isNaN(bg)) {
                throw new AssertionError();
            }
            if (bg > 0.0) {
                if (!GradientBracketLineOptimizer.$assertionsDisabled && !(by >= ay)) {
                    throw new AssertionError();
                }
                ax = bx;
                ay = by;
                ag = bg;
            } else {
                if (!GradientBracketLineOptimizer.$assertionsDisabled && !(by >= cy)) {
                    throw new AssertionError();
                }
                cx = bx;
                cy = by;
                cg = bg;
            }
            bx = (ax + cx) / 2.0;
            MatrixOps.plusEquals(parameters, line, bx - ox);
            this.optimizable.setParameters(parameters);
            by = this.optimizable.getValue();
            if (!GradientBracketLineOptimizer.$assertionsDisabled && Double.isNaN(by)) {
                throw new AssertionError();
            }
            this.optimizable.getValueGradient(gradient);
            bg = MatrixOps.dotProduct(gradient, line);
            ox = bx;
lbl69:
            // 2 sources

            ** while (by <= ay || by <= cy || bx == ax)
        }
lbl70:
        // 2 sources

        tx = ax + ((bx - ax) * (bx - ax) * (cy - ay) - (cx - ax) * (cx - ax) * (by - ay)) / (2.0 * ((bx - ax) * (cy - ay) - (cx - ax) * (by - ay)));
        MatrixOps.plusEquals(parameters, line, tx - ox);
        this.optimizable.setParameters(parameters);
        GradientBracketLineOptimizer.logger.info("Ending cost = " + this.optimizable.getValue());
        return Math.max(1.0, tx - initialStep);
    }
}

