/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.Sequence;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.Maths;
import java.io.PrintWriter;

public class SequencePrintingPipe
extends Pipe {
    private PrintWriter writer;

    public SequencePrintingPipe(PrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public Instance pipe(Instance carrier) {
        Sequence data = (Sequence)carrier.getData();
        Sequence target = (Sequence)carrier.getTarget();
        if (data.size() != target.size()) {
            throw new IllegalArgumentException("Trying to print into SimpleTagger format, where data and target lengths do not match\ndata.length = " + data.size() + ", target.length = " + target.size());
        }
        int N = data.size();
        if (data instanceof TokenSequence) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        if (data instanceof FeatureVectorSequence) {
            FeatureVectorSequence fvs = (FeatureVectorSequence)data;
            Alphabet dict = fvs.size() > 0 ? fvs.getFeatureVector(0).getAlphabet() : null;
            int i = 0;
            while (i < N) {
                Object label = target.get(i);
                this.writer.print(label);
                FeatureVector fv = fvs.getFeatureVector(i);
                int loc = 0;
                while (loc < fv.numLocations()) {
                    this.writer.print(' ');
                    String fname = dict.lookupObject(fv.indexAtLocation(loc)).toString();
                    double value = fv.valueAtLocation(loc);
                    if (!Maths.almostEquals(value, 1.0)) {
                        throw new IllegalArgumentException("Printing to SimpleTagger format: FeatureVector not binary at time slice " + i + " fv:" + fv);
                    }
                    this.writer.print(fname);
                    ++loc;
                }
                this.writer.println();
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Don't know how to print data of type " + data);
        }
        this.writer.println();
        return carrier;
    }
}

