/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.regression;

import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.OrthantWiseLimitedMemoryBFGS;
import cc.mallet.regression.LinearRegression;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.io.File;
import java.text.NumberFormat;
import java.util.Arrays;

public class LinearRegressionTrainer
implements Optimizable.ByGradientValue {
    LinearRegression regression;
    double[] parameters;
    InstanceList trainingData;
    double[] residuals;
    boolean cachedResidualsStale = true;
    NumberFormat formatter;
    int precisionIndex;
    int interceptIndex;

    public LinearRegressionTrainer(InstanceList data) {
        this.trainingData = data;
        this.regression = new LinearRegression(this.trainingData.getDataAlphabet());
        this.parameters = this.regression.getParameters();
        this.interceptIndex = this.parameters.length - 2;
        this.precisionIndex = this.parameters.length - 1;
        this.residuals = new double[this.trainingData.size()];
        this.parameters[this.precisionIndex] = 1.0;
        this.formatter = NumberFormat.getInstance();
        this.formatter.setMaximumFractionDigits(3);
    }

    private void computeResiduals() {
        int i = 0;
        while (i < this.trainingData.size()) {
            Instance instance = (Instance)this.trainingData.get(i);
            this.residuals[i] = (Double)instance.getTarget();
            FeatureVector predictors = (FeatureVector)instance.getData();
            int location = 0;
            while (location < predictors.numLocations()) {
                int index = predictors.indexAtLocation(location);
                int n = i;
                this.residuals[n] = this.residuals[n] - this.parameters[index] * predictors.valueAtLocation(location);
                ++location;
            }
            int n = i++;
            this.residuals[n] = this.residuals[n] - this.parameters[this.interceptIndex];
        }
        this.cachedResidualsStale = false;
    }

    @Override
    public double getValue() {
        int parameter = 0;
        while (parameter < this.parameters.length) {
            System.out.println(this.parameters[parameter]);
            ++parameter;
        }
        System.out.println();
        double logLikelihood = 0.0;
        logLikelihood += (double)this.residuals.length / 2.0 * Math.log(this.parameters[this.precisionIndex]);
        this.computeResiduals();
        int i = 0;
        while (i < this.residuals.length) {
            logLikelihood -= this.parameters[this.precisionIndex] * this.parameters[this.precisionIndex] * (this.residuals[i] * this.residuals[i]) / 2.0;
            ++i;
        }
        int parameter2 = 0;
        while (parameter2 < this.parameters.length - 1) {
            ++parameter2;
        }
        return logLikelihood;
    }

    @Override
    public void getValueGradient(double[] gradient) {
        this.computeResiduals();
        Arrays.fill(gradient, 0.0);
        int n = this.precisionIndex;
        gradient[n] = gradient[n] + 0.5 * (double)this.residuals.length / this.parameters[this.precisionIndex];
        int i = 0;
        while (i < this.residuals.length) {
            Instance instance = (Instance)this.trainingData.get(i);
            FeatureVector predictors = (FeatureVector)instance.getData();
            int location = 0;
            while (location < predictors.numLocations()) {
                int index = predictors.indexAtLocation(location);
                if (index == 3) {
                    int n2 = index;
                    gradient[n2] = gradient[n2] + this.parameters[this.precisionIndex] * this.parameters[this.precisionIndex] * (this.residuals[i] * predictors.valueAtLocation(location));
                }
                ++location;
            }
            int n3 = this.interceptIndex;
            gradient[n3] = gradient[n3] + this.parameters[this.precisionIndex] * this.parameters[this.precisionIndex] * this.residuals[i];
            int n4 = this.precisionIndex;
            gradient[n4] = gradient[n4] - this.parameters[this.precisionIndex] * this.residuals[i] * this.residuals[i];
            ++i;
        }
        int parameter = 0;
        while (parameter < this.parameters.length - 1) {
            ++parameter;
        }
        parameter = 0;
        while (parameter < this.parameters.length) {
            System.out.println("G\t" + gradient[parameter] + "\t" + this.parameters[parameter]);
            ++parameter;
        }
        System.out.println();
    }

    @Override
    public int getNumParameters() {
        return this.parameters.length;
    }

    @Override
    public double getParameter(int i) {
        return this.parameters[i];
    }

    @Override
    public void getParameters(double[] buffer) {
        int i = 0;
        while (i < this.parameters.length) {
            buffer[i] = this.parameters[i];
            ++i;
        }
    }

    @Override
    public void setParameter(int i, double r) {
        if (i == this.precisionIndex && r <= 0.0) {
            System.err.println("attempted to set precision at or less than 0");
            r = 0.001;
        }
        this.cachedResidualsStale = true;
        this.parameters[i] = r;
    }

    @Override
    public void setParameters(double[] newParameters) {
        this.cachedResidualsStale = true;
        int i = 0;
        while (i < this.parameters.length) {
            if (i == this.precisionIndex && newParameters[i] <= 0.0) {
                System.err.println("attempted to set precision at or less than 0");
                this.parameters[i] = 0.001;
            } else {
                this.parameters[i] = newParameters[i];
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        InstanceList data = InstanceList.load(new File(args[0]));
        LinearRegressionTrainer trainer = new LinearRegressionTrainer(data);
        OrthantWiseLimitedMemoryBFGS optimizer = new OrthantWiseLimitedMemoryBFGS(trainer);
        optimizer.optimize();
        optimizer.optimize();
    }
}

