/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics;

import cc.mallet.topics.LDAHyper;
import cc.mallet.types.FeatureCounter;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.IDSorter;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.util.Randoms;
import gnu.trove.TIntIntHashMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;

public class LDAStream
extends LDAHyper {
    protected ArrayList<LDAHyper.Topication> test;

    public LDAStream(int numberOfTopics) {
        super(numberOfTopics);
    }

    public LDAStream(int numberOfTopics, double alphaSum, double beta) {
        super(numberOfTopics, alphaSum, beta);
    }

    public LDAStream(int numberOfTopics, double alphaSum, double beta, Randoms random) {
        super(numberOfTopics, alphaSum, beta, random);
    }

    public LDAStream(LabelAlphabet topicAlphabet, double alphaSum, double beta, Randoms random) {
        super(topicAlphabet, alphaSum, beta, random);
    }

    public ArrayList<LDAHyper.Topication> getTest() {
        return this.test;
    }

    public void inferenceAll(int maxIteration) {
        this.test = new ArrayList();
        ArrayList<LabelSequence> topicSequences = new ArrayList<LabelSequence>();
        for (Instance instance : this.testing) {
            LabelSequence topicSequence = new LabelSequence(this.topicAlphabet, new int[this.instanceLength(instance)]);
            Randoms r = new Randoms();
            FeatureSequence fs = (FeatureSequence)instance.getData();
            int[] topics = topicSequence.getFeatures();
            int i = 0;
            while (i < topics.length) {
                int type = fs.getIndexAtPosition(i);
                topics[i] = r.nextInt(this.numTopics);
                this.typeTopicCounts[type].adjustOrPutValue(topics[i], 1, 1);
                int n = topics[i];
                this.tokensPerTopic[n] = this.tokensPerTopic[n] + 1;
                ++i;
            }
            topicSequences.add(topicSequence);
        }
        assert (this.testing.size() == topicSequences.size());
        int i = 0;
        while (i < this.testing.size()) {
            LDAHyper.Topication t = new LDAHyper.Topication((Instance)this.testing.get(i), this, (LabelSequence)topicSequences.get(i));
            this.test.add(t);
            ++i;
        }
        long startTime = System.currentTimeMillis();
        int iter = 0;
        while (iter <= maxIteration) {
            if (iter % 100 == 0) {
                System.out.print("Iteration: " + iter);
                System.out.println();
            }
            int numDocs = this.test.size();
            int di = 0;
            while (di < numDocs) {
                FeatureSequence tokenSequence = (FeatureSequence)this.test.get((int)di).instance.getData();
                LabelSequence topicSequence = this.test.get((int)di).topicSequence;
                this.sampleTopicsForOneTestDocAll(tokenSequence, topicSequence);
                ++di;
            }
            ++iter;
        }
        long seconds = Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0);
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        System.out.print("\nTotal inferencing time: ");
        if (days != 0L) {
            System.out.print(days);
            System.out.print(" days ");
        }
        if (hours != 0L) {
            System.out.print(hours);
            System.out.print(" hours ");
        }
        if (minutes != 0L) {
            System.out.print(minutes);
            System.out.print(" minutes ");
        }
        System.out.print(seconds);
        System.out.println(" seconds");
    }

    private void sampleTopicsForOneTestDocAll(FeatureSequence tokenSequence, LabelSequence topicSequence) {
        int[] oneDocTopics = topicSequence.getFeatures();
        double[] topicWeights = new double[this.numTopics];
        int docLength = tokenSequence.getLength();
        int[] localTopicCounts = new int[this.numTopics];
        int ti = 0;
        while (ti < this.numTopics) {
            localTopicCounts[ti] = 0;
            ++ti;
        }
        int position = 0;
        while (position < docLength) {
            int n = oneDocTopics[position];
            localTopicCounts[n] = localTopicCounts[n] + 1;
            ++position;
        }
        int si = 0;
        while (si < docLength) {
            int newTopic;
            int oldTopic;
            int type = tokenSequence.getIndexAtPosition(si);
            int n = oldTopic = oneDocTopics[si];
            localTopicCounts[n] = localTopicCounts[n] - 1;
            TIntIntHashMap currentTypeTopicCounts = this.typeTopicCounts[type];
            assert (currentTypeTopicCounts.get(oldTopic) >= 0);
            if (currentTypeTopicCounts.get(oldTopic) == 1) {
                currentTypeTopicCounts.remove(oldTopic);
            } else {
                currentTypeTopicCounts.adjustValue(oldTopic, -1);
            }
            int n2 = oldTopic;
            this.tokensPerTopic[n2] = this.tokensPerTopic[n2] - 1;
            Arrays.fill(topicWeights, 0.0);
            double topicWeightsSum = 0.0;
            int ti2 = 0;
            while (ti2 < this.numTopics) {
                double tw = ((double)currentTypeTopicCounts.get(ti2) + this.beta) / ((double)this.tokensPerTopic[ti2] + this.betaSum) * ((double)localTopicCounts[ti2] + this.alpha[ti2]);
                topicWeightsSum += tw;
                topicWeights[ti2] = tw;
                ++ti2;
            }
            oneDocTopics[si] = newTopic = this.random.nextDiscrete(topicWeights, topicWeightsSum);
            currentTypeTopicCounts.adjustOrPutValue(newTopic, 1, 1);
            int n3 = newTopic;
            localTopicCounts[n3] = localTopicCounts[n3] + 1;
            int n4 = newTopic;
            this.tokensPerTopic[n4] = this.tokensPerTopic[n4] + 1;
            ++si;
        }
    }

    public void estimateAll(int iteration) throws IOException {
        this.data.addAll(this.test);
        this.initializeHistogramsAndCachedValues();
        this.estimate(iteration);
    }

    public void inference(int maxIteration) {
        this.test = new ArrayList();
        ArrayList<LabelSequence> topicSequences = new ArrayList<LabelSequence>();
        for (Instance instance : this.testing) {
            LabelSequence topicSequence = new LabelSequence(this.topicAlphabet, new int[this.instanceLength(instance)]);
            Randoms r = new Randoms();
            FeatureSequence fs = (FeatureSequence)instance.getData();
            int[] topics = topicSequence.getFeatures();
            int i = 0;
            while (i < topics.length) {
                int type = fs.getIndexAtPosition(i);
                topics[i] = r.nextInt(this.numTopics);
                ++i;
            }
            topicSequences.add(topicSequence);
        }
        assert (this.testing.size() == topicSequences.size());
        int i = 0;
        while (i < this.testing.size()) {
            LDAHyper.Topication t = new LDAHyper.Topication((Instance)this.testing.get(i), this, (LabelSequence)topicSequences.get(i));
            this.test.add(t);
            FeatureSequence tokenSequence = (FeatureSequence)t.instance.getData();
            LabelSequence topicSequence = t.topicSequence;
            int pi = 0;
            while (pi < topicSequence.getLength()) {
                int topic = topicSequence.getIndexAtPosition(pi);
                int type = tokenSequence.getIndexAtPosition(pi);
                if (topic != -1) {
                    this.typeTopicCounts[type].adjustOrPutValue(topic, 1, 1);
                    int n = topic;
                    this.tokensPerTopic[n] = this.tokensPerTopic[n] + 1;
                }
                ++pi;
            }
            ++i;
        }
        long startTime = System.currentTimeMillis();
        int iter = 0;
        while (iter <= maxIteration) {
            if (iter % 100 == 0) {
                System.out.print("Iteration: " + iter);
                System.out.println();
            }
            int numDocs = this.test.size();
            int di = 0;
            while (di < numDocs) {
                FeatureSequence tokenSequence = (FeatureSequence)this.test.get((int)di).instance.getData();
                LabelSequence topicSequence = this.test.get((int)di).topicSequence;
                this.sampleTopicsForOneTestDoc(tokenSequence, topicSequence);
                ++di;
            }
            ++iter;
        }
        long seconds = Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0);
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        System.out.print("\nTotal inferencing time: ");
        if (days != 0L) {
            System.out.print(days);
            System.out.print(" days ");
        }
        if (hours != 0L) {
            System.out.print(hours);
            System.out.print(" hours ");
        }
        if (minutes != 0L) {
            System.out.print(minutes);
            System.out.print(" minutes ");
        }
        System.out.print(seconds);
        System.out.println(" seconds");
    }

    private void sampleTopicsForOneTestDoc(FeatureSequence tokenSequence, LabelSequence topicSequence) {
        int[] oneDocTopics = topicSequence.getFeatures();
        double[] topicWeights = new double[this.numTopics];
        int docLength = tokenSequence.getLength();
        int[] localTopicCounts = new int[this.numTopics];
        int ti = 0;
        while (ti < this.numTopics) {
            localTopicCounts[ti] = 0;
            ++ti;
        }
        int position = 0;
        while (position < docLength) {
            if (oneDocTopics[position] != -1) {
                int n = oneDocTopics[position];
                localTopicCounts[n] = localTopicCounts[n] + 1;
            }
            ++position;
        }
        int si = 0;
        while (si < docLength) {
            int type = tokenSequence.getIndexAtPosition(si);
            int oldTopic = oneDocTopics[si];
            if (oldTopic != -1) {
                int newTopic;
                int n = oldTopic;
                localTopicCounts[n] = localTopicCounts[n] - 1;
                TIntIntHashMap currentTypeTopicCounts = this.typeTopicCounts[type];
                assert (currentTypeTopicCounts.get(oldTopic) >= 0);
                if (currentTypeTopicCounts.get(oldTopic) == 1) {
                    currentTypeTopicCounts.remove(oldTopic);
                } else {
                    currentTypeTopicCounts.adjustValue(oldTopic, -1);
                }
                int n2 = oldTopic;
                this.tokensPerTopic[n2] = this.tokensPerTopic[n2] - 1;
                Arrays.fill(topicWeights, 0.0);
                double topicWeightsSum = 0.0;
                int ti2 = 0;
                while (ti2 < this.numTopics) {
                    double tw = ((double)currentTypeTopicCounts.get(ti2) + this.beta) / ((double)this.tokensPerTopic[ti2] + this.betaSum) * ((double)localTopicCounts[ti2] + this.alpha[ti2]);
                    topicWeightsSum += tw;
                    topicWeights[ti2] = tw;
                    ++ti2;
                }
                oneDocTopics[si] = newTopic = this.random.nextDiscrete(topicWeights, topicWeightsSum);
                currentTypeTopicCounts.adjustOrPutValue(newTopic, 1, 1);
                int n3 = newTopic;
                localTopicCounts[n3] = localTopicCounts[n3] + 1;
                int n4 = newTopic;
                this.tokensPerTopic[n4] = this.tokensPerTopic[n4] + 1;
            }
            ++si;
        }
    }

    public void inferenceOneByOne(int maxIteration) {
        this.test = new ArrayList();
        ArrayList<LabelSequence> topicSequences = new ArrayList<LabelSequence>();
        for (Instance instance : this.testing) {
            LabelSequence topicSequence = new LabelSequence(this.topicAlphabet, new int[this.instanceLength(instance)]);
            Randoms r = new Randoms();
            FeatureSequence fs = (FeatureSequence)instance.getData();
            int[] topics = topicSequence.getFeatures();
            int i = 0;
            while (i < topics.length) {
                int type = fs.getIndexAtPosition(i);
                topics[i] = r.nextInt(this.numTopics);
                this.typeTopicCounts[type].adjustOrPutValue(topics[i], 1, 1);
                int n = topics[i];
                this.tokensPerTopic[n] = this.tokensPerTopic[n] + 1;
                ++i;
            }
            topicSequences.add(topicSequence);
        }
        assert (this.testing.size() == topicSequences.size());
        int i = 0;
        while (i < this.testing.size()) {
            LDAHyper.Topication t = new LDAHyper.Topication((Instance)this.testing.get(i), this, (LabelSequence)topicSequences.get(i));
            this.test.add(t);
            ++i;
        }
        long startTime = System.currentTimeMillis();
        int iter = 0;
        int numDocs = this.test.size();
        int di = 0;
        while (di < numDocs) {
            iter = 0;
            FeatureSequence tokenSequence = (FeatureSequence)this.test.get((int)di).instance.getData();
            LabelSequence topicSequence = this.test.get((int)di).topicSequence;
            while (iter <= maxIteration) {
                this.sampleTopicsForOneTestDoc(tokenSequence, topicSequence);
                ++iter;
            }
            if (di % 100 == 0) {
                System.out.print("Docnum: " + di);
                System.out.println();
            }
            ++di;
        }
        long seconds = Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0);
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        System.out.print("\nTotal inferencing time: ");
        if (days != 0L) {
            System.out.print(days);
            System.out.print(" days ");
        }
        if (hours != 0L) {
            System.out.print(hours);
            System.out.print(" hours ");
        }
        if (minutes != 0L) {
            System.out.print(minutes);
            System.out.print(" minutes ");
        }
        System.out.print(seconds);
        System.out.println(" seconds");
    }

    public void inferenceWithTheta(int maxIteration, InstanceList theta) {
        this.test = new ArrayList();
        ArrayList<LabelSequence> topicSequences = new ArrayList<LabelSequence>();
        for (Instance instance : this.testing) {
            LabelSequence topicSequence = new LabelSequence(this.topicAlphabet, new int[this.instanceLength(instance)]);
            Randoms r = new Randoms();
            FeatureSequence fs = (FeatureSequence)instance.getData();
            int[] topics = topicSequence.getFeatures();
            int i = 0;
            while (i < topics.length) {
                int type = fs.getIndexAtPosition(i);
                topics[i] = r.nextInt(this.numTopics);
                ++i;
            }
            topicSequences.add(topicSequence);
        }
        assert (this.testing.size() == topicSequences.size());
        int i = 0;
        while (i < this.testing.size()) {
            LDAHyper.Topication t = new LDAHyper.Topication((Instance)this.testing.get(i), this, (LabelSequence)topicSequences.get(i));
            this.test.add(t);
            FeatureSequence tokenSequence = (FeatureSequence)t.instance.getData();
            LabelSequence topicSequence = t.topicSequence;
            int pi = 0;
            while (pi < topicSequence.getLength()) {
                int topic = topicSequence.getIndexAtPosition(pi);
                int type = tokenSequence.getIndexAtPosition(pi);
                if (topic != -1) {
                    this.typeTopicCounts[type].adjustOrPutValue(topic, 1, 1);
                    int n = topic;
                    this.tokensPerTopic[n] = this.tokensPerTopic[n] + 1;
                }
                ++pi;
            }
            ++i;
        }
        long startTime = System.currentTimeMillis();
        int iter = 0;
        while (iter <= maxIteration) {
            if (iter % 100 == 0) {
                System.out.print("Iteration: " + iter);
                System.out.println();
            }
            int numDocs = this.test.size();
            int di = 0;
            while (di < numDocs) {
                FeatureVector fvTheta = (FeatureVector)((Instance)theta.get(di)).getData();
                double[] topicDistribution = fvTheta.getValues();
                FeatureSequence tokenSequence = (FeatureSequence)this.test.get((int)di).instance.getData();
                LabelSequence topicSequence = this.test.get((int)di).topicSequence;
                this.sampleTopicsForOneDocWithTheta(tokenSequence, topicSequence, topicDistribution);
                ++di;
            }
            ++iter;
        }
        long seconds = Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0);
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        System.out.print("\nTotal inferencing time: ");
        if (days != 0L) {
            System.out.print(days);
            System.out.print(" days ");
        }
        if (hours != 0L) {
            System.out.print(hours);
            System.out.print(" hours ");
        }
        if (minutes != 0L) {
            System.out.print(minutes);
            System.out.print(" minutes ");
        }
        System.out.print(seconds);
        System.out.println(" seconds");
    }

    private void sampleTopicsForOneDocWithTheta(FeatureSequence tokenSequence, LabelSequence topicSequence, double[] topicDistribution) {
        int[] oneDocTopics = topicSequence.getFeatures();
        double[] topicWeights = new double[this.numTopics];
        int docLength = tokenSequence.getLength();
        int si = 0;
        while (si < docLength) {
            int type = tokenSequence.getIndexAtPosition(si);
            int oldTopic = oneDocTopics[si];
            if (oldTopic != -1) {
                int newTopic;
                TIntIntHashMap currentTypeTopicCounts = this.typeTopicCounts[type];
                assert (currentTypeTopicCounts.get(oldTopic) >= 0);
                if (currentTypeTopicCounts.get(oldTopic) == 1) {
                    currentTypeTopicCounts.remove(oldTopic);
                } else {
                    currentTypeTopicCounts.adjustValue(oldTopic, -1);
                }
                int n = oldTopic;
                this.tokensPerTopic[n] = this.tokensPerTopic[n] - 1;
                Arrays.fill(topicWeights, 0.0);
                double topicWeightsSum = 0.0;
                int ti = 0;
                while (ti < this.numTopics) {
                    double tw = ((double)currentTypeTopicCounts.get(ti) + this.beta) / ((double)this.tokensPerTopic[ti] + this.betaSum) * topicDistribution[ti];
                    topicWeightsSum += tw;
                    topicWeights[ti] = tw;
                    ++ti;
                }
                oneDocTopics[si] = newTopic = this.random.nextDiscrete(topicWeights, topicWeightsSum);
                currentTypeTopicCounts.adjustOrPutValue(newTopic, 1, 1);
                int n2 = newTopic;
                this.tokensPerTopic[n2] = this.tokensPerTopic[n2] + 1;
            }
            ++si;
        }
    }

    public void printTheta(ArrayList<LDAHyper.Topication> dataset, File f, double threshold, int max) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(f));
        int[] topicCounts = new int[this.numTopics];
        int di = 0;
        while (di < dataset.size()) {
            LabelSequence topicSequence = dataset.get((int)di).topicSequence;
            int[] currentDocTopics = topicSequence.getFeatures();
            int docLen = currentDocTopics.length;
            int token = 0;
            while (token < docLen) {
                int n = currentDocTopics[token];
                topicCounts[n] = topicCounts[n] + 1;
                ++token;
            }
            pw.println(dataset.get((int)di).instance.getName());
            int topic = 0;
            while (topic < this.numTopics) {
                double prob = ((double)topicCounts[topic] + this.alpha[topic]) / ((double)docLen + this.alphaSum);
                pw.println("topic" + topic + "\t" + prob);
                ++topic;
            }
            pw.println();
            Arrays.fill(topicCounts, 0);
            ++di;
        }
        pw.close();
    }

    public void printPhi(File f, double threshold) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(f));
        FeatureCounter[] wordCountsPerTopic = new FeatureCounter[this.numTopics];
        int ti = 0;
        while (ti < this.numTopics) {
            wordCountsPerTopic[ti] = new FeatureCounter(this.alphabet);
            ++ti;
        }
        int fi = 0;
        while (fi < this.numTypes) {
            int[] topics = this.typeTopicCounts[fi].keys();
            int i = 0;
            while (i < topics.length) {
                wordCountsPerTopic[topics[i]].increment(fi, this.typeTopicCounts[fi].get(topics[i]));
                ++i;
            }
            ++fi;
        }
        ti = 0;
        while (ti < this.numTopics) {
            pw.println("Topic\t" + ti);
            FeatureCounter counter = wordCountsPerTopic[ti];
            FeatureVector fv = counter.toFeatureVector();
            int pos = 0;
            while (pos < fv.numLocations()) {
                int fi2 = fv.indexAtLocation(pos);
                String word = (String)this.alphabet.lookupObject(fi2);
                int count = (int)fv.valueAtLocation(pos);
                double prob = ((double)count + this.beta) / ((double)this.tokensPerTopic[ti] + this.betaSum);
                pw.println(String.valueOf(word) + "\t" + prob);
                ++pos;
            }
            pw.println();
            ++ti;
        }
        pw.close();
    }

    public void printDocumentTopics(ArrayList<LDAHyper.Topication> dataset, File f) throws IOException {
        this.printDocumentTopics(dataset, new PrintWriter(new FileWriter(f)));
    }

    public void printDocumentTopics(ArrayList<LDAHyper.Topication> dataset, PrintWriter pw) {
        this.printDocumentTopics(dataset, pw, 0.0, -1);
    }

    public void printDocumentTopics(ArrayList<LDAHyper.Topication> dataset, PrintWriter pw, double threshold, int max) {
        pw.print("#doc source topic proportion ...\n");
        int[] topicCounts = new int[this.numTopics];
        Object[] sortedTopics = new IDSorter[this.numTopics];
        int topic = 0;
        while (topic < this.numTopics) {
            sortedTopics[topic] = new IDSorter(topic, topic);
            ++topic;
        }
        if (max < 0 || max > this.numTopics) {
            max = this.numTopics;
        }
        int di = 0;
        while (di < dataset.size()) {
            LabelSequence topicSequence = dataset.get((int)di).topicSequence;
            int[] currentDocTopics = topicSequence.getFeatures();
            pw.print(di);
            pw.print(' ');
            if (dataset.get((int)di).instance.getSource() != null) {
                pw.print(dataset.get((int)di).instance.getSource());
            } else {
                pw.print("null-source");
            }
            pw.print(' ');
            int docLen = currentDocTopics.length;
            int realDocLen = 0;
            int token = 0;
            while (token < docLen) {
                if (currentDocTopics[token] != -1) {
                    int n = currentDocTopics[token];
                    topicCounts[n] = topicCounts[n] + 1;
                    ++realDocLen;
                }
                ++token;
            }
            assert (realDocLen == docLen);
            this.alphaSum = 0.0;
            int topic2 = 0;
            while (topic2 < this.numTopics) {
                this.alphaSum += this.alpha[topic2];
                ++topic2;
            }
            topic2 = 0;
            while (topic2 < this.numTopics) {
                ((IDSorter)sortedTopics[topic2]).set(topic2, ((double)topicCounts[topic2] + this.alpha[topic2]) / ((double)docLen + this.alphaSum));
                ++topic2;
            }
            Arrays.sort(sortedTopics);
            int i = 0;
            while (i < max) {
                if (((IDSorter)sortedTopics[i]).getWeight() < threshold) break;
                pw.print(String.valueOf(((IDSorter)sortedTopics[i]).getID()) + " " + ((IDSorter)sortedTopics[i]).getWeight() + " ");
                ++i;
            }
            pw.print(" \n");
            Arrays.fill(topicCounts, 0);
            ++di;
        }
        pw.close();
    }

    public void printState(ArrayList<LDAHyper.Topication> dataset, File f) throws IOException {
        PrintStream out = new PrintStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(f))));
        this.printState(dataset, out);
        out.close();
    }

    public void printState(ArrayList<LDAHyper.Topication> dataset, PrintStream out) {
        out.println("#doc source pos typeindex type topic");
        int di = 0;
        while (di < dataset.size()) {
            FeatureSequence tokenSequence = (FeatureSequence)dataset.get((int)di).instance.getData();
            LabelSequence topicSequence = dataset.get((int)di).topicSequence;
            String source = "NA";
            if (dataset.get((int)di).instance.getSource() != null) {
                source = dataset.get((int)di).instance.getSource().toString();
            }
            int pi = 0;
            while (pi < topicSequence.getLength()) {
                int type = tokenSequence.getIndexAtPosition(pi);
                int topic = topicSequence.getIndexAtPosition(pi);
                out.print(di);
                out.print(' ');
                out.print(source);
                out.print(' ');
                out.print(pi);
                out.print(' ');
                out.print(type);
                out.print(' ');
                out.print(this.alphabet.lookupObject(type));
                out.print(' ');
                out.print(topic);
                out.println();
                ++pi;
            }
            ++di;
        }
    }
}

