/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

public class LogNumber {
    public double logVal;
    public boolean sign;

    public LogNumber(double logVal, boolean sign) {
        this.logVal = logVal;
        this.sign = sign;
    }

    public void timesEquals(LogNumber other) {
        this.logVal += other.logVal;
        this.sign = this.sign && other.sign || !this.sign && !other.sign;
    }

    public double exp() {
        double exp = Math.exp(this.logVal);
        if (!this.sign) {
            exp *= -1.0;
        }
        return exp;
    }

    public void set(double logVal, boolean sign) {
        this.logVal = logVal;
        this.sign = sign;
    }

    public void plusEquals(LogNumber other) {
        if (this.logVal == Double.NEGATIVE_INFINITY) {
            if (!this.sign) {
                this.sign = true;
            }
            if (other.logVal == Double.NEGATIVE_INFINITY) {
                return;
            }
            this.logVal = other.logVal;
            this.sign = other.sign;
        } else {
            if (other.logVal == Double.NEGATIVE_INFINITY) {
                return;
            }
            if (this.logVal > other.logVal) {
                if (this.sign && other.sign) {
                    this.logVal += Math.log(1.0 + Math.exp(other.logVal - this.logVal));
                } else if (this.sign && !other.sign) {
                    this.logVal += Math.log(1.0 - Math.exp(other.logVal - this.logVal));
                } else if (!this.sign && other.sign) {
                    this.logVal += Math.log(1.0 - Math.exp(other.logVal - this.logVal));
                } else if (!this.sign && !other.sign) {
                    this.logVal += Math.log(1.0 + Math.exp(other.logVal - this.logVal));
                }
            } else if (this.sign && other.sign) {
                this.logVal = other.logVal + Math.log(1.0 + Math.exp(this.logVal - other.logVal));
            } else if (this.sign && !other.sign) {
                this.logVal = other.logVal + Math.log(1.0 - Math.exp(this.logVal - other.logVal));
                this.sign = false;
            } else if (!this.sign && other.sign) {
                this.logVal = other.logVal + Math.log(1.0 - Math.exp(this.logVal - other.logVal));
                this.sign = true;
            } else if (!this.sign && !other.sign) {
                this.logVal = other.logVal + Math.log(1.0 + Math.exp(this.logVal - other.logVal));
            }
        }
    }

    public String toString() {
        return "log value = " + this.logVal + ", positive = " + this.sign;
    }
}

