/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary;

import java.util.Iterator;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.IndexWordSet;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.util.MessageLog;
import net.didion.jwnl.util.MessageLogLevel;
import net.didion.jwnl.util.factory.Installable;

public abstract class Dictionary
implements Installable {
    private static final MessageLog _log = new MessageLog(Dictionary.class);
    private static Dictionary _dictionary = null;
    private MorphologicalProcessor _morph = null;

    public static Dictionary getInstance() {
        return _dictionary;
    }

    protected static void setDictionary(Dictionary dictionary) {
        _log.log(MessageLogLevel.INFO, "DICTIONARY_INFO_002", dictionary);
        _dictionary = dictionary;
    }

    public static void uninstall() {
        if (_dictionary != null) {
            _dictionary.close();
            _dictionary = null;
        }
    }

    protected static String prepareQueryString(String lemma) {
        return lemma.trim().toLowerCase();
    }

    protected Dictionary() {
    }

    protected Dictionary(MorphologicalProcessor morph) {
        this._morph = morph;
    }

    public abstract Iterator getIndexWordIterator(POS var1) throws JWNLException;

    public abstract Iterator getIndexWordIterator(POS var1, String var2) throws JWNLException;

    public abstract IndexWord getIndexWord(POS var1, String var2) throws JWNLException;

    public abstract IndexWord getRandomIndexWord(POS var1) throws JWNLException;

    public abstract Iterator getSynsetIterator(POS var1) throws JWNLException;

    public abstract Synset getSynsetAt(POS var1, long var2) throws JWNLException;

    public abstract Iterator getExceptionIterator(POS var1) throws JWNLException;

    public abstract Exc getException(POS var1, String var2) throws JWNLException;

    public abstract void close();

    public MorphologicalProcessor getMorphologicalProcessor() {
        return this._morph;
    }

    public IndexWord lookupIndexWord(POS pos, String lemma) throws JWNLException {
        IndexWord word = this.getIndexWord(pos, lemma = Dictionary.prepareQueryString(lemma));
        if (word == null && this.getMorphologicalProcessor() != null) {
            word = this.getMorphologicalProcessor().lookupBaseForm(pos, lemma);
        }
        return word;
    }

    public IndexWordSet lookupAllIndexWords(String lemma) throws JWNLException {
        lemma = Dictionary.prepareQueryString(lemma);
        IndexWordSet set = new IndexWordSet(lemma);
        Iterator itr = POS.getAllPOS().iterator();
        while (itr.hasNext()) {
            IndexWord current = this.lookupIndexWord((POS)itr.next(), lemma);
            if (current == null) continue;
            set.add(current);
        }
        return set;
    }
}

