/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.distributed;

import java.util.HashSet;
import java.util.Iterator;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.distributed.Communicator;
import no.uib.cipr.matrix.distributed.DistMatrix;
import no.uib.cipr.matrix.distributed.DistVector;
import no.uib.cipr.matrix.distributed.Reductions;

@Deprecated
public class DistColMatrix
extends DistMatrix {
    private static final long serialVersionUID = 3618421523053359673L;

    public DistColMatrix(int numRows, int numColumns, Communicator comm, Matrix A, Matrix B) {
        super(numRows, numColumns, comm, A, B);
        if (A.numColumns() != B.numColumns()) {
            throw new IllegalArgumentException("A.numColumns() != B.numColumns()");
        }
        if (B.numRows() != numRows) {
            throw new IllegalArgumentException("B.numRows() != numRows");
        }
    }

    @Override
    public void add(int row, int column, double value) {
        this.check(row, column);
        if (this.inA(row, column)) {
            this.A.add(row - this.n[this.rank], column - this.m[this.rank], value);
        } else if (this.local(row, column)) {
            this.B.add(row, column - this.m[this.rank], value);
        } else {
            throw new IllegalArgumentException("Column index " + column + " is not local");
        }
    }

    @Override
    public void set(int row, int column, double value) {
        this.check(row, column);
        if (this.inA(row, column)) {
            this.A.set(row - this.n[this.rank], column - this.m[this.rank], value);
        } else if (this.local(row, column)) {
            this.B.set(row, column - this.m[this.rank], value);
        } else {
            throw new IllegalArgumentException("Column index " + column + " is not local");
        }
    }

    @Override
    public double get(int row, int column) {
        this.check(row, column);
        if (this.inA(row, column)) {
            return this.A.get(row - this.n[this.rank], column - this.m[this.rank]);
        }
        if (this.local(row, column)) {
            return this.B.get(row, column - this.m[this.rank]);
        }
        throw new IndexOutOfBoundsException("Entry not available locally");
    }

    @Override
    public DistColMatrix copy() {
        return new DistColMatrix(this.numRows, this.numColumns, this.comm, this.A.copy(), this.B.copy());
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new DistMatrix.DistMatrixIterator(this, this.n[this.rank], this.m[this.rank], 0, this.m[this.rank]);
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DistVector) || !(y instanceof DistVector)) {
            throw new IllegalArgumentException("Vectors must be DistVectors");
        }
        this.checkMultAdd(x, y);
        y.scale(1.0 / alpha);
        DistVector xd = (DistVector)x;
        DistVector yd = (DistVector)y;
        this.B.mult(xd.getLocal(), this.locR);
        this.scatter.startGather(this.locR, yd);
        this.A.multAdd(xd.getLocal(), yd.getLocal());
        this.scatter.endAddGather(this.locR, yd);
        return y.scale(alpha);
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DistVector) || !(y instanceof DistVector)) {
            throw new IllegalArgumentException("Vectors must be DistVectors");
        }
        this.checkTransMultAdd(x, y);
        DistVector xd = (DistVector)x;
        DistVector yd = (DistVector)y;
        this.scatter.startScatter(xd, this.locC);
        this.A.transMultAdd(alpha, xd.getLocal(), yd.getLocal());
        this.scatter.endSetScatter(xd, this.locC);
        this.B.transMultAdd(alpha, this.locC, yd.getLocal());
        return y;
    }

    @Override
    public boolean local(int row, int column) {
        return column >= this.m[this.rank] && column < this.m[this.rank + 1];
    }

    int getRank(int column) {
        int i;
        for (i = 1; i < this.m.length && column >= this.m[i]; ++i) {
        }
        return i - 1;
    }

    @Override
    int[] getDelimiter() {
        return this.m;
    }

    @Override
    int[] getCommIndices() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (MatrixEntry e : this.B) {
            if (this.local(e.row(), e.row())) continue;
            set.add(e.row());
        }
        int[] indices = new int[set.size()];
        int j = 0;
        for (Integer i : set) {
            indices[j++] = i;
        }
        return indices;
    }

    @Override
    protected double norm1() {
        double[] rowSum = new double[this.numRows];
        for (MatrixEntry e : this) {
            int n = e.row();
            rowSum[n] = rowSum[n] + Math.abs(e.get());
        }
        double[] recv = new double[this.numRows];
        this.comm.allReduce(rowSum, recv, Reductions.sum());
        return this.max(recv);
    }

    @Override
    protected double normInf() {
        double norm = super.normInf();
        double[] recv = new double[1];
        this.comm.allReduce(new double[]{norm}, recv, Reductions.max());
        return recv[0];
    }

    @Override
    public DistColMatrix zero() {
        super.zero();
        return this;
    }
}

