/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima;

import java.util.Locale;
import org.apache.uima.InternationalizedRuntimeException;
import org.apache.uima.internal.util.I18nUtil;

public class InternationalizedException
extends Exception {
    private static final long serialVersionUID = 2306587442280738385L;
    private String mResourceBundleName;
    private String mMessageKey;
    private Object[] mArguments;
    private Throwable mCause;
    private final transient ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();

    public InternationalizedException() {
        this(null, null, null, null);
    }

    public InternationalizedException(Throwable aCause) {
        this(null, null, null, aCause);
    }

    public InternationalizedException(String aResourceBundleName, String aMessageKey, Object[] aArguments) {
        this(aResourceBundleName, aMessageKey, aArguments, null);
    }

    public InternationalizedException(String aResourceBundleName, String aMessageKey, Object[] aArguments, Throwable aCause) {
        this.mCause = aCause;
        this.mResourceBundleName = aResourceBundleName;
        this.mMessageKey = aMessageKey;
        this.mArguments = aArguments;
        if (this.mResourceBundleName == null && this.mMessageKey == null) {
            if (this.mCause instanceof InternationalizedException) {
                this.mResourceBundleName = ((InternationalizedException)this.mCause).getResourceBundleName();
                this.mMessageKey = ((InternationalizedException)this.mCause).getMessageKey();
                this.mArguments = ((InternationalizedException)this.mCause).getArguments();
            } else if (this.mCause instanceof InternationalizedRuntimeException) {
                this.mResourceBundleName = ((InternationalizedRuntimeException)this.mCause).getResourceBundleName();
                this.mMessageKey = ((InternationalizedRuntimeException)this.mCause).getMessageKey();
                this.mArguments = ((InternationalizedRuntimeException)this.mCause).getArguments();
            }
        }
    }

    public String getResourceBundleName() {
        return this.mResourceBundleName;
    }

    public String getMessageKey() {
        return this.mMessageKey;
    }

    public Object[] getArguments() {
        if (this.mArguments == null) {
            return new Object[0];
        }
        Object[] result = new Object[this.mArguments.length];
        System.arraycopy(this.mArguments, 0, result, 0, this.mArguments.length);
        return result;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(Locale.ENGLISH);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale aLocale) {
        if (this.getMessageKey() == null) {
            return null;
        }
        try {
            I18nUtil.setTccl(this.originalContextClassLoader);
            String string = I18nUtil.localizeMessage(this.getResourceBundleName(), aLocale, this.getMessageKey(), this.getArguments());
            return string;
        }
        finally {
            I18nUtil.removeTccl();
        }
    }

    @Override
    public Throwable getCause() {
        return this.mCause;
    }

    public boolean hasMessageKey(String messageKey) {
        if (messageKey.equals(this.getMessageKey())) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof InternationalizedException) {
            return ((InternationalizedException)cause).hasMessageKey(messageKey);
        }
        return false;
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        this.mCause = cause;
        return this;
    }
}

