/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.evaluate;

import cc.mallet.classify.Classification;
import cc.mallet.classify.Trial;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelVector;
import cc.mallet.types.Labeling;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.MalletLogger;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ConfusionMatrix {
    private static Logger logger = MalletLogger.getLogger(ConfusionMatrix.class.getName());
    int numClasses;
    ArrayList classifications;
    int[][] values;
    Trial trial;

    public ConfusionMatrix(Trial t) {
        this.trial = t;
        this.classifications = t;
        Labeling tempLabeling = ((Classification)this.classifications.get(0)).getLabeling();
        this.numClasses = tempLabeling.getLabelAlphabet().size();
        this.values = new int[this.numClasses][this.numClasses];
        int i = 0;
        while (i < this.classifications.size()) {
            LabelVector lv = ((Classification)this.classifications.get(i)).getLabelVector();
            Instance inst = ((Classification)this.classifications.get(i)).getInstance();
            int bestIndex = lv.getBestIndex();
            int correctIndex = inst.getLabeling().getBestIndex();
            assert (correctIndex != -1);
            int[] nArray = this.values[correctIndex];
            int n = bestIndex;
            nArray[n] = nArray[n] + 1;
            ++i;
        }
    }

    double value(int i, int j) {
        assert (i >= 0 && j >= 0 && i < this.numClasses && j < this.numClasses);
        return this.values[i][j];
    }

    private static void appendJustifiedInt(StringBuffer sb, int i, boolean zeroDot) {
        if (i < 100) {
            sb.append(' ');
        }
        if (i < 10) {
            sb.append(' ');
        }
        if (i == 0 && zeroDot) {
            sb.append(".");
        } else {
            sb.append("" + i);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int maxLabelNameLength = 0;
        LabelAlphabet labelAlphabet = this.trial.getClassifier().getLabelAlphabet();
        int i = 0;
        while (i < this.numClasses) {
            int len = labelAlphabet.lookupLabel(i).toString().length();
            if (maxLabelNameLength < len) {
                maxLabelNameLength = len;
            }
            ++i;
        }
        double[] correctLabelCounts = new double[this.values.length];
        int i2 = 0;
        while (i2 < correctLabelCounts.length) {
            correctLabelCounts[i2] = MatrixOps.sum(this.values[i2]);
            ++i2;
        }
        double baselineAccuracy = MatrixOps.max(correctLabelCounts) / MatrixOps.sum(correctLabelCounts);
        sb.append("Confusion Matrix, row=true, column=predicted  accuracy=" + this.trial.getAccuracy() + " most-frequent-tag baseline=" + baselineAccuracy + "\n");
        int i3 = 0;
        while (i3 < maxLabelNameLength - 5 + 4) {
            sb.append(' ');
            ++i3;
        }
        sb.append("label");
        int c2 = 0;
        while (c2 < Math.min(10, this.numClasses)) {
            sb.append("   " + c2);
            ++c2;
        }
        c2 = 10;
        while (c2 < this.numClasses) {
            sb.append("  " + c2);
            ++c2;
        }
        sb.append("  |total\n");
        int c = 0;
        while (c < this.numClasses) {
            ConfusionMatrix.appendJustifiedInt(sb, c, false);
            String labelName = labelAlphabet.lookupLabel(c).toString();
            int i4 = 0;
            while (i4 < maxLabelNameLength - labelName.length()) {
                sb.append(' ');
                ++i4;
            }
            sb.append(" " + labelName + " ");
            int c22 = 0;
            while (c22 < this.numClasses) {
                ConfusionMatrix.appendJustifiedInt(sb, this.values[c][c22], true);
                sb.append(' ');
                ++c22;
            }
            sb.append(" |" + MatrixOps.sum(this.values[c]));
            sb.append('\n');
            ++c;
        }
        return sb.toString();
    }

    public double getPrecision(int predictedClassIndex) {
        int total = 0;
        int trueClassIndex = 0;
        while (trueClassIndex < this.numClasses) {
            total += this.values[trueClassIndex][predictedClassIndex];
            ++trueClassIndex;
        }
        if (total == 0) {
            return 0.0;
        }
        return (double)this.values[predictedClassIndex][predictedClassIndex] / (double)total;
    }

    public double getConfusionBetween(int class1, int class2) {
        int total = 0;
        int trueClassIndex = 0;
        while (trueClassIndex < this.numClasses) {
            total += this.values[trueClassIndex][class1];
            ++trueClassIndex;
        }
        if (total == 0) {
            return 0.0;
        }
        return (double)this.values[class2][class1] / (double)total;
    }

    public double getClassPrior(int classIndex) {
        double sum = 0.0;
        int i = 0;
        while (i < this.numClasses) {
            sum += (double)this.values[classIndex][i];
            ++i;
        }
        return sum / (double)this.classifications.size();
    }
}

