/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.iterator;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.iterator.ClusterSampleIterator;
import cc.mallet.cluster.neighbor_evaluator.AgglomerativeNeighbor;
import cc.mallet.cluster.util.ClusterUtils;
import cc.mallet.types.Instance;
import cc.mallet.util.Randoms;

public class NodeClusterSampleIterator
extends ClusterSampleIterator {
    public NodeClusterSampleIterator(Clustering clustering, Randoms random, double positiveProportion, int numberSamples) {
        super(clustering, random, positiveProportion, numberSamples);
        this.random = random;
        this.positiveProportion = positiveProportion;
        this.numberSamples = numberSamples;
    }

    @Override
    public Instance next() {
        AgglomerativeNeighbor neighbor = null;
        if (this.positiveCount < this.positiveTarget && this.nonsingletonClusters.length > 0) {
            ++this.positiveCount;
            int label = this.nonsingletonClusters[this.random.nextInt(this.nonsingletonClusters.length)];
            int[] instances = this.clustering.getIndicesWithLabel(label);
            int[] subcluster = this.sampleFromArray(instances, this.random, 2);
            int[] cluster1 = new int[]{subcluster[this.random.nextInt(subcluster.length)]};
            int[] cluster2 = new int[subcluster.length - 1];
            int nadded = 0;
            int i = 0;
            while (i < subcluster.length) {
                if (subcluster[i] != cluster1[0]) {
                    cluster2[nadded++] = subcluster[i];
                }
                ++i;
            }
            neighbor = new AgglomerativeNeighbor(this.clustering, this.clustering, cluster1, cluster2);
        } else {
            int labeli = this.random.nextInt(this.clustering.getNumClusters());
            int labelj = this.random.nextInt(this.clustering.getNumClusters());
            while (labeli == labelj) {
                labelj = this.random.nextInt(this.clustering.getNumClusters());
            }
            int[] ii = this.sampleFromArray(this.clustering.getIndicesWithLabel(labeli), this.random, 1);
            int[] ij = this.sampleFromArray(this.clustering.getIndicesWithLabel(labelj), this.random, 1);
            neighbor = new AgglomerativeNeighbor(this.clustering, ClusterUtils.copyAndMergeClusters(this.clustering, labeli, labelj), ii, new int[]{ij[this.random.nextInt(ij.length)]});
        }
        ++this.totalCount;
        return new Instance(neighbor, null, null, null);
    }
}

