/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.TransducerTrainer;
import cc.mallet.optimize.Optimizable;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public abstract class TransducerEvaluator {
    private static Logger logger = MalletLogger.getLogger(TransducerEvaluator.class.getName());
    protected InstanceList[] instanceLists;
    protected String[] instanceListDescriptions;

    public TransducerEvaluator() {
        this.instanceLists = new InstanceList[0];
        this.instanceListDescriptions = new String[0];
    }

    public TransducerEvaluator(InstanceList[] instanceLists, String[] instanceListDescriptions) {
        this.instanceLists = instanceLists;
        this.instanceListDescriptions = instanceListDescriptions;
    }

    public void evaluate(TransducerTrainer tt) {
        if (!this.precondition(tt)) {
            return;
        }
        this.preamble(tt);
        int k = 0;
        while (k < this.instanceLists.length) {
            if (this.instanceLists[k] != null) {
                this.evaluateInstanceList(tt, this.instanceLists[k], this.instanceListDescriptions[k]);
            }
            ++k;
        }
    }

    protected void preamble(TransducerTrainer tt) {
        Optimizable opt;
        int iteration = tt.getIteration();
        if (tt instanceof TransducerTrainer.ByOptimization && (opt = ((TransducerTrainer.ByOptimization)((Object)tt)).getOptimizer().getOptimizable()) instanceof Optimizable.ByValue) {
            logger.info("Evaluator iteration=" + iteration + " cost=" + ((Optimizable.ByValue)opt).getValue());
        } else {
            logger.info("Evaluator iteration=" + iteration + " cost=NA (not Optimizable.ByValue)");
        }
    }

    public boolean precondition(TransducerTrainer tt) {
        return true;
    }

    public abstract void evaluateInstanceList(TransducerTrainer var1, InstanceList var2, String var3);
}

