/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised;

import cc.mallet.fst.CRF;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.TransducerTrainer;
import cc.mallet.fst.semi_supervised.CRFOptimizableByGE;
import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.optimize.LimitedMemoryBFGS;
import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.Optimizer;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MalletLogger;
import java.util.ArrayList;
import java.util.logging.Logger;

public class CRFTrainerByGE
extends TransducerTrainer {
    private static Logger logger = MalletLogger.getLogger(CRFTrainerByGE.class.getName());
    private static final int DEFAULT_NUM_RESETS = 1;
    private static final int DEFAULT_GPV = 10;
    private boolean converged = false;
    private int iteration = 0;
    private int numThreads;
    private int numResets;
    private double gaussianPriorVariance;
    private ArrayList<GEConstraint> constraints;
    private CRF crf;
    private StateLabelMap stateLabelMap;
    private CRFOptimizableByGE optimizable;
    private Optimizer optimizer;

    public CRFTrainerByGE(CRF crf, ArrayList<GEConstraint> constraints) {
        this(crf, constraints, 1);
    }

    public CRFTrainerByGE(CRF crf, ArrayList<GEConstraint> constraints, int numThreads) {
        this.constraints = constraints;
        this.crf = crf;
        this.numThreads = numThreads;
        this.numResets = 1;
        this.gaussianPriorVariance = 10.0;
        this.stateLabelMap = new StateLabelMap(crf.getOutputAlphabet(), true);
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public Transducer getTransducer() {
        return this.crf;
    }

    @Override
    public boolean isFinishedTraining() {
        return this.converged;
    }

    public void setGaussianPriorVariance(double gpv) {
        this.gaussianPriorVariance = gpv;
    }

    public void setNumResets(int numResets) {
        this.numResets = numResets;
    }

    public void setStateLabelMap(StateLabelMap map) {
        this.stateLabelMap = map;
    }

    public void setOptimizable(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    public Optimizable.ByGradientValue getOptimizable(InstanceList unlabeled) {
        if (this.optimizable == null) {
            this.optimizable = new CRFOptimizableByGE(this.crf, this.constraints, unlabeled, this.stateLabelMap, this.numThreads);
            this.optimizable.setGaussianPriorVariance(this.gaussianPriorVariance);
        }
        return this.optimizable;
    }

    public Optimizer getOptimizer(Optimizable.ByGradientValue optimizable) {
        if (this.optimizer == null) {
            this.optimizer = new LimitedMemoryBFGS(optimizable);
        }
        return this.optimizer;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean train(InstanceList unlabeledSet, int numIterations) {
        if (!CRFTrainerByGE.$assertionsDisabled && this.constraints.size() <= 0) {
            throw new AssertionError();
        }
        if (this.constraints.size() == 0) {
            throw new RuntimeException("No constraints specified!");
        }
        this.getOptimizable(unlabeledSet);
        this.getOptimizer(this.optimizable);
        if (this.optimizer instanceof LimitedMemoryBFGS) {
            ((LimitedMemoryBFGS)this.optimizer).reset();
        }
        this.converged = false;
        CRFTrainerByGE.logger.info("CRF about to train with " + numIterations + " iterations");
        iter = 0;
        reset = 0;
        ** GOTO lbl41
        {
            block9: {
                try {
                    this.converged = this.optimizer.optimize(1);
                    ++this.iteration;
                    CRFTrainerByGE.logger.info("CRF finished one iteration of maximizer, i=" + iter);
                    this.runEvaluators();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    CRFTrainerByGE.logger.info("Catching exception; saying converged.");
                    this.converged = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CRFTrainerByGE.logger.info("Catching exception; saying converged.");
                    this.converged = true;
                }
                if (!this.converged) break block9;
                CRFTrainerByGE.logger.info("CRF training has converged, i=" + iter);
                ** GOTO lbl38
            }
            ++iter;
            do {
                if (iter < numIterations) continue block3;
lbl38:
                // 2 sources

                if (this.optimizer instanceof LimitedMemoryBFGS) {
                    ((LimitedMemoryBFGS)this.optimizer).reset();
                }
                ++reset;
lbl41:
                // 2 sources

            } while (reset < this.numResets + 1);
        }
        this.optimizable.shutdown();
        return this.converged;
    }
}

