/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.types.Instance;
import cc.mallet.util.Strings;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileIterator
implements Iterator<Instance> {
    FileFilter fileFilter;
    ArrayList<File> fileArray;
    Iterator<File> subIterator;
    Pattern targetPattern;
    File[] startingDirectories;
    int[] minFileIndex;
    int fileCount;
    int commonPrefixIndex;
    public static final String sep = "\\" + File.separatorChar;
    public static final Pattern STARTING_DIRECTORIES = Pattern.compile("_STARTING_DIRECTORIES_");
    public static final Pattern FIRST_DIRECTORY = Pattern.compile(String.valueOf(sep) + "?([^" + sep + "]*)" + sep + ".+");
    public static final Pattern LAST_DIRECTORY = Pattern.compile(".*" + sep + "([^" + sep + "]+)" + sep + "[^" + sep + "]+");
    public static final Pattern ALL_DIRECTORIES = Pattern.compile("^(.*)" + sep + "[^" + sep + "]+");

    public ArrayList<File> getFileArray() {
        return this.fileArray;
    }

    protected FileIterator(File[] directories, FileFilter fileFilter, Pattern targetPattern, boolean removeCommonPrefix) {
        this.startingDirectories = directories;
        this.fileFilter = fileFilter;
        this.minFileIndex = new int[directories.length];
        this.fileArray = new ArrayList();
        this.targetPattern = targetPattern;
        int i = 0;
        while (i < directories.length) {
            if (!directories[i].isDirectory()) {
                throw new IllegalArgumentException(String.valueOf(directories[i].getAbsolutePath()) + " is not a directory.");
            }
            this.minFileIndex[i] = this.fileArray.size();
            this.fillFileArray(directories[i], fileFilter, this.fileArray);
            ++i;
        }
        this.subIterator = this.fileArray.iterator();
        this.fileCount = 0;
        String[] dirStrings = new String[directories.length];
        int i2 = 0;
        while (i2 < directories.length) {
            dirStrings[i2] = directories[i2].toString();
            ++i2;
        }
        if (removeCommonPrefix) {
            this.commonPrefixIndex = Strings.commonPrefixIndex(dirStrings);
        }
    }

    public FileIterator(File[] directories, FileFilter fileFilter, Pattern targetPattern) {
        this(directories, fileFilter, targetPattern, false);
    }

    public FileIterator(File[] directories, Pattern targetPattern) {
        this(directories, null, targetPattern);
    }

    public FileIterator(File[] directories, Pattern targetPattern, boolean removeCommonPrefix) {
        this(directories, null, targetPattern, removeCommonPrefix);
    }

    public static File[] stringArray2FileArray(String[] sa) {
        File[] ret = new File[sa.length];
        int i = 0;
        while (i < sa.length) {
            ret[i] = new File(sa[i]);
            ++i;
        }
        return ret;
    }

    public FileIterator(String[] directories, FileFilter ff) {
        this(FileIterator.stringArray2FileArray(directories), ff, null);
    }

    public FileIterator(String[] directories, String targetPattern) {
        this(FileIterator.stringArray2FileArray(directories), Pattern.compile(targetPattern));
    }

    public FileIterator(String[] directories, Pattern targetPattern) {
        this(FileIterator.stringArray2FileArray(directories), targetPattern);
    }

    public FileIterator(String[] directories, Pattern targetPattern, boolean removeCommonPrefix) {
        this(FileIterator.stringArray2FileArray(directories), targetPattern, removeCommonPrefix);
    }

    public FileIterator(File directory, FileFilter fileFilter, Pattern targetPattern) {
        this(new File[]{directory}, fileFilter, targetPattern);
    }

    public FileIterator(File directory, FileFilter fileFilter, Pattern targetPattern, boolean removeCommonPrefix) {
        this(new File[]{directory}, fileFilter, targetPattern, removeCommonPrefix);
    }

    public FileIterator(File directory, FileFilter fileFilter) {
        this(new File[]{directory}, fileFilter, null);
    }

    public FileIterator(File directory, Pattern targetPattern) {
        this(new File[]{directory}, null, targetPattern);
    }

    public FileIterator(File directory, Pattern targetPattern, boolean removeCommonPrefix) {
        this(new File[]{directory}, null, targetPattern, removeCommonPrefix);
    }

    public FileIterator(String directory, Pattern targetPattern) {
        this(new File[]{new File(directory)}, null, targetPattern);
    }

    public FileIterator(String directory, Pattern targetPattern, boolean removeCommonPrefix) {
        this(new File[]{new File(directory)}, null, targetPattern, removeCommonPrefix);
    }

    public FileIterator(File directory) {
        this(new File[]{directory}, null, null, false);
    }

    public FileIterator(String directory) {
        this(new File[]{new File(directory)}, null, null, false);
    }

    public FileIterator(String directory, FileFilter filter) {
        this(new File[]{new File(directory)}, filter, null);
    }

    private int fillFileArray(File directory, FileFilter filter, ArrayList<File> files) {
        int count = 0;
        File[] directoryContents = directory.listFiles();
        int i = 0;
        while (i < directoryContents.length) {
            if (directoryContents[i].isDirectory()) {
                count += this.fillFileArray(directoryContents[i], filter, files);
            } else if (filter == null || filter.accept(directoryContents[i])) {
                files.add(directoryContents[i]);
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public Instance next() {
        Matcher m;
        File nextFile = this.subIterator.next();
        String path = nextFile.getAbsolutePath();
        String targetName = null;
        if (this.targetPattern == STARTING_DIRECTORIES) {
            int i = 0;
            while (i < this.minFileIndex.length) {
                if (this.minFileIndex[i] > this.fileCount) break;
                ++i;
            }
            targetName = this.startingDirectories[--i].getPath().substring(this.commonPrefixIndex);
        } else if (this.targetPattern != null && (m = this.targetPattern.matcher(path)).find()) {
            targetName = m.group(1);
        }
        ++this.fileCount;
        return new Instance(nextFile, targetName, nextFile.toURI(), null);
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }

    public File nextFile() {
        return this.subIterator.next();
    }

    @Override
    public boolean hasNext() {
        return this.subIterator.hasNext();
    }
}

