/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TokenTextNGrams
extends Pipe
implements Serializable {
    static char startBorderChar = (char)62;
    static char endBorderChar = (char)60;
    String prefix;
    int[] gramSizes;
    boolean distinguishBorders = false;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public TokenTextNGrams(String prefix, int[] gramSizes) {
        this.prefix = prefix;
        this.gramSizes = gramSizes;
    }

    public TokenTextNGrams() {
        this("CHARBIGRAM=", new int[]{2});
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        int i = 0;
        while (i < ts.size()) {
            Token t = (Token)ts.get(i);
            String s = t.getText();
            if (this.distinguishBorders) {
                s = String.valueOf(startBorderChar) + s + endBorderChar;
            }
            int slen = s.length();
            int j = 0;
            while (j < this.gramSizes.length) {
                int size = this.gramSizes[j];
                int k = 0;
                while (k < slen - size) {
                    t.setFeatureValue(s.substring(k, k + size), 1.0);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
    }
}

