/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.share.weili.ner.enron;

import cc.mallet.fst.CRF;
import cc.mallet.fst.CRFTrainerByLabelLikelihood;
import cc.mallet.fst.MultiSegmentationEvaluator;
import cc.mallet.fst.ViterbiWriter;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.PrintTokenSequenceFeatures;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.TokenSequence2FeatureVectorSequence;
import cc.mallet.pipe.iterator.FileIterator;
import cc.mallet.pipe.tsf.LexiconMembership;
import cc.mallet.pipe.tsf.OffsetConjunctions;
import cc.mallet.pipe.tsf.RegexMatches;
import cc.mallet.pipe.tsf.TrieLexiconMembership;
import cc.mallet.share.upenn.ner.NEPipes;
import cc.mallet.share.weili.ner.enron.EnronMessage2TokenSequence;
import cc.mallet.types.Alphabet;
import cc.mallet.types.InstanceList;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.regex.Pattern;

public class TUI {
    private static String CAPS = "[\\p{Lu}]";
    private static String LOW = "[\\p{Ll}]";
    private static String CAPSNUM = "[\\p{Lu}\\p{Nd}]";
    private static String ALPHA = "[\\p{Lu}\\p{Ll}]";
    private static String ALPHANUM = "[\\p{Lu}\\p{Ll}\\p{Nd}]";
    private static String PUNT = "[,\\.;:?!()]";
    private static String QUOTE = "[\"`']";

    public static void main(String[] args) throws IOException {
        String datadir = "/usr/can/tmp3/weili/NER/Enron/data";
        String conlllexdir = "/usr/col/tmp1/weili/Resource/conllDict/";
        String idflexdir = "/usr/col/tmp1/weili/Resource/idfDict/";
        String placelexdir = "/usr/col/tmp1/weili/Resource/places";
        SerialPipes conllLexiconsPipe = new SerialPipes(new Pipe[]{new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "conll/CONLLTWOPER")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "conll/CONLLTWOLOC")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "conll/CONLLTWOORG")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "conll/CONLLTWOMISC"))});
        SerialPipes googleLexiconsPipe = new SerialPipes(new Pipe[]{new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGSOCCER")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGGOVT")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGNGO")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGMILITARY")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGCOMPANY")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGBANK")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGTRADE")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGNEWS")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGOPERATINGSYSTEM")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGPOLITICALPARTY")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGTRAVEL")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGBASEBALLTEAMAUGF")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGCARMODEL")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGCARCOMPANY")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGENGLISHCOUNTYAUG")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGUNIVERSITY")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/MISCNATIONALITYAUGF")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/MISCDISEASEAUG")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/MISCTIME")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/MISCAWARDS")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/MISCMOVIESAUGF")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/MISCPOLITICALPARTY")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/MISCRELIGION")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/MISCGOVT")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/MISCWAR")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/MISCCURRENCY")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/LOC")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/PERFL")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/MISCF")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "googlesets/ORGFRAWEDITEDSORTED"))});
        SerialPipes fixedLexiconsPipe = new SerialPipes(new Pipe[]{new LexiconMembership("FIRSTHIGHEST", new File(String.valueOf(conlllexdir) + "personname/ssdi.prfirsthighest"), true), new LexiconMembership("FIRSTHIGH", new File(String.valueOf(conlllexdir) + "personname/ssdi.prfirsthigh"), true), new LexiconMembership("FIRSTMED", new File(String.valueOf(conlllexdir) + "personname/ssdi.prfirstmed"), true), new LexiconMembership("FIRSTLOW", new File(String.valueOf(conlllexdir) + "personname/ssdi.prfirstlow"), true), new LexiconMembership("LASTHIGHEST", new File(String.valueOf(conlllexdir) + "personname/ssdi.prlasthighest"), true), new LexiconMembership("LASTHIGH", new File(String.valueOf(conlllexdir) + "personname/ssdi.prlasthigh"), true), new LexiconMembership("LASTMED", new File(String.valueOf(conlllexdir) + "personname/ssdi.prlastmed"), true), new LexiconMembership("LASTLOW", new File(String.valueOf(conlllexdir) + "personname/ssdi.prlastlow"), true), new LexiconMembership("HONORIFIC", new File(String.valueOf(conlllexdir) + "personname/honorifics"), true), new LexiconMembership("NAMESUFFIX", new File(String.valueOf(conlllexdir) + "personname/namesuffixes"), true), new LexiconMembership("NAMEPARTICLE", new File(String.valueOf(conlllexdir) + "personname/name-particles"), true), new LexiconMembership("DAY", new File(String.valueOf(conlllexdir) + "days"), true), new LexiconMembership("MONTH", new File(String.valueOf(conlllexdir) + "months"), true), new LexiconMembership("PLACESUFFIX", new File(String.valueOf(conlllexdir) + "place-suffixes"), true), new TrieLexiconMembership("COUNTRY", new File(String.valueOf(conlllexdir) + "countries"), true), new TrieLexiconMembership("COUNTRYCAPITAL", new File(String.valueOf(conlllexdir) + "country-capitals"), true), new TrieLexiconMembership("USSTATE", new File(String.valueOf(conlllexdir) + "US-states"), true), new TrieLexiconMembership("COMPANYNAME", new File(String.valueOf(conlllexdir) + "company-names"), true), new TrieLexiconMembership("COMPANYSUFFIX", new File(String.valueOf(conlllexdir) + "company-suffixes"), true), new TrieLexiconMembership("CONTINENT", new File(String.valueOf(conlllexdir) + "continents"), true), new LexiconMembership("STOPWORD", new File(String.valueOf(conlllexdir) + "stopwords"), true), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "biz.yahoo/COMPANYNAME.ABBREV")), new TrieLexiconMembership(new File(String.valueOf(conlllexdir) + "utexas/UNIVERSITIES"))});
        SerialPipes idfLexiconsPipe = new SerialPipes(new Pipe[]{new TrieLexiconMembership("IDF_DES", new File(String.valueOf(idflexdir) + "designator.data"), true), new TrieLexiconMembership("IDF_FIR", new File(String.valueOf(idflexdir) + "firstnames.data"), true), new TrieLexiconMembership("IDF_LOC", new File(String.valueOf(idflexdir) + "locations.data"), true), new TrieLexiconMembership("IDF_NAT", new File(String.valueOf(idflexdir) + "nations.data"), true), new TrieLexiconMembership("IDF_ABB", new File(String.valueOf(idflexdir) + "non-final-abbrevs.data"), true), new TrieLexiconMembership("IDF_ORG", new File(String.valueOf(idflexdir) + "organization.data"), true), new TrieLexiconMembership("IDF_PER", new File(String.valueOf(idflexdir) + "person.data"), true)});
        SerialPipes spellingFeaturesPipe = new SerialPipes(new Pipe[]{new RegexMatches("INITCAP", Pattern.compile(String.valueOf(CAPS) + ".*")), new RegexMatches("CAPITALIZED", Pattern.compile(String.valueOf(CAPS) + LOW + "*")), new RegexMatches("ALLCAPS", Pattern.compile(String.valueOf(CAPS) + "+")), new RegexMatches("MIXEDCAPS", Pattern.compile("[A-Z][a-z]+[A-Z][A-Za-z]*")), new RegexMatches("CONTAINSDIGITS", Pattern.compile(".*[0-9].*")), new RegexMatches("ALLDIGITS", Pattern.compile("[0-9]+")), new RegexMatches("NUMERICAL", Pattern.compile("[-0-9]+[\\.,]+[0-9\\.,]+")), new RegexMatches("MULTIDOTS", Pattern.compile("\\.\\.+")), new RegexMatches("ENDSINDOT", Pattern.compile("[^\\.]+.*\\.")), new RegexMatches("CONTAINSDASH", Pattern.compile(String.valueOf(ALPHANUM) + "+-" + ALPHANUM + "*")), new RegexMatches("ACRO", Pattern.compile("[A-Z][A-Z\\.]*\\.[A-Z\\.]*")), new RegexMatches("LONELYINITIAL", Pattern.compile(String.valueOf(CAPS) + "\\.")), new RegexMatches("SINGLECHAR", Pattern.compile(ALPHA)), new RegexMatches("CAPLETTER", Pattern.compile("[A-Z]")), new RegexMatches("PUNC", Pattern.compile(PUNT)), new RegexMatches("QUOTE", Pattern.compile(QUOTE))});
        SerialPipes p = new SerialPipes(new Pipe[]{new EnronMessage2TokenSequence(), new NEPipes(new File(placelexdir)), conllLexiconsPipe, googleLexiconsPipe, fixedLexiconsPipe, idfLexiconsPipe, new OffsetConjunctions(new int[][]{{-1}, {1}}), new PrintTokenSequenceFeatures(), new TokenSequence2FeatureVectorSequence(true, true)});
        InstanceList ilist = new InstanceList(p);
        ilist.addThruPipe(new FileIterator(datadir, FileIterator.STARTING_DIRECTORIES));
        Random r = new Random(1L);
        InstanceList[] ilists = ilist.split(r, new double[]{0.8, 0.2});
        Alphabet targets = p.getTargetAlphabet();
        System.out.print("State labels:");
        int i = 0;
        while (i < targets.size()) {
            System.out.print(" " + targets.lookupObject(i));
            ++i;
        }
        System.out.println("");
        System.out.println("Number of features = " + p.getDataAlphabet().size());
        CRF crf = new CRF(p, null);
        crf.addStatesForThreeQuarterLabelsConnectedAsIn(ilists[0]);
        CRFTrainerByLabelLikelihood crft = new CRFTrainerByLabelLikelihood(crf);
        crft.setGaussianPriorVariance(100.0);
        int i2 = 0;
        while (i2 < crf.numStates()) {
            crf.getState(i2).setInitialWeight(Double.NEGATIVE_INFINITY);
            ++i2;
        }
        crf.getState("O").setInitialWeight(0.0);
        System.out.println("Training on " + ilists[0].size() + " training instances.");
        MultiSegmentationEvaluator eval = new MultiSegmentationEvaluator(new InstanceList[]{ilists[0], ilists[1]}, new String[]{"train", "test"}, (Object[])new String[]{"B-DATE", "B-TIME", "B-LOCATION", "B-PERSON", "B-ORGANIZATION", "B-ACRONYM", "B-PHONE", "B-MONEY", "B-PERCENT"}, (Object[])new String[]{"I-DATE", "I-TIME", "I-LOCATION", "I-PERSON", "I-ORGANIZATION", "I-ACRONYM", "I-PHONE", "I-MONEY", "I-PERCENT"});
        if (args[0].equals("FeatureInduction")) {
            throw new IllegalStateException("Feature induction not yet supported.");
        }
        if (args[0].equals("NoFeatureInduction")) {
            crft.train(ilists[0], 5, new double[]{0.1, 0.2, 0.5, 0.7});
            while (!crft.trainIncremental(ilists[0])) {
                eval.evaluate(crft);
                if (crft.getIteration() % 5 != 0) continue;
                new ViterbiWriter(args[2], ilists[0], "train", ilists[1], "test");
            }
        } else {
            System.err.println("Feature induction or not? Give me a choice.");
            System.exit(1);
        }
        crf.write(new File(args[1]));
    }
}

