/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AugmentableFeatureVector;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.FeatureSequenceWithBigrams;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.Randoms;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;

public class TopicalNGrams {
    int numTopics;
    Alphabet uniAlphabet;
    Alphabet biAlphabet;
    double alpha;
    double beta;
    double gamma;
    double delta;
    double tAlpha;
    double vBeta;
    double vGamma;
    double delta1;
    double delta2;
    InstanceList ilist;
    int[][] topics;
    int[][] grams;
    int numTypes;
    int numBitypes;
    int numTokens;
    int biTokens;
    int[][] docTopicCounts;
    int[][][] typeNgramTopicCounts;
    int[][] unitypeTopicCounts;
    int[][] bitypeTopicCounts;
    int[] tokensPerTopic;
    int[][] bitokensPerTopic;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    public TopicalNGrams(int numberOfTopics) {
        this(numberOfTopics, 50.0, 0.01, 0.01, 0.03, 0.2, 1000.0);
    }

    public TopicalNGrams(int numberOfTopics, double alphaSum, double beta, double gamma, double delta, double delta1, double delta2) {
        this.numTopics = numberOfTopics;
        this.alpha = alphaSum / (double)this.numTopics;
        this.beta = beta;
        this.gamma = gamma;
        this.delta = delta;
        this.delta1 = delta1;
        this.delta2 = delta2;
        System.out.println("alpha :" + alphaSum);
        System.out.println("beta :" + beta);
        System.out.println("gamma :" + gamma);
        System.out.println("delta :" + delta);
        System.out.println("delta1 :" + delta1);
        System.out.println("delta2 :" + delta2);
    }

    public void estimate(InstanceList documents, int numIterations, int showTopicsInterval, int outputModelInterval, String outputModelFilename, Randoms r) {
        this.ilist = documents;
        this.uniAlphabet = this.ilist.getDataAlphabet();
        this.biAlphabet = ((FeatureSequenceWithBigrams)((Instance)this.ilist.get(0)).getData()).getBiAlphabet();
        this.numTypes = this.uniAlphabet.size();
        this.numBitypes = this.biAlphabet.size();
        int numDocs = this.ilist.size();
        this.topics = new int[numDocs][];
        this.grams = new int[numDocs][];
        this.docTopicCounts = new int[numDocs][this.numTopics];
        this.typeNgramTopicCounts = new int[this.numTypes][2][this.numTopics];
        this.unitypeTopicCounts = new int[this.numTypes][this.numTopics];
        this.bitypeTopicCounts = new int[this.numBitypes][this.numTopics];
        this.tokensPerTopic = new int[this.numTopics];
        this.bitokensPerTopic = new int[this.numTypes][this.numTopics];
        this.tAlpha = this.alpha * (double)this.numTopics;
        this.vBeta = this.beta * (double)this.numTypes;
        this.vGamma = this.gamma * (double)this.numTypes;
        long startTime = System.currentTimeMillis();
        int di = 0;
        while (di < numDocs) {
            FeatureSequenceWithBigrams fs = (FeatureSequenceWithBigrams)((Instance)this.ilist.get(di)).getData();
            int seqLen = fs.getLength();
            this.numTokens += seqLen;
            this.topics[di] = new int[seqLen];
            this.grams[di] = new int[seqLen];
            int prevFi = -1;
            int prevTopic = -1;
            int si = 0;
            while (si < seqLen) {
                int gram;
                int topic = r.nextInt(this.numTopics);
                int n = gram = fs.getBiIndexAtPosition(si) == -1 ? 0 : r.nextInt(2);
                if (gram != 0) {
                    ++this.biTokens;
                }
                this.topics[di][si] = topic;
                this.grams[di][si] = gram;
                int[] nArray = this.docTopicCounts[di];
                int n2 = topic;
                nArray[n2] = nArray[n2] + 1;
                int fi = fs.getIndexAtPosition(si);
                if (prevFi != -1) {
                    int[] nArray2 = this.typeNgramTopicCounts[prevFi][gram];
                    int n3 = prevTopic;
                    nArray2[n3] = nArray2[n3] + 1;
                }
                if (gram == 0) {
                    int[] nArray3 = this.unitypeTopicCounts[fi];
                    int n4 = topic;
                    nArray3[n4] = nArray3[n4] + 1;
                    int n5 = topic;
                    this.tokensPerTopic[n5] = this.tokensPerTopic[n5] + 1;
                } else {
                    int[] nArray4 = this.bitypeTopicCounts[fs.getBiIndexAtPosition(si)];
                    int n6 = topic;
                    nArray4[n6] = nArray4[n6] + 1;
                    int[] nArray5 = this.bitokensPerTopic[prevFi];
                    int n7 = topic;
                    nArray5[n7] = nArray5[n7] + 1;
                }
                prevFi = fi;
                prevTopic = topic;
                ++si;
            }
            ++di;
        }
        int iterations = 0;
        while (iterations < numIterations) {
            this.sampleTopicsForAllDocs(r);
            if (iterations % 10 == 0) {
                System.out.print(iterations);
            } else {
                System.out.print(".");
            }
            System.out.flush();
            if (showTopicsInterval != 0 && iterations % showTopicsInterval == 0 && iterations > 0) {
                System.out.println();
                this.printTopWords(5, false);
            }
            if (outputModelInterval != 0 && iterations % outputModelInterval == 0 && iterations > 0) {
                this.write(new File(String.valueOf(outputModelFilename) + '.' + iterations));
            }
            ++iterations;
        }
        System.out.println("\nTotal time (sec): " + (double)(System.currentTimeMillis() - startTime) / 1000.0);
    }

    private void sampleTopicsForAllDocs(Randoms r) {
        double[] uniTopicWeights = new double[this.numTopics];
        double[] biTopicWeights = new double[this.numTopics * 2];
        int di = 0;
        while (di < this.topics.length) {
            this.sampleTopicsForOneDoc((FeatureSequenceWithBigrams)((Instance)this.ilist.get(di)).getData(), this.topics[di], this.grams[di], this.docTopicCounts[di], uniTopicWeights, biTopicWeights, r);
            ++di;
        }
    }

    private void sampleTopicsForOneDoc(FeatureSequenceWithBigrams oneDocTokens, int[] oneDocTopics, int[] oneDocGrams, int[] oneDocTopicCounts, double[] uniTopicWeights, double[] biTopicWeights, Randoms r) {
        int docLen = oneDocTokens.getLength();
        int si = 0;
        while (si < docLen) {
            int newTopic;
            double tw;
            int[] currentTypeTopicCounts;
            double topicWeightsSum;
            boolean bigramPossible;
            int type = oneDocTokens.getIndexAtPosition(si);
            int bitype = oneDocTokens.getBiIndexAtPosition(si);
            int oldTopic = oneDocTopics[si];
            int oldGram = oneDocGrams[si];
            int nextGram = si == docLen - 1 ? -1 : oneDocGrams[si + 1];
            boolean bl = bigramPossible = bitype != -1;
            assert (bigramPossible || oldGram != 1);
            if (!bigramPossible) {
                int n = oldTopic;
                oneDocTopicCounts[n] = oneDocTopicCounts[n] - 1;
                int n2 = oldTopic;
                this.tokensPerTopic[n2] = this.tokensPerTopic[n2] - 1;
                int[] nArray = this.unitypeTopicCounts[type];
                int n3 = oldTopic;
                nArray[n3] = nArray[n3] - 1;
                if (si != docLen - 1) {
                    int[] nArray2 = this.typeNgramTopicCounts[type][nextGram];
                    int n4 = oldTopic;
                    nArray2[n4] = nArray2[n4] - 1;
                    assert (this.typeNgramTopicCounts[type][nextGram][oldTopic] >= 0);
                }
                assert (oneDocTopicCounts[oldTopic] >= 0);
                assert (this.tokensPerTopic[oldTopic] >= 0);
                assert (this.unitypeTopicCounts[type][oldTopic] >= 0);
                Arrays.fill(uniTopicWeights, 0.0);
                topicWeightsSum = 0.0;
                currentTypeTopicCounts = this.unitypeTopicCounts[type];
                int ti = 0;
                while (ti < this.numTopics) {
                    tw = ((double)currentTypeTopicCounts[ti] + this.beta) / ((double)this.tokensPerTopic[ti] + this.vBeta) * ((double)oneDocTopicCounts[ti] + this.alpha);
                    topicWeightsSum += tw;
                    uniTopicWeights[ti] = tw;
                    ++ti;
                }
                oneDocTopics[si] = newTopic = r.nextDiscrete(uniTopicWeights, topicWeightsSum);
                int n5 = newTopic;
                oneDocTopicCounts[n5] = oneDocTopicCounts[n5] + 1;
                int[] nArray3 = this.unitypeTopicCounts[type];
                int n6 = newTopic;
                nArray3[n6] = nArray3[n6] + 1;
                int n7 = newTopic;
                this.tokensPerTopic[n7] = this.tokensPerTopic[n7] + 1;
                if (si != docLen - 1) {
                    int[] nArray4 = this.typeNgramTopicCounts[type][nextGram];
                    int n8 = newTopic;
                    nArray4[n8] = nArray4[n8] + 1;
                }
            } else {
                int prevType = oneDocTokens.getIndexAtPosition(si - 1);
                int prevTopic = oneDocTopics[si - 1];
                int n = oldTopic;
                oneDocTopicCounts[n] = oneDocTopicCounts[n] - 1;
                int[] nArray = this.typeNgramTopicCounts[prevType][oldGram];
                int n9 = prevTopic;
                nArray[n9] = nArray[n9] - 1;
                if (si != docLen - 1) {
                    int[] nArray5 = this.typeNgramTopicCounts[type][nextGram];
                    int n10 = oldTopic;
                    nArray5[n10] = nArray5[n10] - 1;
                }
                if (oldGram == 0) {
                    int[] nArray6 = this.unitypeTopicCounts[type];
                    int n11 = oldTopic;
                    nArray6[n11] = nArray6[n11] - 1;
                    int n12 = oldTopic;
                    this.tokensPerTopic[n12] = this.tokensPerTopic[n12] - 1;
                } else {
                    int[] nArray7 = this.bitypeTopicCounts[bitype];
                    int n13 = oldTopic;
                    nArray7[n13] = nArray7[n13] - 1;
                    int[] nArray8 = this.bitokensPerTopic[prevType];
                    int n14 = oldTopic;
                    nArray8[n14] = nArray8[n14] - 1;
                    --this.biTokens;
                }
                assert (oneDocTopicCounts[oldTopic] >= 0);
                assert (this.typeNgramTopicCounts[prevType][oldGram][prevTopic] >= 0);
                assert (si == docLen - 1 || this.typeNgramTopicCounts[type][nextGram][oldTopic] >= 0);
                assert (this.unitypeTopicCounts[type][oldTopic] >= 0);
                assert (this.tokensPerTopic[oldTopic] >= 0);
                assert (this.bitypeTopicCounts[bitype][oldTopic] >= 0);
                assert (this.bitokensPerTopic[prevType][oldTopic] >= 0);
                assert (this.biTokens >= 0);
                Arrays.fill(biTopicWeights, 0.0);
                topicWeightsSum = 0.0;
                currentTypeTopicCounts = this.unitypeTopicCounts[type];
                int[] currentBitypeTopicCounts = this.bitypeTopicCounts[bitype];
                int[] previousBitokensPerTopic = this.bitokensPerTopic[prevType];
                int ti = 0;
                while (ti < this.numTopics) {
                    newTopic = ti << 1;
                    tw = ((double)currentTypeTopicCounts[ti] + this.beta) / ((double)this.tokensPerTopic[ti] + this.vBeta) * ((double)oneDocTopicCounts[ti] + this.alpha) * ((double)this.typeNgramTopicCounts[prevType][0][prevTopic] + this.delta1);
                    topicWeightsSum += tw;
                    biTopicWeights[newTopic] = tw;
                    tw = ((double)currentBitypeTopicCounts[ti] + this.gamma) / ((double)previousBitokensPerTopic[ti] + this.vGamma) * ((double)oneDocTopicCounts[ti] + this.alpha) * ((double)this.typeNgramTopicCounts[prevType][1][prevTopic] + this.delta2);
                    topicWeightsSum += tw;
                    biTopicWeights[++newTopic] = tw;
                    ++ti;
                }
                newTopic = r.nextDiscrete(biTopicWeights, topicWeightsSum);
                int newGram = newTopic % 2;
                oneDocTopics[si] = newTopic /= 2;
                oneDocGrams[si] = newGram;
                int n15 = newTopic;
                oneDocTopicCounts[n15] = oneDocTopicCounts[n15] + 1;
                int[] nArray9 = this.typeNgramTopicCounts[prevType][newGram];
                int n16 = prevTopic;
                nArray9[n16] = nArray9[n16] + 1;
                if (si != docLen - 1) {
                    int[] nArray10 = this.typeNgramTopicCounts[type][nextGram];
                    int n17 = newTopic;
                    nArray10[n17] = nArray10[n17] + 1;
                }
                if (newGram == 0) {
                    int[] nArray11 = this.unitypeTopicCounts[type];
                    int n18 = newTopic;
                    nArray11[n18] = nArray11[n18] + 1;
                    int n19 = newTopic;
                    this.tokensPerTopic[n19] = this.tokensPerTopic[n19] + 1;
                } else {
                    int[] nArray12 = this.bitypeTopicCounts[bitype];
                    int n20 = newTopic;
                    nArray12[n20] = nArray12[n20] + 1;
                    int[] nArray13 = this.bitokensPerTopic[prevType];
                    int n21 = newTopic;
                    nArray13[n21] = nArray13[n21] + 1;
                    ++this.biTokens;
                }
            }
            ++si;
        }
    }

    public void printTopWords(int numWords, boolean useNewLines) {
        int ti = 0;
        while (ti < this.numTopics) {
            int i;
            int i2;
            class WordProb
            implements Comparable {
                int wi;
                double p;

                public WordProb(int wi, double p) {
                    this.wi = wi;
                    this.p = p;
                }

                public final int compareTo(Object o2) {
                    if (this.p > ((WordProb)o2).p) {
                        return -1;
                    }
                    if (this.p == ((WordProb)o2).p) {
                        return 0;
                    }
                    return 1;
                }
            }
            Object[] wp = new WordProb[this.numTypes];
            int wi = 0;
            while (wi < this.numTypes) {
                wp[wi] = new WordProb(wi, this.unitypeTopicCounts[wi][ti]);
                ++wi;
            }
            Arrays.sort(wp);
            int numToPrint = Math.min(wp.length, numWords);
            if (useNewLines) {
                System.out.println("\nTopic " + ti + " unigrams");
                i2 = 0;
                while (i2 < numToPrint) {
                    System.out.println(String.valueOf(this.uniAlphabet.lookupObject(((WordProb)wp[i2]).wi).toString()) + " " + ((WordProb)wp[i2]).p / (double)this.tokensPerTopic[ti]);
                    ++i2;
                }
            } else {
                System.out.print("Topic " + ti + ": ");
                i2 = 0;
                while (i2 < numToPrint) {
                    System.out.print(String.valueOf(this.uniAlphabet.lookupObject(((WordProb)wp[i2]).wi).toString()) + " ");
                    ++i2;
                }
            }
            AugmentableFeatureVector afv = new AugmentableFeatureVector(new Alphabet(), 10000, false);
            int di = 0;
            while (di < this.topics.length) {
                FeatureSequenceWithBigrams fs = (FeatureSequenceWithBigrams)((Instance)this.ilist.get(di)).getData();
                int si = this.topics[di].length - 1;
                while (si >= 0) {
                    if (this.topics[di][si] == ti && this.grams[di][si] == 1) {
                        String gramString = this.uniAlphabet.lookupObject(fs.getIndexAtPosition(si)).toString();
                        while (this.grams[di][si] == 1 && --si >= 0) {
                            gramString = String.valueOf(this.uniAlphabet.lookupObject(fs.getIndexAtPosition(si)).toString()) + "_" + gramString;
                        }
                        afv.add(gramString, 1.0);
                    }
                    --si;
                }
                ++di;
            }
            int numNgrams = afv.numLocations();
            wp = new WordProb[numNgrams];
            int ngramSum = 0;
            int loc = 0;
            while (loc < numNgrams) {
                wp[loc] = new WordProb(afv.indexAtLocation(loc), afv.valueAtLocation(loc));
                ngramSum = (int)((double)ngramSum + ((WordProb)wp[loc]).p);
                ++loc;
            }
            Arrays.sort(wp);
            int numUnitypeTokens = 0;
            int numBitypeTokens = 0;
            int numUnitypeTypes = 0;
            int numBitypeTypes = 0;
            int fi = 0;
            while (fi < this.numTypes) {
                numUnitypeTokens += this.unitypeTopicCounts[fi][ti];
                if (this.unitypeTopicCounts[fi][ti] != 0) {
                    ++numUnitypeTypes;
                }
                ++fi;
            }
            fi = 0;
            while (fi < this.numBitypes) {
                numBitypeTokens += this.bitypeTopicCounts[fi][ti];
                if (this.bitypeTopicCounts[fi][ti] != 0) {
                    ++numBitypeTypes;
                }
                ++fi;
            }
            if (useNewLines) {
                System.out.println("\nTopic " + ti + " unigrams " + numUnitypeTokens + "/" + numUnitypeTypes + " bigrams " + numBitypeTokens + "/" + numBitypeTypes + " phrases " + Math.round(afv.oneNorm()) + "/" + numNgrams);
                i = 0;
                while (i < Math.min(numNgrams, numWords)) {
                    System.out.println(String.valueOf(afv.getAlphabet().lookupObject(((WordProb)wp[i]).wi).toString()) + " " + ((WordProb)wp[i]).p / (double)ngramSum);
                    ++i;
                }
            } else {
                System.out.print(" (unigrams " + numUnitypeTokens + "/" + numUnitypeTypes + " bigrams " + numBitypeTokens + "/" + numBitypeTypes + " phrases " + Math.round(afv.oneNorm()) + "/" + numNgrams + ")\n         ");
                i = 0;
                while (i < Math.min(numNgrams, numWords)) {
                    System.out.print(String.valueOf(afv.getAlphabet().lookupObject(((WordProb)wp[i]).wi).toString()) + " ");
                    ++i;
                }
                System.out.println();
            }
            ++ti;
        }
    }

    public void printDocumentTopics(File f) throws IOException {
        this.printDocumentTopics(new PrintWriter(new FileWriter(f)));
    }

    public void printDocumentTopics(PrintWriter pw) {
    }

    public void printDocumentTopics(PrintWriter pw, double threshold, int max) {
        pw.println("#doc source topic proportions");
        double[] topicDist = new double[this.topics.length];
        int di = 0;
        while (di < this.topics.length) {
            pw.print(di);
            pw.print(' ');
            pw.print(((Instance)this.ilist.get(di)).getSource().toString());
            pw.print(' ');
            int docLen = this.topics[di].length;
            int ti = 0;
            while (ti < this.numTopics) {
                topicDist[ti] = (float)this.docTopicCounts[di][ti] / (float)docLen;
                ++ti;
            }
            if (max < 0) {
                max = this.numTopics;
            }
            int tp = 0;
            while (tp < max) {
                double maxvalue = 0.0;
                int maxindex = -1;
                int ti2 = 0;
                while (ti2 < this.numTopics) {
                    if (topicDist[ti2] > maxvalue) {
                        maxvalue = topicDist[ti2];
                        maxindex = ti2;
                    }
                    ++ti2;
                }
                if (maxindex == -1 || topicDist[maxindex] < threshold) break;
                pw.print(String.valueOf(maxindex) + " " + topicDist[maxindex] + " ");
                topicDist[maxindex] = 0.0;
                ++tp;
            }
            pw.println(' ');
            ++di;
        }
    }

    public void printState(File f) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(f));
        this.printState(writer);
        writer.close();
    }

    public void printState(PrintWriter pw) {
        pw.println("#doc pos typeindex type bigrampossible? topic bigram");
        int di = 0;
        while (di < this.topics.length) {
            FeatureSequenceWithBigrams fs = (FeatureSequenceWithBigrams)((Instance)this.ilist.get(di)).getData();
            int si = 0;
            while (si < this.topics[di].length) {
                int type = fs.getIndexAtPosition(si);
                pw.print(di);
                pw.print(' ');
                pw.print(si);
                pw.print(' ');
                pw.print(type);
                pw.print(' ');
                pw.print(this.uniAlphabet.lookupObject(type));
                pw.print(' ');
                pw.print(fs.getBiIndexAtPosition(si) == -1 ? 0 : 1);
                pw.print(' ');
                pw.print(this.topics[di][si]);
                pw.print(' ');
                pw.print(this.grams[di][si]);
                pw.println();
                ++si;
            }
            ++di;
        }
    }

    public void write(File f) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            System.err.println("Exception writing file " + f + ": " + e);
        }
    }

    private void writeIntArray2(int[][] a, ObjectOutputStream out) throws IOException {
        out.writeInt(a.length);
        int d2 = a[0].length;
        out.writeInt(d2);
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < d2) {
                out.writeInt(a[i][j]);
                ++j;
            }
            ++i;
        }
    }

    private int[][] readIntArray2(ObjectInputStream in) throws IOException {
        int d1 = in.readInt();
        int d2 = in.readInt();
        int[][] a = new int[d1][d2];
        int i = 0;
        while (i < d1) {
            int j = 0;
            while (j < d2) {
                a[i][j] = in.readInt();
                ++j;
            }
            ++i;
        }
        return a;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int si;
        out.writeInt(0);
        out.writeObject(this.ilist);
        out.writeInt(this.numTopics);
        out.writeDouble(this.alpha);
        out.writeDouble(this.beta);
        out.writeDouble(this.gamma);
        out.writeDouble(this.delta);
        out.writeDouble(this.tAlpha);
        out.writeDouble(this.vBeta);
        out.writeDouble(this.vGamma);
        out.writeInt(this.numTypes);
        out.writeInt(this.numBitypes);
        out.writeInt(this.numTokens);
        out.writeInt(this.biTokens);
        int di = 0;
        while (di < this.topics.length) {
            si = 0;
            while (si < this.topics[di].length) {
                out.writeInt(this.topics[di][si]);
                ++si;
            }
            ++di;
        }
        di = 0;
        while (di < this.topics.length) {
            si = 0;
            while (si < this.topics[di].length) {
                out.writeInt(this.grams[di][si]);
                ++si;
            }
            ++di;
        }
        this.writeIntArray2(this.docTopicCounts, out);
        int fi = 0;
        while (fi < this.numTypes) {
            int n = 0;
            while (n < 2) {
                int ti = 0;
                while (ti < this.numTopics) {
                    out.writeInt(this.typeNgramTopicCounts[fi][n][ti]);
                    ++ti;
                }
                ++n;
            }
            ++fi;
        }
        this.writeIntArray2(this.unitypeTopicCounts, out);
        this.writeIntArray2(this.bitypeTopicCounts, out);
        int ti = 0;
        while (ti < this.numTopics) {
            out.writeInt(this.tokensPerTopic[ti]);
            ++ti;
        }
        this.writeIntArray2(this.bitokensPerTopic, out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int si;
        int docLen;
        int version = in.readInt();
        this.ilist = (InstanceList)in.readObject();
        this.numTopics = in.readInt();
        this.alpha = in.readDouble();
        this.beta = in.readDouble();
        this.gamma = in.readDouble();
        this.delta = in.readDouble();
        this.tAlpha = in.readDouble();
        this.vBeta = in.readDouble();
        this.vGamma = in.readDouble();
        this.numTypes = in.readInt();
        this.numBitypes = in.readInt();
        this.numTokens = in.readInt();
        this.biTokens = in.readInt();
        int numDocs = this.ilist.size();
        this.topics = new int[numDocs][];
        this.grams = new int[numDocs][];
        int di = 0;
        while (di < this.ilist.size()) {
            docLen = ((FeatureSequence)((Instance)this.ilist.get(di)).getData()).getLength();
            this.topics[di] = new int[docLen];
            si = 0;
            while (si < docLen) {
                this.topics[di][si] = in.readInt();
                ++si;
            }
            ++di;
        }
        di = 0;
        while (di < this.ilist.size()) {
            docLen = ((FeatureSequence)((Instance)this.ilist.get(di)).getData()).getLength();
            this.grams[di] = new int[docLen];
            si = 0;
            while (si < docLen) {
                this.grams[di][si] = in.readInt();
                ++si;
            }
            ++di;
        }
        this.docTopicCounts = this.readIntArray2(in);
        this.typeNgramTopicCounts = new int[this.numTypes][2][this.numTopics];
        int fi = 0;
        while (fi < this.numTypes) {
            int n = 0;
            while (n < 2) {
                int ti = 0;
                while (ti < this.numTopics) {
                    this.typeNgramTopicCounts[fi][n][ti] = in.readInt();
                    ++ti;
                }
                ++n;
            }
            ++fi;
        }
        this.unitypeTopicCounts = this.readIntArray2(in);
        this.bitypeTopicCounts = this.readIntArray2(in);
        this.tokensPerTopic = new int[this.numTopics];
        int ti = 0;
        while (ti < this.numTopics) {
            this.tokensPerTopic[ti] = in.readInt();
            ++ti;
        }
        this.bitokensPerTopic = this.readIntArray2(in);
    }

    public static void main(String[] args) {
        InstanceList ilist = InstanceList.load(new File(args[0]));
        int numIterations = args.length > 1 ? Integer.parseInt(args[1]) : 1000;
        int numTopWords = args.length > 2 ? Integer.parseInt(args[2]) : 20;
        System.out.println("Data loaded.");
        TopicalNGrams tng = new TopicalNGrams(10);
        tng.estimate(ilist, 200, 1, 0, null, new Randoms());
        tng.printTopWords(60, true);
    }
}

