/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import gnu.trove.TDoubleProcedure;
import gnu.trove.TObjectProcedure;
import java.lang.reflect.Array;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static int indexOf(Object[] array, Object obj) {
        int i = 0;
        while (i < array.length) {
            if (array[i] != null && array[i].equals(obj)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int obj) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == obj) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean any(TDoubleProcedure proc, double[] v) {
        int i = 0;
        while (i < v.length) {
            if (proc.execute(v[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean any(TObjectProcedure proc, Object[][] v) {
        int i = 0;
        while (i < v.length) {
            int j = 0;
            while (j < v[i].length) {
                if (proc.execute(v[i][j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static void forEach(TObjectProcedure proc, Object[] v) {
        int i = 0;
        while (i < v.length) {
            proc.execute(v[i]);
            ++i;
        }
    }

    public static void forEach(TObjectProcedure proc, Object[][] v) {
        int i = 0;
        while (i < v.length) {
            int j = 0;
            while (j < v[i].length) {
                proc.execute(v[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public static void print(double[] v) {
        System.out.print("[");
        int i = 0;
        while (i < v.length) {
            System.out.print(" " + v[i]);
            ++i;
        }
        System.out.println(" ]");
    }

    public static void print(int[] v) {
        System.out.print("[");
        int i = 0;
        while (i < v.length) {
            System.out.print(" " + v[i]);
            ++i;
        }
        System.out.println(" ]");
    }

    public static String toString(int[] v) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < v.length) {
            buf.append(v[i]);
            if (i < v.length - 1) {
                buf.append(" ");
            }
            ++i;
        }
        return buf.toString();
    }

    public static String toString(double[] v) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < v.length) {
            buf.append(v[i]);
            if (i < v.length - 1) {
                buf.append(" ");
            }
            ++i;
        }
        return buf.toString();
    }

    public static String toString(Object[] v) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < v.length) {
            buf.append(v[i]);
            if (i < v.length - 1) {
                buf.append(" ");
            }
            ++i;
        }
        return buf.toString();
    }

    public static int[] extend(int[] a, int additional) {
        int[] ret = new int[a.length + additional];
        System.arraycopy(a, 0, ret, 0, a.length);
        return ret;
    }

    public static double[] extend(double[] a, int additional) {
        double[] ret = new double[a.length + additional];
        System.arraycopy(a, 0, ret, 0, a.length);
        return ret;
    }

    public static int[] append(int[] a1, int[] a2) {
        int[] ret = new int[a1.length + a2.length];
        System.arraycopy(a1, 0, ret, 0, a1.length);
        System.arraycopy(a2, 0, ret, a1.length, a2.length);
        return ret;
    }

    public static double[] append(double[] a1, double[] a2) {
        double[] ret = new double[a1.length + a2.length];
        System.arraycopy(a1, 0, ret, 0, a1.length);
        System.arraycopy(a2, 0, ret, a1.length, a2.length);
        return ret;
    }

    public static int[] append(int[] v, int elem) {
        int[] ret = new int[v.length + 1];
        System.arraycopy(v, 0, ret, 0, v.length);
        ret[v.length] = elem;
        return ret;
    }

    public static boolean[] append(boolean[] v, boolean elem) {
        boolean[] ret = new boolean[v.length + 1];
        System.arraycopy(v, 0, ret, 0, v.length);
        ret[v.length] = elem;
        return ret;
    }

    public static Object[] append(Object[] v, Object elem) {
        Object[] ret = (Object[])Array.newInstance(v.getClass().getComponentType(), v.length + 1);
        System.arraycopy(v, 0, ret, 0, v.length);
        ret[v.length] = elem;
        return ret;
    }

    public static double count(int[] sampled, int val) {
        int count = 0;
        int i = 0;
        while (i < sampled.length) {
            if (sampled[i] == val) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int argmax(double[] elems) {
        int bestIdx = -1;
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < elems.length) {
            double elem = elems[i];
            if (elem > max) {
                max = elem;
                bestIdx = i;
            }
            ++i;
        }
        return bestIdx;
    }

    public static boolean equals(boolean[][] m1, boolean[][] m2) {
        if (m1.length != m2.length) {
            return false;
        }
        int i = 0;
        while (i < m1.length) {
            if (m1[i].length != m2[i].length) {
                return false;
            }
            int j = 0;
            while (j < m1[i].length) {
                boolean b1 = m1[i][j];
                boolean b2 = m2[i][j];
                if (b1 != b2) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

