/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import gnu.trove.THashSet;
import gnu.trove.TObjectDoubleHashMap;
import gnu.trove.TObjectDoubleProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static String dumpToString(Collection c, String separator) {
        String retval = "";
        Iterator it = c.iterator();
        while (it.hasNext()) {
            retval = String.valueOf(retval) + String.valueOf(it.next());
            retval = String.valueOf(retval) + separator;
        }
        return retval;
    }

    public static String dumpToString(Collection c) {
        return CollectionUtils.dumpToString(c, " ");
    }

    public static void print(Collection c) {
        System.out.println(CollectionUtils.dumpToString(c));
    }

    public static void print(Collection c, String separator) {
        System.out.println(CollectionUtils.dumpToString(c, separator));
    }

    public static Collection subset(Collection c, int size, Random rand) {
        ArrayList list = new ArrayList(c);
        int realSize = size < c.size() ? size : c.size();
        Collections.shuffle(list, rand);
        return list.subList(0, realSize);
    }

    public static List sortedUnion(List args1, List args2) {
        TreeSet set = new TreeSet();
        set.addAll(args1);
        set.addAll(args2);
        ArrayList lst = new ArrayList(set.size());
        for (Object o : set) {
            lst.add(o);
        }
        return lst;
    }

    public static Collection intersection(Collection c1, Collection c2) {
        THashSet set = new THashSet(c1);
        set.retainAll(c2);
        return set;
    }

    public static Collection union(Collection c1, Collection c2) {
        THashSet set = new THashSet(c1);
        set.addAll(c2);
        return set;
    }

    public static Object argmax(TObjectDoubleHashMap map) {
        class Accumulator
        implements TObjectDoubleProcedure {
            double bestVal = Double.NEGATIVE_INFINITY;
            Object bestObj = null;

            Accumulator() {
            }

            public boolean execute(Object a, double b) {
                if (b > this.bestVal) {
                    this.bestVal = b;
                    this.bestObj = a;
                }
                return true;
            }
        }
        Accumulator procedure = new Accumulator();
        map.forEachEntry(procedure);
        return procedure.bestObj;
    }

    public static Collection map(Collection c, Fn fn) {
        Collection copy;
        Class<?> collectionClass = c.getClass();
        try {
            copy = (Collection)collectionClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            copy.add(fn.f(it.next()));
        }
        return copy;
    }

    public static interface Fn {
        public Object f(Object var1);
    }
}

