/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import cc.mallet.pipe.CharSequence2TokenSequence;
import cc.mallet.pipe.Input2CharSequence;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.TokenSequence2FeatureSequence;
import cc.mallet.pipe.iterator.CsvIterator;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public class DBInstanceStore {
    public static final int EMPTY = 0;
    public static final int STRING = 1;
    public static final int FEATURE_VECTOR = 2;
    public static final int FEATURE_SEQUENCE = 3;
    public static final int FEATURE_VECTOR_SEQUENCE = 4;
    public static final int LABEL = 5;
    boolean debug = false;
    Connection connection = null;

    public DBInstanceStore(String dbName) throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        String connectionURL = "jdbc:derby:" + dbName + ";create=true";
        this.connection = DriverManager.getConnection(connectionURL);
        ResultSet tableCheck = this.connection.getMetaData().getTables(null, null, "INSTANCES", null);
        if (!tableCheck.next()) {
            Statement createTableStatement = this.connection.createStatement();
            createTableStatement.execute("CREATE TABLE instances (instance_id INT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 0, INCREMENT BY 1), instance_name VARCHAR(500), instance_name_type INT, instance_target VARCHAR(1000), instance_target_type INT, instance_data BLOB(1M), instance_data_type INT, instance_source VARCHAR(32000), instance_source_type int)");
            createTableStatement.execute("CREATE INDEX instances_instance_id ON instances(instance_id)");
            createTableStatement.execute("CREATE TABLE data_alphabet (entry_id INT NOT NULL, entry_value VARCHAR(1000))");
            createTableStatement.execute("CREATE TABLE target_alphabet (entry_id INT NOT NULL, entry_value VARCHAR(1000))");
        }
        tableCheck.close();
        this.connection.setAutoCommit(false);
    }

    public static byte[] intArrayToByteArray(int[] src) {
        int srcLength = src.length;
        byte[] dst = new byte[srcLength << 2];
        int i = 0;
        while (i < srcLength) {
            int x = src[i];
            int j = i << 2;
            dst[j++] = (byte)(x >>> 0 & 0xFF);
            dst[j++] = (byte)(x >>> 8 & 0xFF);
            dst[j++] = (byte)(x >>> 16 & 0xFF);
            dst[j++] = (byte)(x >>> 24 & 0xFF);
            ++i;
        }
        return dst;
    }

    public static int[] byteArrayToIntArray(byte[] src) {
        int dstLength = src.length >>> 2;
        int[] dst = new int[dstLength];
        int i = 0;
        while (i < dstLength) {
            int j = i << 2;
            int x = 0;
            x += (src[j++] & 0xFF) << 0;
            x += (src[j++] & 0xFF) << 8;
            x += (src[j++] & 0xFF) << 16;
            dst[i] = x += (src[j++] & 0xFF) << 24;
            ++i;
        }
        return dst;
    }

    public void saveAlphabets(Alphabet dataAlphabet, Alphabet targetAlphabet) throws Exception {
        int i;
        PreparedStatement insertStatement;
        if (dataAlphabet != null) {
            insertStatement = this.connection.prepareStatement("INSERT INTO data_alphabet VALUES (?, ?)");
            i = 0;
            while (i < dataAlphabet.size()) {
                insertStatement.setInt(1, i);
                insertStatement.setString(2, dataAlphabet.lookupObject(i).toString());
                insertStatement.executeUpdate();
                ++i;
            }
            insertStatement.close();
        }
        if (targetAlphabet != null) {
            insertStatement = this.connection.prepareStatement("INSERT INTO target_alphabet VALUES (?, ?)");
            i = 0;
            while (i < targetAlphabet.size()) {
                insertStatement.setInt(1, i);
                insertStatement.setString(2, targetAlphabet.lookupObject(i).toString());
                insertStatement.executeUpdate();
                ++i;
            }
            insertStatement.close();
        }
        this.connection.commit();
    }

    public void saveInstances(Iterator<Instance> iterator) throws Exception {
        PreparedStatement insertStatement = this.connection.prepareStatement("INSERT INTO instances VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, NULL, 0)");
        long startTime = System.currentTimeMillis();
        int instancesSaved = 0;
        while (iterator.hasNext()) {
            Instance instance = iterator.next();
            Object name = instance.getName();
            if (!(name instanceof String)) {
                throw new Exception("Class " + name.getClass() + " is not supported");
            }
            insertStatement.setString(1, (String)name);
            insertStatement.setInt(2, 1);
            Object target = instance.getTarget();
            if (target == null) {
                insertStatement.setString(3, null);
                insertStatement.setInt(4, 0);
            } else if (target instanceof String) {
                insertStatement.setString(3, (String)target);
                insertStatement.setInt(4, 1);
            } else {
                throw new Exception("Class " + name.getClass() + " is not supported");
            }
            Object data = instance.getData();
            if (!(data instanceof FeatureSequence)) {
                throw new Exception("Class " + name.getClass() + " is not supported");
            }
            int[] features = ((FeatureSequence)data).getFeatures();
            insertStatement.setBytes(5, DBInstanceStore.intArrayToByteArray(features));
            insertStatement.setInt(6, 3);
            insertStatement.executeUpdate();
            if (++instancesSaved % 100000 != 0) continue;
            long diff = System.currentTimeMillis() - startTime;
            startTime = System.currentTimeMillis();
            System.out.println(String.valueOf(instancesSaved) + "\t" + diff);
        }
        insertStatement.close();
        this.connection.commit();
    }

    public void cleanup() throws Exception {
        String sqlState = "";
        this.connection.close();
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException se) {
            sqlState = se.getSQLState();
        }
        if (sqlState.equals("XJ015")) {
            System.err.println("shutdown successful: " + sqlState);
        }
    }

    public static void main(String[] args) throws Exception {
        DBInstanceStore saver = new DBInstanceStore(args[0]);
        ArrayList<Pipe> pipeList = new ArrayList<Pipe>();
        pipeList.add(new Input2CharSequence("UTF-8"));
        Pattern tokenPattern = Pattern.compile("\\p{L}[\\p{L}\\p{P}]*\\p{L}");
        pipeList.add(new CharSequence2TokenSequence(tokenPattern));
        pipeList.add(new TokenSequence2FeatureSequence());
        CsvIterator reader = new CsvIterator((Reader)new FileReader(new File(args[1])), "(.*?)\\t(.*?)\\t(.*)", 3, 2, 1);
        SerialPipes serialPipe = new SerialPipes(pipeList);
        Iterator<Instance> iterator = ((Pipe)serialPipe).newIteratorFrom(reader);
        saver.saveInstances(iterator);
        saver.saveAlphabets(serialPipe.getDataAlphabet(), serialPipe.getTargetAlphabet());
        saver.cleanup();
    }
}

