/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.StaleReaderException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockObtainFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexReader
implements Cloneable,
Closeable {
    private boolean closed;
    protected boolean hasChanges;
    private int refCount = 1;
    static int DEFAULT_TERMS_INDEX_DIVISOR = 1;

    public synchronized int getRefCount() {
        return this.refCount;
    }

    public synchronized void incRef() {
        assert (this.refCount > 0);
        this.ensureOpen();
        ++this.refCount;
    }

    public synchronized void decRef() throws IOException {
        assert (this.refCount > 0);
        this.ensureOpen();
        if (this.refCount == 1) {
            this.commit();
            this.doClose();
        }
        --this.refCount;
    }

    protected IndexReader() {
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.refCount <= 0) {
            throw new AlreadyClosedException("this IndexReader is closed");
        }
    }

    public static IndexReader open(Directory directory) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, null, null, true, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(Directory directory, boolean readOnly) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, null, null, readOnly, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(IndexCommit commit, boolean readOnly) throws CorruptIndexException, IOException {
        return IndexReader.open(commit.getDirectory(), null, commit, readOnly, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(Directory directory, IndexDeletionPolicy deletionPolicy, boolean readOnly) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, deletionPolicy, null, readOnly, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(Directory directory, IndexDeletionPolicy deletionPolicy, boolean readOnly, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, deletionPolicy, null, readOnly, termInfosIndexDivisor);
    }

    public static IndexReader open(IndexCommit commit, IndexDeletionPolicy deletionPolicy, boolean readOnly) throws CorruptIndexException, IOException {
        return IndexReader.open(commit.getDirectory(), deletionPolicy, commit, readOnly, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(IndexCommit commit, IndexDeletionPolicy deletionPolicy, boolean readOnly, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        return IndexReader.open(commit.getDirectory(), deletionPolicy, commit, readOnly, termInfosIndexDivisor);
    }

    private static IndexReader open(Directory directory, IndexDeletionPolicy deletionPolicy, IndexCommit commit, boolean readOnly, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        return DirectoryReader.open(directory, deletionPolicy, commit, readOnly, termInfosIndexDivisor);
    }

    public synchronized IndexReader reopen() throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support reopen().");
    }

    public synchronized IndexReader reopen(boolean openReadOnly) throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support reopen().");
    }

    public synchronized IndexReader reopen(IndexCommit commit) throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support reopen(IndexCommit).");
    }

    public synchronized Object clone() {
        throw new UnsupportedOperationException("This reader does not implement clone()");
    }

    public synchronized IndexReader clone(boolean openReadOnly) throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not implement clone()");
    }

    public Directory directory() {
        this.ensureOpen();
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public static long lastModified(final Directory directory2) throws CorruptIndexException, IOException {
        return (Long)new SegmentInfos.FindSegmentsFile(directory2){

            public Object doBody(String segmentFileName) throws IOException {
                return directory2.fileModified(segmentFileName);
            }
        }.run();
    }

    public static long getCurrentVersion(Directory directory) throws CorruptIndexException, IOException {
        return SegmentInfos.readCurrentVersion(directory);
    }

    public static Map<String, String> getCommitUserData(Directory directory) throws CorruptIndexException, IOException {
        return SegmentInfos.readCurrentUserData(directory);
    }

    public long getVersion() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public Map<String, String> getCommitUserData() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public boolean isOptimized() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public abstract TermFreqVector[] getTermFreqVectors(int var1) throws IOException;

    public abstract TermFreqVector getTermFreqVector(int var1, String var2) throws IOException;

    public abstract void getTermFreqVector(int var1, String var2, TermVectorMapper var3) throws IOException;

    public abstract void getTermFreqVector(int var1, TermVectorMapper var2) throws IOException;

    public static boolean indexExists(Directory directory) throws IOException {
        return SegmentInfos.getCurrentSegmentGeneration(directory) != -1L;
    }

    public abstract int numDocs();

    public abstract int maxDoc();

    public int numDeletedDocs() {
        return this.maxDoc() - this.numDocs();
    }

    public Document document(int n) throws CorruptIndexException, IOException {
        this.ensureOpen();
        return this.document(n, null);
    }

    public abstract Document document(int var1, FieldSelector var2) throws CorruptIndexException, IOException;

    public abstract boolean isDeleted(int var1);

    public abstract boolean hasDeletions();

    public boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        return this.norms(field) != null;
    }

    public abstract byte[] norms(String var1) throws IOException;

    public abstract void norms(String var1, byte[] var2, int var3) throws IOException;

    public synchronized void setNorm(int doc, String field, byte value) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.acquireWriteLock();
        this.hasChanges = true;
        this.doSetNorm(doc, field, value);
    }

    protected abstract void doSetNorm(int var1, String var2, byte var3) throws CorruptIndexException, IOException;

    public void setNorm(int doc, String field, float value) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.setNorm(doc, field, Similarity.encodeNorm(value));
    }

    public abstract TermEnum terms() throws IOException;

    public abstract TermEnum terms(Term var1) throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        TermDocs termDocs = this.termDocs();
        termDocs.seek(term);
        return termDocs;
    }

    public abstract TermDocs termDocs() throws IOException;

    public TermPositions termPositions(Term term) throws IOException {
        this.ensureOpen();
        TermPositions termPositions = this.termPositions();
        termPositions.seek(term);
        return termPositions;
    }

    public abstract TermPositions termPositions() throws IOException;

    public synchronized void deleteDocument(int docNum) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.acquireWriteLock();
        this.hasChanges = true;
        this.doDelete(docNum);
    }

    protected abstract void doDelete(int var1) throws CorruptIndexException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteDocuments(Term term) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        TermDocs docs = this.termDocs(term);
        if (docs == null) {
            return 0;
        }
        int n = 0;
        try {
            while (docs.next()) {
                this.deleteDocument(docs.doc());
                ++n;
            }
        }
        finally {
            docs.close();
        }
        return n;
    }

    public synchronized void undeleteAll() throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.acquireWriteLock();
        this.hasChanges = true;
        this.doUndeleteAll();
    }

    protected abstract void doUndeleteAll() throws CorruptIndexException, IOException;

    protected synchronized void acquireWriteLock() throws IOException {
    }

    public final synchronized void flush() throws IOException {
        this.ensureOpen();
        this.commit();
    }

    public final synchronized void flush(Map<String, String> commitUserData) throws IOException {
        this.ensureOpen();
        this.commit(commitUserData);
    }

    protected final synchronized void commit() throws IOException {
        this.commit(null);
    }

    public final synchronized void commit(Map<String, String> commitUserData) throws IOException {
        if (this.hasChanges) {
            this.doCommit(commitUserData);
        }
        this.hasChanges = false;
    }

    protected abstract void doCommit(Map<String, String> var1) throws IOException;

    @Override
    public final synchronized void close() throws IOException {
        if (!this.closed) {
            this.decRef();
            this.closed = true;
        }
    }

    protected abstract void doClose() throws IOException;

    public abstract Collection<String> getFieldNames(FieldOption var1);

    public IndexCommit getIndexCommit() throws IOException {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String filename = null;
        boolean extract = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-extract")) {
                extract = true;
                continue;
            }
            if (filename != null) continue;
            filename = args[i];
        }
        if (filename == null) {
            System.out.println("Usage: org.apache.lucene.index.IndexReader [-extract] <cfsfile>");
            return;
        }
        Directory dir2 = null;
        CompoundFileReader cfr = null;
        try {
            File file = new File(filename);
            String dirname = file.getAbsoluteFile().getParent();
            filename = file.getName();
            dir2 = FSDirectory.open(new File(dirname));
            cfr = new CompoundFileReader(dir2, filename);
            Object[] files = cfr.listAll();
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                long len;
                if (extract) {
                    int bufLen;
                    System.out.println("extract " + (String)files[i] + " with " + len + " bytes to local directory...");
                    IndexInput ii = cfr.openInput((String)files[i]);
                    FileOutputStream f = new FileOutputStream((String)files[i]);
                    byte[] buffer = new byte[1024];
                    int chunk = buffer.length;
                    for (len = cfr.fileLength((String)files[i]); len > 0L; len -= (long)bufLen) {
                        bufLen = (int)Math.min((long)chunk, len);
                        ii.readBytes(buffer, 0, bufLen);
                        f.write(buffer, 0, bufLen);
                    }
                    f.close();
                    ii.close();
                    continue;
                }
                System.out.println((String)files[i] + ": " + len + " bytes");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (dir2 != null) {
                    dir2.close();
                }
                if (cfr != null) {
                    cfr.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static Collection<IndexCommit> listCommits(Directory dir2) throws IOException {
        return DirectoryReader.listCommits(dir2);
    }

    public IndexReader[] getSequentialSubReaders() {
        return null;
    }

    public Object getFieldCacheKey() {
        return this;
    }

    public Object getDeletesCacheKey() {
        return this;
    }

    public long getUniqueTermCount() throws IOException {
        throw new UnsupportedOperationException("this reader does not implement getUniqueTermCount()");
    }

    public int getTermInfosIndexDivisor() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public static final class FieldOption {
        private String option;
        public static final FieldOption ALL = new FieldOption("ALL");
        public static final FieldOption INDEXED = new FieldOption("INDEXED");
        public static final FieldOption STORES_PAYLOADS = new FieldOption("STORES_PAYLOADS");
        public static final FieldOption OMIT_TERM_FREQ_AND_POSITIONS = new FieldOption("OMIT_TERM_FREQ_AND_POSITIONS");
        public static final FieldOption UNINDEXED = new FieldOption("UNINDEXED");
        public static final FieldOption INDEXED_WITH_TERMVECTOR = new FieldOption("INDEXED_WITH_TERMVECTOR");
        public static final FieldOption INDEXED_NO_TERMVECTOR = new FieldOption("INDEXED_NO_TERMVECTOR");
        public static final FieldOption TERMVECTOR = new FieldOption("TERMVECTOR");
        public static final FieldOption TERMVECTOR_WITH_POSITION = new FieldOption("TERMVECTOR_WITH_POSITION");
        public static final FieldOption TERMVECTOR_WITH_OFFSET = new FieldOption("TERMVECTOR_WITH_OFFSET");
        public static final FieldOption TERMVECTOR_WITH_POSITION_OFFSET = new FieldOption("TERMVECTOR_WITH_POSITION_OFFSET");

        private FieldOption() {
        }

        private FieldOption(String option) {
            this.option = option;
        }

        public String toString() {
            return this.option;
        }
    }
}

