/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.inference.RandomGraphs;
import cc.mallet.grmm.test.TestInference;
import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.UndirectedModel;
import cc.mallet.grmm.types.Variable;
import cc.mallet.grmm.util.Graphs;
import cc.mallet.util.ArrayUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org._3pq.jgrapht.GraphHelper;
import org._3pq.jgrapht.UndirectedGraph;

public class TestUndirectedModel
extends TestCase {
    public TestUndirectedModel(String name) {
        super(name);
    }

    public void testOutputToDot() throws IOException {
        UndirectedModel mdl = TestInference.createRandomGrid(3, 4, 2, new Random(4234L));
        PrintWriter out = new PrintWriter(new FileWriter(new File("grmm-model.dot")));
        mdl.printAsDot(out);
        out.close();
        System.out.println("Now you can open up grmm-model.dot in Graphviz.");
    }

    public void testMultipleNodePotentials() {
        Variable var = new Variable(2);
        FactorGraph mdl = new FactorGraph(new Variable[]{var});
        TableFactor ptl1 = new TableFactor(var, new double[]{0.5, 0.5});
        mdl.addFactor(ptl1);
        TableFactor ptl2 = new TableFactor(var, new double[]{0.25, 0.25});
        mdl.addFactor(ptl2);
        try {
            mdl.factorOf(var);
            TestUndirectedModel.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        List factors = mdl.allFactorsOf(var);
        AbstractTableFactor total = TableFactor.multiplyAll(factors);
        double[] expected = new double[]{0.125, 0.125};
        TestUndirectedModel.assertTrue((String)("Arrays not equal\n  Expected " + ArrayUtils.toString(expected) + "\n  Actual " + ArrayUtils.toString(((TableFactor)total).toValueArray())), (boolean)Arrays.equals(expected, ((TableFactor)total).toValueArray()));
    }

    public void testMultipleEdgePotentials() {
        Variable v1 = new Variable(2);
        Variable v2 = new Variable(2);
        Variable[] vars = new Variable[]{v1, v2};
        FactorGraph mdl = new FactorGraph(vars);
        TableFactor ptl1 = new TableFactor(vars, new double[]{0.5, 0.5, 0.5, 0.5});
        mdl.addFactor(ptl1);
        TableFactor ptl2 = new TableFactor(vars, new double[]{0.25, 0.25, 0.5, 0.5});
        mdl.addFactor(ptl2);
        try {
            mdl.factorOf(v1, v2);
            TestUndirectedModel.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Collection factors = mdl.allFactorsContaining(new HashVarSet(vars));
        TestUndirectedModel.assertEquals((int)2, (int)factors.size());
        TestUndirectedModel.assertTrue((boolean)factors.contains(ptl1));
        TestUndirectedModel.assertTrue((boolean)factors.contains(ptl2));
        double[] vals = new double[]{0.125, 0.125, 0.25, 0.25};
        AbstractTableFactor total = TableFactor.multiplyAll(factors);
        TableFactor expected = new TableFactor(vars, vals);
        TestUndirectedModel.assertTrue((String)("Arrays not equal\n  Expected " + ArrayUtils.toString(vals) + "\n  Actual " + ArrayUtils.toString(((TableFactor)total).toValueArray())), (boolean)expected.almostEquals(total, 1.0E-10));
    }

    public void testPotentialConnections() {
        Variable v1 = new Variable(2);
        Variable v2 = new Variable(2);
        Variable v3 = new Variable(2);
        Variable[] vars = new Variable[]{v1, v2, v3};
        FactorGraph mdl = new FactorGraph();
        TableFactor ptl = new TableFactor(vars, new double[8]);
        mdl.addFactor(ptl);
        TestUndirectedModel.assertTrue((boolean)mdl.isAdjacent(v1, v2));
        TestUndirectedModel.assertTrue((boolean)mdl.isAdjacent(v2, v3));
        TestUndirectedModel.assertTrue((boolean)mdl.isAdjacent(v1, v3));
    }

    public void testThreeNodeModel() {
        Random r = new Random(23534709L);
        FactorGraph mdl = new FactorGraph();
        Variable root = new Variable(2);
        Variable childL = new Variable(2);
        Variable childR = new Variable(2);
        mdl.addFactor(root, childL, RandomGraphs.generateMixedPotentialValues(r, 1.5));
        mdl.addFactor(root, childR, RandomGraphs.generateMixedPotentialValues(r, 1.5));
        TestUndirectedModel.assertTrue((boolean)mdl.isAdjacent(root, childR));
        TestUndirectedModel.assertTrue((boolean)mdl.isAdjacent(root, childL));
        TestUndirectedModel.assertTrue((!mdl.isAdjacent(childL, childR) ? 1 : 0) != 0);
        TestUndirectedModel.assertTrue((mdl.factorOf(root, childL) != null ? 1 : 0) != 0);
        TestUndirectedModel.assertTrue((mdl.factorOf(root, childR) != null ? 1 : 0) != 0);
    }

    public void testUndirectedCaches() {
        List models = TestInference.createTestModels();
        for (FactorGraph mdl : models) {
            this.verifyCachesConsistent(mdl);
        }
    }

    private void verifyCachesConsistent(FactorGraph mdl) {
        for (Factor pot : mdl.factors()) {
            Object[] vars = pot.varSet().toArray();
            switch (vars.length) {
                case 1: {
                    Factor pot2 = mdl.factorOf((Variable)vars[0]);
                    TestUndirectedModel.assertTrue((pot == pot2 ? 1 : 0) != 0);
                    break;
                }
                case 2: {
                    Variable var1 = (Variable)vars[0];
                    Variable var2 = (Variable)vars[1];
                    Factor pot2 = mdl.factorOf(var1, var2);
                    Factor pot3 = mdl.factorOf(var2, var1);
                    TestUndirectedModel.assertTrue((pot == pot2 ? 1 : 0) != 0);
                    TestUndirectedModel.assertTrue((pot2 == pot3 ? 1 : 0) != 0);
                    break;
                }
            }
        }
    }

    public void testUndirectedCachesAfterRemove() {
        List models = TestInference.createTestModels();
        for (FactorGraph mdl : models) {
            mdl = (FactorGraph)mdl.duplicate();
            mdl.remove(mdl.get(0));
            Iterator it = mdl.variablesIterator();
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                int idx = mdl.getIndex(var);
                TestUndirectedModel.assertTrue((idx >= 0 ? 1 : 0) != 0);
                TestUndirectedModel.assertTrue((idx < mdl.numVariables() ? 1 : 0) != 0);
            }
            this.verifyCachesConsistent(mdl);
        }
    }

    public void testMdlToGraph() {
        List models = TestInference.createTestModels();
        for (UndirectedModel mdl : models) {
            UndirectedGraph g = Graphs.mdlToGraph(mdl);
            Set vertices = g.vertexSet();
            TestUndirectedModel.assertEquals((int)mdl.numVariables(), (int)vertices.size());
            int numEdgePtls = 0;
            for (Factor factor : mdl.factors()) {
                if (factor.varSet().size() != 2) continue;
                ++numEdgePtls;
            }
            TestUndirectedModel.assertEquals((int)numEdgePtls, (int)g.edgeSet().size());
            for (Variable var : vertices) {
                TestUndirectedModel.assertTrue((boolean)vertices.contains(var));
                HashSet<Variable> neighborsInG = new HashSet<Variable>(GraphHelper.neighborListOf(g, var));
                neighborsInG.add(var);
                for (Factor factor : mdl.allFactorsContaining(var)) {
                    TestUndirectedModel.assertTrue((boolean)neighborsInG.containsAll(factor.varSet()));
                }
            }
        }
    }

    public void testFactorOfSet() {
        Variable[] vars = new Variable[3];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = new Variable(2);
        }
        TableFactor factor = new TableFactor(vars, new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0});
        FactorGraph fg = new FactorGraph(vars);
        fg.addFactor(factor);
        TestUndirectedModel.assertTrue((factor == fg.factorOf(factor.varSet()) ? 1 : 0) != 0);
        HashSet set = new HashSet(factor.varSet());
        TestUndirectedModel.assertTrue((factor == fg.factorOf(set) ? 1 : 0) != 0);
        set.remove(vars[0]);
        TestUndirectedModel.assertTrue((null == fg.factorOf(set) ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(TestUndirectedModel.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestUndirectedModel(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestUndirectedModel.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

