/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.AlphabetCarrying;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Alphabet
implements Serializable {
    TObjectIntHashMap map;
    ArrayList entries;
    volatile boolean growthStopped = false;
    Class entryClass = null;
    VMID instanceId = new VMID();
    private transient ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;
    private static transient ConcurrentMap<VMID, Object> deserializedEntries = new ConcurrentHashMap<VMID, Object>();

    public Alphabet(int capacity, Class entryClass) {
        this.map = new TObjectIntHashMap(capacity);
        this.entries = new ArrayList(capacity);
        this.entryClass = entryClass;
        deserializedEntries.putIfAbsent(this.instanceId, this);
    }

    public Alphabet(Class entryClass) {
        this(8, entryClass);
    }

    public Alphabet(int capacity) {
        this(capacity, null);
    }

    public Alphabet() {
        this(8, null);
    }

    public Alphabet(Object[] entries) {
        this(entries.length);
        for (Object entry : entries) {
            this.lookupIndex(entry);
        }
    }

    public Object clone() {
        this.lock.readLock().lock();
        try {
            Alphabet ret = new Alphabet();
            ret.map = this.map.clone();
            ret.entries = (ArrayList)this.entries.clone();
            ret.growthStopped = this.growthStopped;
            ret.entryClass = this.entryClass;
            Alphabet alphabet = ret;
            return alphabet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lookupIndex(Object entry, boolean addIfNotPresent) {
        if (entry == null) {
            throw new IllegalArgumentException("Can't lookup \"null\" in an Alphabet.");
        }
        if (this.entryClass == null) {
            this.entryClass = entry.getClass();
        } else if (entry.getClass() != this.entryClass) {
            throw new IllegalArgumentException("Non-matching entry class, " + entry.getClass() + ", was " + this.entryClass);
        }
        this.lock.readLock().lock();
        try {
            if (this.map.containsKey(entry)) {
                int n = this.map.get(entry);
                return n;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (!this.growthStopped && addIfNotPresent) {
            this.lock.writeLock().lock();
            try {
                int retIndex = this.entries.size();
                this.map.put(entry, retIndex);
                this.entries.add(entry);
                int n = retIndex;
                return n;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return -1;
    }

    public int lookupIndex(Object entry) {
        return this.lookupIndex(entry, true);
    }

    public Object lookupObject(int index) {
        this.lock.readLock().lock();
        try {
            Object e = this.entries.get(index);
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Object[] toArray() {
        this.lock.readLock().lock();
        try {
            Object[] objectArray = this.entries.toArray();
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Object[] toArray(Object[] in) {
        this.lock.readLock().lock();
        try {
            Object[] objectArray = this.entries.toArray(in);
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Iterator iterator() {
        this.lock.readLock().lock();
        try {
            ArrayList copy = new ArrayList();
            copy.addAll(this.entries);
            Iterator iterator = copy.iterator();
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] lookupObjects(int[] indices) {
        this.lock.readLock().lock();
        try {
            Object[] ret = new Object[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                ret[i] = this.entries.get(indices[i]);
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] lookupObjects(int[] indices, Object[] buf) {
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < indices.length; ++i) {
                buf[i] = this.entries.get(indices[i]);
            }
            Object[] objectArray = buf;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int[] lookupIndices(Object[] objects, boolean addIfNotPresent) {
        int[] ret = new int[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ret[i] = this.lookupIndex(objects[i], addIfNotPresent);
        }
        return ret;
    }

    public boolean contains(Object entry) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.map.contains(entry);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.entries.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void stopGrowth() {
        this.growthStopped = true;
    }

    public void startGrowth() {
        this.growthStopped = false;
    }

    public boolean growthStopped() {
        return this.growthStopped;
    }

    public Class entryClass() {
        return this.entryClass;
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.entries.size(); ++i) {
                sb.append(this.entries.get(i).toString());
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream out) {
        this.dump(new PrintWriter((Writer)new OutputStreamWriter(out), true));
    }

    public void dump(PrintWriter out) {
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.entries.size(); ++i) {
                out.println(i + " => " + this.entries.get(i));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static boolean alphabetsMatch(AlphabetCarrying object1, AlphabetCarrying object2) {
        Alphabet[] a2;
        Alphabet[] a1 = object1.getAlphabets();
        if (a1.length != (a2 = object2.getAlphabets()).length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            if (a1[i] == null || a2[i] == null) {
                return false;
            }
            if (a1[i].equals(a2[i])) continue;
            return false;
        }
        return true;
    }

    public VMID getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(VMID id) {
        this.instanceId = id;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.lock.readLock().lock();
        try {
            out.writeInt(1);
            out.writeInt(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                out.writeObject(this.entries.get(i));
            }
            out.writeBoolean(this.growthStopped);
            out.writeObject(this.entryClass);
            out.writeObject(this.instanceId);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.lock = new ReentrantReadWriteLock();
        this.lock.writeLock().lock();
        try {
            int version = in.readInt();
            int size = in.readInt();
            this.entries = new ArrayList(size);
            this.map = new TObjectIntHashMap(size);
            for (int i = 0; i < size; ++i) {
                Object o = in.readObject();
                this.map.put(o, i);
                this.entries.add(o);
            }
            this.growthStopped = in.readBoolean();
            this.entryClass = (Class)in.readObject();
            if (version > 0) {
                this.instanceId = (VMID)in.readObject();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Object readResolve() throws ObjectStreamException {
        Object prev;
        Object previous = deserializedEntries.get(this.instanceId);
        if (previous != null) {
            return previous;
        }
        if (this.instanceId != null && (prev = deserializedEntries.putIfAbsent(this.instanceId, this)) != null) {
            return prev;
        }
        return this;
    }
}

